/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.execute.agent;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

@org.opensearch.ml.common.annotation.MLInput(functionNames={FunctionName.AGENT})
public class AgentMLInput
extends MLInput {
    public static final String AGENT_ID_FIELD = "agent_id";
    public static final String PARAMETERS_FIELD = "parameters";
    private String agentId;
    private String tenantId;

    public AgentMLInput(String agentId, String tenantId, FunctionName functionName, MLInputDataset inputDataset) {
        this.agentId = agentId;
        this.tenantId = tenantId;
        this.algorithm = functionName;
        this.inputDataset = inputDataset;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.agentId);
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public AgentMLInput(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.agentId = in.readString();
        this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public AgentMLInput(XContentParser parser, FunctionName functionName) throws IOException {
        this.algorithm = functionName;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "agent_id": {
                    this.agentId = parser.text();
                    continue block10;
                }
                case "tenant_id": {
                    this.tenantId = parser.textOrNull();
                    continue block10;
                }
                case "parameters": {
                    Map<String, String> parameters = StringUtils.getParameterMap(parser.map());
                    this.inputDataset = new RemoteInferenceInputDataSet(parameters);
                    continue block10;
                }
            }
            parser.skipChildren();
        }
    }

    @Generated
    public static AgentMLInputBuilder AgentMLInputBuilder() {
        return new AgentMLInputBuilder();
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public static class AgentMLInputBuilder {
        @Generated
        private String agentId;
        @Generated
        private String tenantId;
        @Generated
        private FunctionName functionName;
        @Generated
        private MLInputDataset inputDataset;

        @Generated
        AgentMLInputBuilder() {
        }

        @Generated
        public AgentMLInputBuilder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        @Generated
        public AgentMLInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public AgentMLInputBuilder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        @Generated
        public AgentMLInputBuilder inputDataset(MLInputDataset inputDataset) {
            this.inputDataset = inputDataset;
            return this;
        }

        @Generated
        public AgentMLInput build() {
            return new AgentMLInput(this.agentId, this.tenantId, this.functionName, this.inputDataset);
        }

        @Generated
        public String toString() {
            return "AgentMLInput.AgentMLInputBuilder(agentId=" + this.agentId + ", tenantId=" + this.tenantId + ", functionName=" + String.valueOf((Object)this.functionName) + ", inputDataset=" + String.valueOf(this.inputDataset) + ")";
        }
    }
}

