/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util.concurrent;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.opensearch.SpecialPermission;
import org.opensearch.common.annotation.InternalApi;

@InternalApi
public final class ThreadContextAccess {
    private ThreadContextAccess() {
    }

    public static <T> T doPrivileged(PrivilegedAction<T> operation) {
        SpecialPermission.check();
        return AccessController.doPrivileged(operation);
    }

    public static void doPrivilegedVoid(Runnable action) {
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            action.run();
            return null;
        });
    }
}

