/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.suggest.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import org.apache.lucene.util.CharsRefBuilder;
import org.opensearch.core.common.text.Text;
import org.opensearch.index.mapper.CompletionFieldMapper;
import org.opensearch.search.suggest.Suggest;
import org.opensearch.search.suggest.Suggester;
import org.opensearch.search.suggest.completion.CompletionSuggestion;
import org.opensearch.search.suggest.completion.CompletionSuggestionContext;
import org.opensearch.search.suggest.completion.TopSuggestGroupDocsCollector;

public class CompletionSuggester
extends Suggester<CompletionSuggestionContext> {
    public static final CompletionSuggester INSTANCE = new CompletionSuggester();

    private CompletionSuggester() {
    }

    @Override
    protected Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, CompletionSuggestionContext suggestionContext, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        if (suggestionContext.getFieldType() != null) {
            CompletionFieldMapper.CompletionFieldType fieldType = suggestionContext.getFieldType();
            CompletionSuggestion completionSuggestion = this.emptySuggestion(name, suggestionContext, spare);
            int shardSize = suggestionContext.getShardSize() != null ? suggestionContext.getShardSize().intValue() : suggestionContext.getSize();
            TopSuggestGroupDocsCollector collector = new TopSuggestGroupDocsCollector(shardSize, suggestionContext.isSkipDuplicates());
            CompletionSuggester.suggest(searcher, suggestionContext.toQuery(), collector);
            int numResult = 0;
            for (TopSuggestDocs.SuggestScoreDoc suggestDoc : collector.get().scoreLookupDocs()) {
                List<CharSequence> rawContexts;
                Map<String, Set<String>> contexts = Collections.emptyMap();
                if (fieldType.hasContextMappings() && (rawContexts = collector.getContexts(suggestDoc.doc)).size() > 0) {
                    contexts = fieldType.getContextMappings().getNamedContexts(rawContexts);
                }
                if (numResult++ >= suggestionContext.getSize()) break;
                CompletionSuggestion.Entry.Option option = new CompletionSuggestion.Entry.Option(suggestDoc.doc, new Text(suggestDoc.key.toString()), suggestDoc.score, contexts);
                ((CompletionSuggestion.Entry)completionSuggestion.getEntries().get(0)).addOption(option);
            }
            return completionSuggestion;
        }
        return null;
    }

    private static void suggest(IndexSearcher searcher, CompletionQuery query, TopSuggestDocsCollector collector) throws IOException {
        query = (CompletionQuery)query.rewrite(searcher);
        Weight weight = query.createWeight(searcher, collector.scoreMode(), 1.0f);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            BulkScorer scorer = weight.bulkScorer(context);
            if (scorer == null) continue;
            LeafCollector leafCollector = null;
            try {
                leafCollector = collector.getLeafCollector(context);
                scorer.score(leafCollector, context.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
                // empty catch block
            }
            if (leafCollector == null) continue;
            leafCollector.finish();
        }
    }

    protected CompletionSuggestion emptySuggestion(String name, CompletionSuggestionContext suggestion, CharsRefBuilder spare) throws IOException {
        CompletionSuggestion completionSuggestion = new CompletionSuggestion(name, suggestion.getSize(), suggestion.isSkipDuplicates());
        spare.copyUTF8Bytes(suggestion.getText());
        CompletionSuggestion.Entry completionSuggestEntry = new CompletionSuggestion.Entry(new Text(spare.toString()), 0, spare.length());
        completionSuggestion.addTerm(completionSuggestEntry);
        return completionSuggestion;
    }
}

