/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.action.DeleteCustomLogTypeAction;
import org.opensearch.securityanalytics.action.DeleteCustomLogTypeRequest;

public class RestDeleteCustomLogTypeAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestDeleteCustomLogTypeAction.class);

    public String getName() {
        return "delete_custom_log_type_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/logtype", "custom_logtype_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id;
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), "/_plugins/_security_analytics/logtype"));
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
        if (request.hasParam("refresh")) {
            refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh"));
        }
        if ((id = request.param("custom_logtype_id")) == null) {
            throw new OpenSearchStatusException("Log Type id is null", RestStatus.BAD_REQUEST, new Object[0]);
        }
        DeleteCustomLogTypeRequest deleteCustomLogTypeRequest = new DeleteCustomLogTypeRequest(id, refreshPolicy);
        return channel -> client.execute((ActionType)DeleteCustomLogTypeAction.INSTANCE, (ActionRequest)deleteCustomLogTypeRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

