/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.service;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.securityanalytics.threatIntel.action.ThreatIntelIndicesResponse;
import org.opensearch.securityanalytics.threatIntel.common.TIFJobState;
import org.opensearch.securityanalytics.threatIntel.feedMetadata.BuiltInTIFMetadataLoader;
import org.opensearch.securityanalytics.threatIntel.model.TIFJobParameter;
import org.opensearch.securityanalytics.threatIntel.model.TIFMetadata;
import org.opensearch.securityanalytics.threatIntel.service.TIFJobParameterService;
import org.opensearch.securityanalytics.threatIntel.service.ThreatIntelFeedDataService;
import org.opensearch.securityanalytics.threatIntel.util.ThreatIntelFeedParser;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class TIFJobUpdateService {
    private static final Logger log = LogManager.getLogger(TIFJobUpdateService.class);
    private static final int SLEEP_TIME_IN_MILLIS = 5000;
    private static final int MAX_WAIT_TIME_FOR_REPLICATION_TO_COMPLETE_IN_MILLIS = 36000000;
    private final ClusterService clusterService;
    private final ClusterSettings clusterSettings;
    private final TIFJobParameterService jobSchedulerParameterService;
    private final ThreatIntelFeedDataService threatIntelFeedDataService;
    private final BuiltInTIFMetadataLoader builtInTIFMetadataLoader;

    public TIFJobUpdateService(ClusterService clusterService, TIFJobParameterService jobSchedulerParameterService, ThreatIntelFeedDataService threatIntelFeedDataService, BuiltInTIFMetadataLoader builtInTIFMetadataLoader) {
        this.clusterService = clusterService;
        this.clusterSettings = clusterService.getClusterSettings();
        this.jobSchedulerParameterService = jobSchedulerParameterService;
        this.threatIntelFeedDataService = threatIntelFeedDataService;
        this.builtInTIFMetadataLoader = builtInTIFMetadataLoader;
    }

    public void deleteAllTifdIndices(List<String> oldIndices, List<String> newIndices) {
        try {
            oldIndices.removeAll(newIndices);
            if (!oldIndices.isEmpty()) {
                this.deleteIndices(oldIndices);
            }
        }
        catch (Exception e) {
            log.error(() -> new ParameterizedMessage("Failed to delete old threat intel feed indices {}", (Object)StringUtils.join((Object[])new List[]{oldIndices})), (Throwable)e);
        }
    }

    private List<String> deleteIndices(List<String> indicesToDelete) {
        ArrayList<String> deletedIndices = new ArrayList<String>(indicesToDelete.size());
        for (String index : indicesToDelete) {
            if (this.clusterService.state().metadata().hasIndex(index)) continue;
            deletedIndices.add(index);
        }
        indicesToDelete.removeAll(deletedIndices);
        try {
            this.threatIntelFeedDataService.deleteThreatIntelDataIndex(indicesToDelete);
        }
        catch (Exception e) {
            log.error(() -> new ParameterizedMessage("Failed to delete old threat intel feed index [{}]", (Object)indicesToDelete), (Throwable)e);
        }
        return indicesToDelete;
    }

    public void createThreatIntelFeedData(final TIFJobParameter jobSchedulerParameter, final Runnable renewLock, final ActionListener<ThreatIntelIndicesResponse> listener) {
        final Instant startTime = Instant.now();
        ArrayList<AbstractMap.SimpleEntry<TIFJobParameter, TIFMetadata>> tifMetadataList = new ArrayList<AbstractMap.SimpleEntry<TIFJobParameter, TIFMetadata>>();
        final HashMap<String, TIFMetadata> indexTIFMetadataMap = new HashMap<String, TIFMetadata>();
        for (TIFMetadata tifMetadata : this.builtInTIFMetadataLoader.getTifMetadataList()) {
            String string = jobSchedulerParameter.newIndexName(jobSchedulerParameter, tifMetadata);
            tifMetadataList.add(new AbstractMap.SimpleEntry<TIFJobParameter, TIFMetadata>(jobSchedulerParameter, tifMetadata));
            indexTIFMetadataMap.put(string, tifMetadata);
        }
        GroupedActionListener createdThreatIntelIndices = new GroupedActionListener((ActionListener)new ActionListener<Collection<CreateIndexResponse>>(){

            public void onResponse(Collection<CreateIndexResponse> responses) {
                try {
                    int noOfUnprocessedResponses = 0;
                    for (CreateIndexResponse response : responses) {
                        String indexName = response.index();
                        TIFMetadata tifMetadata = (TIFMetadata)indexTIFMetadataMap.get(indexName);
                        if (!tifMetadata.getFeedType().equals("csv")) continue;
                        ++noOfUnprocessedResponses;
                    }
                    GroupedActionListener saveThreatIntelFeedResponseListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<ThreatIntelIndicesResponse>>(){

                        public void onResponse(Collection<ThreatIntelIndicesResponse> responses) {
                            ArrayList<String> freshIndices = new ArrayList<String>();
                            for (ThreatIntelIndicesResponse response : responses) {
                                Boolean succeeded = false;
                                if (response.isAcknowledged().booleanValue()) {
                                    String indexName = response.getIndices().get(0);
                                    TIFJobUpdateService.this.waitUntilAllShardsStarted(indexName, 36000000);
                                    freshIndices.add(indexName);
                                    succeeded = true;
                                }
                                if (succeeded.booleanValue()) continue;
                                log.error("Exception: failed to parse correct feed type");
                                this.onFailure((Exception)((Object)new OpenSearchException("Exception: failed to parse correct feed type", new Object[0])));
                            }
                            Instant endTime = Instant.now();
                            TIFJobUpdateService.this.updateJobSchedulerParameterAsSucceeded(freshIndices, jobSchedulerParameter, startTime, endTime, (ActionListener<ThreatIntelIndicesResponse>)listener);
                        }

                        public void onFailure(Exception e) {
                            listener.onFailure(e);
                        }
                    }, noOfUnprocessedResponses);
                    block14: for (CreateIndexResponse response : responses) {
                        String indexName = response.index();
                        TIFMetadata tifMetadata = (TIFMetadata)indexTIFMetadataMap.get(indexName);
                        switch (tifMetadata.getFeedType()) {
                            case "csv": {
                                CSVParser reader = ThreatIntelFeedParser.getThreatIntelFeedReaderCSV(tifMetadata);
                                try {
                                    CSVParser noHeaderReader = ThreatIntelFeedParser.getThreatIntelFeedReaderCSV(tifMetadata);
                                    boolean notFound = true;
                                    while (notFound) {
                                        CSVRecord hasHeaderRecord = (CSVRecord)reader.iterator().next();
                                        if (hasHeaderRecord.values().length == 1 && "".equals(hasHeaderRecord.values()[0]) || hasHeaderRecord.get(0).charAt(0) == '#' || hasHeaderRecord.get(0).charAt(0) == ' ') {
                                            noHeaderReader.iterator().next();
                                            continue;
                                        }
                                        notFound = false;
                                    }
                                    if (tifMetadata.hasHeader().booleanValue()) {
                                        TIFJobUpdateService.this.threatIntelFeedDataService.parseAndSaveThreatIntelFeedDataCSV(indexName, reader.iterator(), renewLock, tifMetadata, (ActionListener<ThreatIntelIndicesResponse>)saveThreatIntelFeedResponseListener);
                                        continue block14;
                                    }
                                    TIFJobUpdateService.this.threatIntelFeedDataService.parseAndSaveThreatIntelFeedDataCSV(indexName, noHeaderReader.iterator(), renewLock, tifMetadata, (ActionListener<ThreatIntelIndicesResponse>)saveThreatIntelFeedResponseListener);
                                    continue block14;
                                }
                                finally {
                                    if (reader == null) continue block14;
                                    reader.close();
                                    continue block14;
                                }
                            }
                            default: {
                                this.onFailure(new UnsupportedOperationException("Not a supported feed format : " + tifMetadata.getFeedType()));
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    this.onFailure(ex);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, tifMetadataList.size());
        for (AbstractMap.SimpleEntry simpleEntry : tifMetadataList) {
            this.setupIndex((TIFJobParameter)simpleEntry.getKey(), (TIFMetadata)simpleEntry.getValue(), (ActionListener<CreateIndexResponse>)createdThreatIntelIndices);
        }
    }

    public void updateJobSchedulerParameterAsSucceeded(List<String> indices, TIFJobParameter jobSchedulerParameter, Instant startTime, Instant endTime, ActionListener<ThreatIntelIndicesResponse> listener) {
        jobSchedulerParameter.setIndices(indices);
        jobSchedulerParameter.getUpdateStats().setLastSucceededAt(endTime);
        jobSchedulerParameter.getUpdateStats().setLastProcessingTimeInMillis(endTime.toEpochMilli() - startTime.toEpochMilli());
        jobSchedulerParameter.enable();
        jobSchedulerParameter.setState(TIFJobState.AVAILABLE);
        this.jobSchedulerParameterService.updateJobSchedulerParameter(jobSchedulerParameter, listener);
        log.info("threat intel feed data creation succeeded for {} and took {} seconds", (Object)jobSchedulerParameter.getName(), (Object)Duration.between(startTime, endTime));
    }

    private void setupIndex(TIFJobParameter jobSchedulerParameter, TIFMetadata tifMetadata, final ActionListener<CreateIndexResponse> listener) {
        final String indexName = jobSchedulerParameter.newIndexName(jobSchedulerParameter, tifMetadata);
        jobSchedulerParameter.getIndices().add(indexName);
        this.jobSchedulerParameterService.updateJobSchedulerParameter(jobSchedulerParameter, new ActionListener<ThreatIntelIndicesResponse>(){

            public void onResponse(ThreatIntelIndicesResponse response) {
                if (response.isAcknowledged().booleanValue()) {
                    TIFJobUpdateService.this.threatIntelFeedDataService.createIndexIfNotExists(indexName, (ActionListener<CreateIndexResponse>)listener);
                } else {
                    this.onFailure((Exception)new OpenSearchStatusException("update of job scheduler parameter failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    protected void waitUntilAllShardsStarted(String indexName, int timeout) {
        Instant start = Instant.now();
        try {
            while (Instant.now().toEpochMilli() - start.toEpochMilli() < (long)timeout) {
                if (this.clusterService.state().routingTable().allShards(indexName).stream().allMatch(shard -> shard.started())) {
                    return;
                }
                Thread.sleep(5000L);
            }
            throw new OpenSearchException("index[{}] replication did not complete after {} millis", new Object[]{36000000});
        }
        catch (InterruptedException e) {
            log.error("runtime exception", (Throwable)e);
            throw new SecurityAnalyticsException("Runtime exception", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
    }
}

