/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatsType;

public enum RcaVerticesMetrics implements MeasurementSet
{
    INVALID_OLD_GEN_SIZE("InvalidOldGenSize"),
    OLD_GEN_RECLAMATION_INEFFECTIVE("OldGenReclamationIneffective"),
    OLD_GEN_CONTENDED("OldGenContended"),
    OLD_GEN_OVER_OCCUPIED("OldGenOverOccupied"),
    NUM_YOUNG_GEN_RCA_TRIGGERED("YoungGenRcaCount"),
    NUM_OLD_GEN_RCA_TRIGGERED("OldGenRcaCount"),
    NUM_HIGH_HEAP_CLUSTER_RCA_TRIGGERED("HighHeapClusterRcaCount"),
    YOUNG_GEN_RCA_NAMED_COUNT("YoungGenRcaNamedCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    NUM_FIELD_DATA_CACHE_RCA_TRIGGERED("FieldDataCacheRcaCount"),
    NUM_SHARD_REQUEST_CACHE_RCA_TRIGGERED("ShardRequestCacheCount"),
    HOT_SHARD_RCA_ERROR("HotShardRcaError"),
    ADMISSION_CONTROL_RCA_TRIGGERED("AdmissionControlRcaCount"),
    CLUSTER_RCA_NAMED_COUNT("ClusterRcaNamedCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS));

    private String name;
    private String unit;
    private StatsType statsType;
    private List<Statistics> statsList;

    private RcaVerticesMetrics(String name) {
        this(name, "count", StatsType.STATS_DATA, Collections.singletonList(Statistics.COUNT));
    }

    private RcaVerticesMetrics(String name, String unit, StatsType statType, List<Statistics> statisticList) {
        this.name = name;
        this.unit = unit;
        this.statsType = statType;
        this.statsList = statisticList;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    public StatsType getStatsType() {
        return this.statsType;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }
}

