/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.transport.agent.MLAgentDeleteRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteAgentTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteAgentTransportAction.class);
    Client client;
    SdkClient sdkClient;
    NamedXContentRegistry xContentRegistry;
    ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteAgentTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/agents/delete", transportService, actionFilters, MLAgentDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLAgentDeleteRequest mlAgentDeleteRequest = MLAgentDeleteRequest.fromActionRequest((ActionRequest)request);
        String agentId = mlAgentDeleteRequest.getAgentId();
        String tenantId = mlAgentDeleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-agent")).id(agentId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block21: {
                    log.debug("Completed Get Agent Request, Agent id:{}", (Object)agentId);
                    if (throwable != null) {
                        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (ExceptionsHelper.unwrap((Throwable)throwable, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            log.info("Failed to get Agent index", (Throwable)cause);
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to get agent index", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get ML Agent {}", (Object)agentId, (Object)cause);
                            wrappedListener.onFailure(cause);
                        }
                    } else {
                        try {
                            GetResponse gr;
                            GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            assert (gr != null);
                            if (gr.isExists()) {
                                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    MLAgent mlAgent = MLAgent.parse((XContentParser)parser);
                                    if (TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlAgent.getTenantId(), wrappedListener)) {
                                        if (mlAgent.getIsHidden().booleanValue() && !isSuperAdmin) {
                                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this agent", RestStatus.FORBIDDEN, new Object[0]));
                                        } else {
                                            DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-agent", agentId);
                                            try {
                                                this.sdkClient.deleteDataObjectAsync(((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(deleteRequest.index())).id(deleteRequest.id())).tenantId(tenantId)).build()).whenComplete((response, delThrowable) -> this.handleDeleteResponse((DeleteDataObjectResponse)response, (Throwable)delThrowable, tenantId, (ActionListener<DeleteResponse>)wrappedListener));
                                            }
                                            catch (Exception e) {
                                                log.error("Failed to delete ML agent: {}", (Object)agentId, (Object)e);
                                                wrappedListener.onFailure(e);
                                            }
                                        }
                                    }
                                    break block21;
                                }
                                catch (Exception e) {
                                    log.error("Failed to parse ml agent {}", (Object)agentId, (Object)e);
                                    wrappedListener.onFailure(e);
                                }
                                break block21;
                            }
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Fail to find ml agent", RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e) {
                            log.error("Failed to delete ML agent: {}", (Object)agentId, (Object)e);
                            wrappedListener.onFailure(e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ml agent {}", (Object)agentId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }

    private void handleDeleteResponse(DeleteDataObjectResponse response, Throwable throwable, String agentId, ActionListener<DeleteResponse> actionListener) {
        if (throwable != null) {
            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            log.error("Failed to delete ML Agent : {}", (Object)agentId, (Object)cause);
            actionListener.onFailure(cause);
        } else {
            try {
                DeleteResponse deleteResponse = DeleteResponse.fromXContent((XContentParser)response.parser());
                log.info("Agent deletion result: {}, agent id: {}", (Object)deleteResponse.getResult(), (Object)response.id());
                actionListener.onResponse((Object)deleteResponse);
            }
            catch (Exception e) {
                actionListener.onFailure(e);
            }
        }
    }
}

