/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.transport.model.MLModelDeleteAction;
import org.opensearch.ml.common.transport.model.MLModelDeleteRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLDeleteModelAction
extends BaseRestHandler {
    private static final String ML_DELETE_MODEL_ACTION = "ml_delete_model_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DELETE_MODEL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/models/{%s}", "/_plugins/_ml", "model_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String modelId = request.param("model_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        MLModelDeleteRequest mlModelDeleteRequest = new MLModelDeleteRequest(modelId, tenantId);
        return channel -> client.execute((ActionType)MLModelDeleteAction.INSTANCE, (ActionRequest)mlModelDeleteRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

