/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.gui.mapviewer.MapViewerBounds;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.util.Utils;

public class MapViewerRepaintManager {
    private VolatileImage backBufferImage = null;
    private BufferedImage nonAnimationBufferImage = null;
    private Rectangle dirtyRegion = new Rectangle(0, 0, 0, 0);
    private Tile focus = null;
    private Point focusPoint = null;
    private boolean repaintsBlocked = false;
    private final Set<Tile> dirtyTiles = new HashSet<Tile>();

    MapViewerRepaintManager() {
    }

    boolean prepareBuffers(MapViewerBounds mapViewerBounds, Tile focus) {
        assert (SwingUtilities.isEventDispatchThread());
        Dimension size = mapViewerBounds.getSize();
        Tile oldFocus = this.focus;
        Point oldFocusPoint = this.focusPoint;
        this.focus = focus;
        this.focusPoint = mapViewerBounds.tileToPoint(focus);
        this.repaintsBlocked = false;
        if (this.isBuffersUninitialized(size)) {
            this.initializeBuffers(size);
            this.markAsDirty();
            this.dirtyTiles.clear();
            return true;
        }
        if (this.isAllDirty()) {
            this.dirtyTiles.clear();
            return false;
        }
        if (oldFocus == null) {
            this.markAsDirty();
            this.dirtyTiles.clear();
            return false;
        }
        this.updateDirtyRegionWithDirtyTiles(mapViewerBounds);
        this.reuseNonDirtyAreasIfPossible(mapViewerBounds, oldFocus, oldFocusPoint);
        return false;
    }

    private void initializeBuffers(Dimension size) {
        this.backBufferImage = Utils.getGoodGraphicsDevice().getDefaultConfiguration().createCompatibleVolatileImage(size.width, size.height, 1);
        this.nonAnimationBufferImage = Utils.getGoodGraphicsDevice().getDefaultConfiguration().createCompatibleImage(size.width, size.height, 3);
    }

    Rectangle getDirtyClipBounds() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.dirtyRegion;
    }

    public boolean isAllDirty() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.backBufferImage == null || this.dirtyRegion != null && this.dirtyRegion.x == 0 && this.dirtyRegion.y == 0 && this.dirtyRegion.width == this.backBufferImage.getWidth() && this.dirtyRegion.height == this.backBufferImage.getHeight();
    }

    public void markAsDirty(Rectangle bounds) {
        assert (SwingUtilities.isEventDispatchThread());
        this.dirtyRegion = this.dirtyRegion.isEmpty() ? bounds : this.dirtyRegion.union(bounds);
    }

    public void markAsDirty(Tile dirtyTile) {
        assert (SwingUtilities.isEventDispatchThread());
        Objects.requireNonNull(dirtyTile, "dirtyTile");
        this.dirtyTiles.add(dirtyTile);
    }

    public void markAsDirty(Collection<Tile> dirtyTiles) {
        assert (SwingUtilities.isEventDispatchThread());
        this.dirtyTiles.addAll(dirtyTiles);
    }

    public void markAsDirty() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.backBufferImage == null) {
            this.dirtyRegion = null;
            return;
        }
        this.dirtyRegion = new Rectangle(0, 0, this.backBufferImage.getWidth(), this.backBufferImage.getHeight());
    }

    void markAsClean() {
        assert (SwingUtilities.isEventDispatchThread());
        this.dirtyRegion = new Rectangle(0, 0, 0, 0);
    }

    VolatileImage getBackBufferImage() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.backBufferImage;
    }

    BufferedImage getNonAnimationBufferImage() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.nonAnimationBufferImage;
    }

    public void setRepaintsBlocked(boolean repaintsBlocked) {
        assert (SwingUtilities.isEventDispatchThread());
        this.repaintsBlocked = repaintsBlocked;
    }

    boolean isRepaintsBlocked(Dimension size) {
        assert (SwingUtilities.isEventDispatchThread());
        return this.repaintsBlocked && !this.isBuffersUninitialized(size);
    }

    private boolean isBuffersUninitialized(Dimension size) {
        return this.backBufferImage == null || this.backBufferImage.getWidth() != size.width || this.backBufferImage.getHeight() != size.height;
    }

    private void reuseNonDirtyAreasIfPossible(MapViewerBounds mapViewerBounds, Tile oldFocus, Point oldFocusPoint) {
        Point repositionedOldFocusPoint = mapViewerBounds.tileToPoint(oldFocus);
        int dx = repositionedOldFocusPoint.x - oldFocusPoint.x;
        int dy = repositionedOldFocusPoint.y - oldFocusPoint.y;
        this.updateDirtyRegion(mapViewerBounds, dx, dy);
        if (!this.isAllDirty()) {
            MapViewerRepaintManager.moveContents(this.backBufferImage, dx, dy);
            this.nonAnimationBufferImage = MapViewerRepaintManager.moveContentsAndRecreateImage(this.nonAnimationBufferImage, dx, dy);
        }
    }

    private void updateDirtyRegion(MapViewerBounds mapViewerBounds, int dx, int dy) {
        Dimension size = mapViewerBounds.getSize();
        Rectangle alreadyPaintedBounds = new Rectangle(0, 0, size.width, size.height);
        alreadyPaintedBounds.translate(dx, dy);
        Area dirtyArea = new Area(new Rectangle(0, 0, size.width, size.height));
        dirtyArea.subtract(new Area(alreadyPaintedBounds));
        Rectangle newDirtyBounds = dirtyArea.getBounds();
        this.dirtyRegion = this.dirtyRegion != null && !this.dirtyRegion.isEmpty() ? this.dirtyRegion.union(newDirtyBounds) : newDirtyBounds;
        this.dirtyRegion = this.dirtyRegion.intersection(new Rectangle(0, 0, size.width, size.height));
    }

    private static void moveContents(Image image, int dx, int dy) {
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.copyArea(0, 0, image.getWidth(null), image.getHeight(null), dx, dy);
        g2d.dispose();
    }

    private static BufferedImage moveContentsAndRecreateImage(BufferedImage image, int dx, int dy) {
        BufferedImage result = Utils.getGoodGraphicsDevice().getDefaultConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)image, dx, dy, null);
        g2d.dispose();
        return result;
    }

    private void updateDirtyRegionWithDirtyTiles(MapViewerBounds mapViewerBounds) {
        for (Tile dirtyTile : this.dirtyTiles) {
            Rectangle dirtyTileBounds = mapViewerBounds.calculateDrawnTileBounds(dirtyTile);
            if (this.dirtyRegion.isEmpty()) {
                this.dirtyRegion = dirtyTileBounds;
                continue;
            }
            this.dirtyRegion = this.dirtyRegion.union(dirtyTileBounds);
        }
        this.dirtyTiles.clear();
    }
}

