/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.ScrollMode;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;

public class StandardStatementCreator
implements JdbcSelectExecutor.StatementCreator {
    static final StandardStatementCreator[] INSTANCES;
    final @Nullable ScrollMode scrollMode;

    public static JdbcSelectExecutor.StatementCreator getStatementCreator(@Nullable ScrollMode scrollMode) {
        return INSTANCES[scrollMode == null ? INSTANCES.length - 1 : scrollMode.ordinal()];
    }

    private StandardStatementCreator(@Nullable ScrollMode scrollMode) {
        this.scrollMode = scrollMode;
    }

    @Override
    public PreparedStatement createStatement(ExecutionContext executionContext, String sql) throws SQLException {
        return executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareQueryStatement(sql, false, this.scrollMode);
    }

    static {
        ScrollMode[] values = ScrollMode.values();
        StandardStatementCreator[] instances = new StandardStatementCreator[values.length + 1];
        for (int i = 0; i < values.length; ++i) {
            instances[i] = new StandardStatementCreator(values[i]);
        }
        instances[values.length] = new StandardStatementCreator(null);
        INSTANCES = instances;
    }
}

