#!/usr/bin/env python3
from datetime import datetime, date

import pytz
from termcolor import colored as do_color
from sys import stderr

from importlib.metadata import version

KOSMORRO_VERSION = version("kosmorro")
KOSMORROLIB_VERSION = version("kosmorrolib")


global _COLORS_ACTIVATED


def set_colors_activated(activated: bool):
    global _COLORS_ACTIVATED
    _COLORS_ACTIVATED = activated


def colored(text, color=None, on_color=None, attrs=None):
    """Decorator to use colors only when they are activated"""
    if not _COLORS_ACTIVATED:
        return text

    return do_color(text, color, on_color, attrs)


def print_stderr(*values: object):
    print(*values, file=stderr)


def get_timezone(value: int | str, dt: datetime | date) -> float:
    try:
        timezone = float(value)
    except ValueError:
        if isinstance(dt, date):
            dt = datetime.combine(dt, datetime.min.time())
        timezone = pytz.timezone(value).utcoffset(dt).total_seconds() / 3600

    return timezone
