/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.operation.relateng.BasicPredicate;

abstract class IMPredicate
extends BasicPredicate {
    static final int DIM_UNKNOWN = -3;
    protected int dimA;
    protected int dimB;
    protected IntersectionMatrix intMatrix = new IntersectionMatrix();

    public static boolean isDimsCompatibleWithCovers(int dim0, int dim1) {
        if (dim0 == 0 && dim1 == 1) {
            return true;
        }
        return dim0 >= dim1;
    }

    public IMPredicate() {
        this.intMatrix.set(2, 2, 2);
    }

    @Override
    public void init(int dimA, int dimB) {
        this.dimA = dimA;
        this.dimB = dimB;
    }

    @Override
    public void updateDimension(int locA, int locB, int dimension) {
        if (this.isDimChanged(locA, locB, dimension)) {
            this.intMatrix.set(locA, locB, dimension);
            if (this.isDetermined()) {
                this.setValue(this.valueIM());
            }
        }
    }

    public boolean isDimChanged(int locA, int locB, int dimension) {
        return dimension > this.intMatrix.get(locA, locB);
    }

    protected abstract boolean isDetermined();

    protected boolean intersectsExteriorOf(boolean isA) {
        if (isA) {
            return this.isIntersects(2, 0) || this.isIntersects(2, 1);
        }
        return this.isIntersects(0, 2) || this.isIntersects(1, 2);
    }

    protected boolean isIntersects(int locA, int locB) {
        return this.intMatrix.get(locA, locB) >= 0;
    }

    public boolean isKnown(int locA, int locB) {
        return this.intMatrix.get(locA, locB) != -3;
    }

    public boolean isDimension(int locA, int locB, int dimension) {
        return this.intMatrix.get(locA, locB) == dimension;
    }

    public int getDimension(int locA, int locB) {
        return this.intMatrix.get(locA, locB);
    }

    @Override
    public void finish() {
        this.setValue(this.valueIM());
    }

    protected abstract boolean valueIM();

    public String toString() {
        return this.name() + ": " + this.intMatrix;
    }
}

