/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.enterprise.DomainCategorySnapshot;
import ca.sqlpower.architect.swingui.dbtree.DBTreeCellRenderer;
import ca.sqlpower.architect.swingui.dbtree.IconFilter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.ComposedIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DomainCategorySnapshotIconFilter
implements IconFilter {
    public static final ImageIcon DOMAIN_CATEGORY_ICON = new ImageIcon(DomainCategorySnapshotIconFilter.class.getResource("icons/category.png"));

    @Override
    public Icon filterIcon(Icon original, SPObject node) {
        if (node instanceof DomainCategorySnapshot) {
            ImageIcon icon = DOMAIN_CATEGORY_ICON;
            if (((DomainCategorySnapshot)node).isDeleted()) {
                icon = ComposedIcon.getInstance((Icon[])new Icon[]{icon, DBTreeCellRenderer.ERROR_BADGE});
            } else if (((DomainCategorySnapshot)node).isObsolete()) {
                BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                Graphics2D g = bufferedImage.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(DBTreeCellRenderer.REFRESH_ICON.getImage(), 8, 8, 8, 8, new Color(-1, true), null);
                g.dispose();
                icon = ComposedIcon.getInstance((Icon[])new Icon[]{icon, new ImageIcon(bufferedImage)});
            }
            return icon;
        }
        return original;
    }
}

