/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public class AbstractGoods
extends FreeColObject
implements Named {
    public static final Comparator<AbstractGoods> ascendingAmountComparator = Comparator.comparingInt(AbstractGoods::getAmount).thenComparing(AbstractGoods::getType, GoodsType.goodsTypeComparator);
    public static final Comparator<AbstractGoods> descendingAmountComparator = Comparator.comparingInt(AbstractGoods::getAmount).reversed().thenComparing(AbstractGoods::getType, GoodsType.goodsTypeComparator);
    protected GoodsType type;
    protected int amount;

    public AbstractGoods() {
    }

    public AbstractGoods(GoodsType type, int amount) {
        this.setId(type.getId());
        this.type = type;
        this.amount = amount;
    }

    public AbstractGoods(AbstractGoods other) {
        this.setId(other.type.getId());
        this.type = other.type;
        this.amount = other.amount;
    }

    public final GoodsType getType() {
        return this.type;
    }

    public final void setType(GoodsType newType) {
        this.type = newType;
    }

    public final boolean isFoodType() {
        return this.getType().isFoodType();
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int newAmount) {
        this.amount = newAmount;
    }

    public final boolean isPositive() {
        return this.getAmount() > 0;
    }

    public boolean isStorable() {
        return this.getType().isStorable();
    }

    public StringTemplate getLabel() {
        return ((StringTemplate)StringTemplate.template("model.abstractGoods.label").addNamed("%goods%", this.getType())).addAmount("%amount%", this.getAmount());
    }

    public StringTemplate getLabel(boolean sellable) {
        return sellable ? this.getLabel() : ((StringTemplate)StringTemplate.template("model.abstractGoods.boycotted").addNamed("%goods%", this.getType())).addAmount("%amount%", this.getAmount());
    }

    public static StringTemplate getAbstractLabel(String key, int amount) {
        return ((StringTemplate)StringTemplate.template("model.abstractGoods.label").add("%goods%", key)).addAmount("%amount%", amount);
    }

    public static int getCount(GoodsType type, Collection<? extends AbstractGoods> goods) {
        AbstractGoods ag = CollectionUtils.find(goods, AbstractGoods.matches(type));
        return ag == null ? 0 : ag.getAmount();
    }

    public int evaluateFor(Player player) {
        Market market = player.getMarket();
        return market == null ? this.getAmount() * 2 : market.getSalePrice(this.getType(), this.getAmount());
    }

    public static final Predicate<? super AbstractGoods> matches(GoodsType key) {
        return CollectionUtils.matchKey(key, AbstractGoods::getType);
    }

    @Override
    public String getNameKey() {
        return this.getType().getNameKey();
    }

    @Override
    public String getXMLTagName() {
        return null;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        AbstractGoods o = this.copyInCast(other, AbstractGoods.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.type = o.getType();
        this.amount = o.getAmount();
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractGoods) {
            AbstractGoods other = (AbstractGoods)o;
            return this.type == other.type && this.amount == other.amount && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Utils.hashCode(this.type);
        hash = 31 * hash + this.amount;
        return hash;
    }

    @Override
    public String toString() {
        return AbstractGoods.toFullString(this.getType(), this.getAmount());
    }

    public static String toFullString(GoodsType goodsType, int amount) {
        return amount + " " + (goodsType == null ? "(null)" : goodsType.getSuffix());
    }
}

