/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class BaseCostDeciderTest
extends FreeColTestCase {
    private static final GoodsType tradeGoodsType = BaseCostDeciderTest.spec().getGoodsType("model.goods.tradeGoods");
    private static final TileType plainsType = BaseCostDeciderTest.spec().getTileType("model.tile.plains");
    private static final UnitType colonistType = BaseCostDeciderTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType galleonType = BaseCostDeciderTest.spec().getUnitType("model.unit.galleon");
    private static final UnitType pioneerType = BaseCostDeciderTest.spec().getUnitType("model.unit.hardyPioneer");
    private Game game;

    @Override
    public void setUp() {
        this.game = BaseCostDeciderTest.getStandardGame();
    }

    @Override
    public void tearDown() {
        this.game = null;
    }

    public void testGetCostLandLand() {
        Map map = BaseCostDeciderTest.getTestMap(plainsType);
        this.game.changeMap(map);
        CostDecider decider = CostDeciders.avoidSettlements();
        Tile start = this.game.getMap().getTile(5, 5);
        ServerPlayer french = this.getServerPlayer(this.game, "model.nation.french");
        ServerUnit unit = new ServerUnit(this.game, start, french, pioneerType);
        for (Direction dir : Direction.values()) {
            Tile end = start.getNeighbourOrNull(dir);
            BaseCostDeciderTest.assertNotNull((Object)end);
            int cost = decider.getCost(unit, start, this.game.getMap().getTile(5, 6), 100);
            BaseCostDeciderTest.assertEquals((int)plainsType.getBasicMoveCost(), (int)cost);
        }
    }

    public void testGetRemainingMovesAndNewTurn() {
        Map map = BaseCostDeciderTest.getTestMap(plainsType);
        this.game.changeMap(map);
        CostDecider decider = CostDeciders.avoidSettlements();
        ServerPlayer french = this.getServerPlayer(this.game, "model.nation.french");
        ServerUnit unit = new ServerUnit(this.game, this.game.getMap().getTile(1, 1), french, pioneerType);
        int cost = decider.getCost(unit, this.game.getMap().getTile(1, 1), this.game.getMap().getTile(2, 2), 4);
        BaseCostDeciderTest.assertEquals((int)plainsType.getBasicMoveCost(), (int)cost);
        BaseCostDeciderTest.assertEquals((int)(4 - plainsType.getBasicMoveCost()), (int)decider.getMovesLeft());
        BaseCostDeciderTest.assertEquals((int)0, (int)decider.getNewTurns());
    }

    public void testInvalidMoveOfLandUnitToAnOceanTile() {
        Map map = BaseCostDeciderTest.getCoastTestMap(plainsType);
        this.game.changeMap(map);
        Tile unitTile = map.getTile(9, 9);
        BaseCostDeciderTest.assertTrue((String)"Unit tile should be land", (boolean)unitTile.isLand());
        ServerPlayer french = this.getServerPlayer(this.game, "model.nation.french");
        ServerUnit unit = new ServerUnit(this.game, unitTile, french, pioneerType);
        Tile seaTile = map.getTile(10, 9);
        BaseCostDeciderTest.assertFalse((String)"Tile should be ocean", (boolean)seaTile.isLand());
        CostDecider decider = CostDeciders.avoidSettlements();
        int cost = decider.getCost(unit, unitTile, seaTile, 4);
        BaseCostDeciderTest.assertTrue((String)"Move should be invalid", (cost == -1 ? 1 : 0) != 0);
    }

    public void testInvalidMoveOfNavalUnitToALandTile() {
        Map map = BaseCostDeciderTest.getCoastTestMap(plainsType);
        this.game.changeMap(map);
        Tile unitTile = map.getTile(10, 9);
        BaseCostDeciderTest.assertFalse((String)"Unit tile should be ocean", (boolean)unitTile.isLand());
        ServerPlayer french = this.getServerPlayer(this.game, "model.nation.french");
        ServerUnit unit = new ServerUnit(this.game, unitTile, french, galleonType);
        Tile landTile = map.getTile(9, 9);
        BaseCostDeciderTest.assertTrue((String)"Tile should be land", (boolean)landTile.isLand());
        CostDecider decider = CostDeciders.avoidSettlements();
        int cost = decider.getCost(unit, unitTile, landTile, 4);
        BaseCostDeciderTest.assertTrue((String)"Move should be invalid", (cost == -1 ? 1 : 0) != 0);
    }

    public void testInvalidMoveThroughTileWithSettlement() {
        Map map = BaseCostDeciderTest.getTestMap(plainsType);
        this.game.changeMap(map);
        Tile settlementTile = map.getTile(2, 1);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(this.game);
        IndianSettlement settlement = builder.settlementTile(settlementTile).build();
        settlementTile.setSettlement(settlement);
        settlementTile.changeOwningSettlement(settlement);
        Tile unitTile = map.getTile(1, 1);
        ServerPlayer french = this.getServerPlayer(this.game, "model.nation.french");
        ServerUnit unit = new ServerUnit(this.game, unitTile, french, pioneerType);
        Tile unitDestination = map.getTile(3, 1);
        unit.setDestination(unitDestination);
        CostDecider decider = CostDeciders.avoidSettlements();
        int cost = decider.getCost(unit, unitTile, settlementTile, 4);
        BaseCostDeciderTest.assertEquals((String)"Move should be invalid", (int)-1, (int)cost);
    }

    public void testNavalUnitMoveToTileWithSettlement() {
        Map map = BaseCostDeciderTest.getCoastTestMap(plainsType);
        this.game.changeMap(map);
        Tile unitTile = map.getTile(10, 9);
        BaseCostDeciderTest.assertFalse((String)"Unit tile should be ocean", (boolean)unitTile.isLand());
        ServerPlayer french = this.getServerPlayer(this.game, "model.nation.french");
        ServerUnit galleon = new ServerUnit(this.game, unitTile, french, galleonType);
        Tile settlementTile = map.getTile(9, 9);
        BaseCostDeciderTest.assertTrue((String)"Tile should be land", (boolean)settlementTile.isLand());
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(this.game);
        IndianSettlement settlement = builder.settlementTile(settlementTile).build();
        galleon.setDestination(settlementTile);
        CostDecider base = CostDeciders.avoidIllegal();
        int cost = base.getCost(galleon, unitTile, settlementTile, 4);
        BaseCostDeciderTest.assertEquals((String)"Move should be invalid, no contact or goods to trade", (int)-1, (int)cost);
        Player.makeContact(galleon.getOwner(), settlement.getOwner());
        settlement.setContacted(galleon.getOwner());
        BaseCostDeciderTest.spec().setBoolean("model.option.emptyTraders", Boolean.FALSE);
        cost = base.getCost(galleon, unitTile, settlementTile, 4);
        BaseCostDeciderTest.assertEquals((String)"Move should be invalid, no goods to trade", (int)-1, (int)cost);
        BaseCostDeciderTest.spec().setBoolean("model.option.emptyTraders", Boolean.TRUE);
        cost = base.getCost(galleon, unitTile, settlementTile, 4);
        BaseCostDeciderTest.assertTrue((String)"Move should be valid, no goods to trade", (cost != -1 ? 1 : 0) != 0);
        BaseCostDeciderTest.spec().setBoolean("model.option.emptyTraders", Boolean.FALSE);
        Goods goods = new Goods(this.game, null, tradeGoodsType, 50);
        galleon.add(goods);
        cost = base.getCost(galleon, unitTile, settlementTile, 4);
        BaseCostDeciderTest.assertTrue((String)"Move should be valid, has contact and goods to trade", (cost != -1 ? 1 : 0) != 0);
        BaseCostDeciderTest.assertTrue((String)"Move should consume whole turn", (base.getMovesLeft() == 0 && base.getNewTurns() == 0 ? 1 : 0) != 0);
        ServerUnit colonist = new ServerUnit(this.game, galleon, french, colonistType);
        cost = base.getCost(colonist, unitTile, settlementTile, 4);
        if (BaseCostDeciderTest.spec().getBoolean("model.option.amphibiousMoves")) {
            BaseCostDeciderTest.assertFalse((String)"Move valid, direct from carrier to settlement", (cost == -1 ? 1 : 0) != 0);
        } else {
            BaseCostDeciderTest.assertTrue((String)"Move invalid, direct from carrier to settlement", (cost == -1 ? 1 : 0) != 0);
        }
        BaseCostDeciderTest.assertNotNull((String)"Path should be valid from carrier to settlement", (Object)colonist.findPath(unitTile, settlementTile, galleon, base, null));
        Player indianPlayer = settlement.getOwner();
        indianPlayer.setStance(galleon.getOwner(), Stance.WAR);
        galleon.getOwner().setStance(indianPlayer, Stance.WAR);
        cost = base.getCost(galleon, unitTile, settlementTile, 4);
        BaseCostDeciderTest.assertTrue((String)"Move should be valid, war should not block gifts", (cost != -1 ? 1 : 0) != 0);
    }
}

