/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenSSHConfig
implements ConfigRepository {
    private static final Set<String> keysWithListAdoption = Stream.of("KexAlgorithms", "Ciphers", "HostKeyAlgorithms", "MACs", "PubkeyAcceptedAlgorithms", "PubkeyAcceptedKeyTypes").map(string -> string.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
    private final Hashtable<String, Vector<String[]>> config = new Hashtable();
    private final Vector<String> hosts = new Vector();
    private static final Hashtable<String, String> keymap = new Hashtable();

    public static OpenSSHConfig parse(String conf) throws IOException {
        try (StringReader r = new StringReader(conf);){
            OpenSSHConfig openSSHConfig;
            try (BufferedReader br = new BufferedReader(r);){
                openSSHConfig = new OpenSSHConfig(br);
            }
            return openSSHConfig;
        }
    }

    public static OpenSSHConfig parseFile(String file) throws IOException {
        try (BufferedReader br = Files.newBufferedReader(Paths.get(Util.checkTilde(file), new String[0]), StandardCharsets.UTF_8);){
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(br);
            return openSSHConfig;
        }
    }

    OpenSSHConfig(BufferedReader br) throws IOException {
        this._parse(br);
    }

    private void _parse(BufferedReader br) throws IOException {
        String host = "";
        Vector<String[]> kv = new Vector<String[]>();
        String l = null;
        while ((l = br.readLine()) != null) {
            if ((l = l.trim()).length() == 0 || l.startsWith("#")) continue;
            String[] key_value = l.split("[= \t]", 2);
            for (int i = 0; i < key_value.length; ++i) {
                key_value[i] = key_value[i].trim();
            }
            if (key_value.length <= 1) continue;
            if (key_value[0].equalsIgnoreCase("Host")) {
                this.config.put(host, kv);
                this.hosts.addElement(host);
                host = key_value[1];
                kv = new Vector();
                continue;
            }
            kv.addElement(key_value);
        }
        this.config.put(host, kv);
        this.hosts.addElement(host);
    }

    @Override
    public ConfigRepository.Config getConfig(String host) {
        return new MyConfig(host);
    }

    static Hashtable<String, String> getKeymap() {
        return keymap;
    }

    static {
        keymap.put("kex", "KexAlgorithms");
        keymap.put("server_host_key", "HostKeyAlgorithms");
        keymap.put("cipher.c2s", "Ciphers");
        keymap.put("cipher.s2c", "Ciphers");
        keymap.put("mac.c2s", "Macs");
        keymap.put("mac.s2c", "Macs");
        keymap.put("compression.s2c", "Compression");
        keymap.put("compression.c2s", "Compression");
        keymap.put("compression_level", "CompressionLevel");
        keymap.put("MaxAuthTries", "NumberOfPasswordPrompts");
    }

    class MyConfig
    implements ConfigRepository.Config {
        private String host;
        private Vector<Vector<String[]>> _configs = new Vector();

        MyConfig(String host) {
            this.host = host;
            this._configs.addElement((Vector)OpenSSHConfig.this.config.get(""));
            byte[] _host = Util.str2byte(host);
            if (OpenSSHConfig.this.hosts.size() > 1) {
                for (int i = 1; i < OpenSSHConfig.this.hosts.size(); ++i) {
                    String[] patterns = ((String)OpenSSHConfig.this.hosts.elementAt(i)).split("[ \t]");
                    for (int j = 0; j < patterns.length; ++j) {
                        boolean negate = false;
                        String foo = patterns[j].trim();
                        if (foo.startsWith("!")) {
                            negate = true;
                            foo = foo.substring(1).trim();
                        }
                        if (Util.glob(Util.str2byte(foo), _host)) {
                            if (negate) continue;
                            this._configs.addElement((Vector)OpenSSHConfig.this.config.get(OpenSSHConfig.this.hosts.elementAt(i)));
                            continue;
                        }
                        if (!negate) continue;
                        this._configs.addElement((Vector)OpenSSHConfig.this.config.get(OpenSSHConfig.this.hosts.elementAt(i)));
                    }
                }
            }
        }

        private String find(String key) {
            String originalKey = key;
            if (keymap.get(key) != null) {
                key = (String)keymap.get(key);
            }
            key = key.toUpperCase(Locale.ROOT);
            String value = null;
            for (int i = 0; i < this._configs.size(); ++i) {
                Vector<String[]> v = this._configs.elementAt(i);
                for (int j = 0; j < v.size(); ++j) {
                    String[] kv = v.elementAt(j);
                    if (!kv[0].toUpperCase(Locale.ROOT).equals(key)) continue;
                    value = kv[1];
                    break;
                }
                if (value != null) break;
            }
            if (keysWithListAdoption.contains(key) && value != null && (value.startsWith("+") || value.startsWith("-") || value.startsWith("^"))) {
                String origConfig = JSch.getConfig(originalKey).trim();
                if (value.startsWith("+")) {
                    value = origConfig + "," + value.substring(1).trim();
                } else if (value.startsWith("-")) {
                    List algList = Arrays.stream(Util.split(origConfig, ",")).collect(Collectors.toList());
                    for (String alg : Util.split(value.substring(1).trim(), ",")) {
                        algList.remove(alg.trim());
                    }
                    value = String.join((CharSequence)",", algList);
                } else if (value.startsWith("^")) {
                    value = value.substring(1).trim() + "," + origConfig;
                }
            }
            return value;
        }

        private String[] multiFind(String key) {
            key = key.toUpperCase(Locale.ROOT);
            Vector<String> value = new Vector<String>();
            for (int i = 0; i < this._configs.size(); ++i) {
                Vector<String[]> v = this._configs.elementAt(i);
                for (int j = 0; j < v.size(); ++j) {
                    String foo;
                    String[] kv = v.elementAt(j);
                    if (!kv[0].toUpperCase(Locale.ROOT).equals(key) || (foo = kv[1]) == null) continue;
                    value.remove(foo);
                    value.addElement(foo);
                }
            }
            String[] result = new String[value.size()];
            value.toArray(result);
            return result;
        }

        @Override
        public String getHostname() {
            return this.find("Hostname");
        }

        @Override
        public String getUser() {
            return this.find("User");
        }

        @Override
        public int getPort() {
            String foo = this.find("Port");
            int port = -1;
            try {
                port = Integer.parseInt(foo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return port;
        }

        @Override
        public String getValue(String key) {
            if (key.equals("compression.s2c") || key.equals("compression.c2s")) {
                String foo = this.find(key);
                if (foo == null || foo.equals("no")) {
                    return "none,zlib@openssh.com,zlib";
                }
                return "zlib@openssh.com,zlib,none";
            }
            return this.find(key);
        }

        @Override
        public String[] getValues(String key) {
            return this.multiFind(key);
        }
    }
}

