/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import java.util.Arrays;
import java.util.Objects;

public enum MatcherProtectionType {
    SOFTWARE(1, "software"),
    TEE(2, "tee"),
    ON_CHIP(4, "on_chip");

    private static final String VALUE_OUT_OF_RANGE_TEMPLATE = "value %s is out of range";
    private final int value;
    private final String string;

    private MatcherProtectionType(int value, String string2) {
        this.value = value;
        this.string = string2;
    }

    public static MatcherProtectionType create(String value) {
        return Arrays.stream(MatcherProtectionType.values()).filter(item -> Objects.equals(item.string, value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public static MatcherProtectionType create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value));
        }
        return Arrays.stream(MatcherProtectionType.values()).filter(item -> item.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.string;
    }
}

