/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import rx.Notification;
import rx.Observer;
import rx.Subscriber;
import rx.exceptions.CompositeException;

public class TestSubscriber<T>
extends Subscriber<T> {
    private final Observer<T> delegate;
    private final List<T> values;
    private final List<Throwable> errors;
    private int completions;
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile int valueCount;
    private volatile Thread lastSeenThread;
    private static final Observer<Object> INERT = new Observer<Object>(){

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onNext(Object t) {
        }
    };

    public TestSubscriber(long initialRequest) {
        this(INERT, initialRequest);
    }

    public TestSubscriber(Observer<T> delegate, long initialRequest) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        if (initialRequest >= 0L) {
            this.request(initialRequest);
        }
        this.values = new ArrayList<T>();
        this.errors = new ArrayList<Throwable>();
    }

    public TestSubscriber(Subscriber<T> delegate) {
        this(delegate, -1L);
    }

    public TestSubscriber(Observer<T> delegate) {
        this(delegate, -1L);
    }

    public TestSubscriber() {
        this(-1L);
    }

    public static <T> TestSubscriber<T> create() {
        return new TestSubscriber<T>();
    }

    public static <T> TestSubscriber<T> create(long initialRequest) {
        return new TestSubscriber<T>(initialRequest);
    }

    public static <T> TestSubscriber<T> create(Observer<T> delegate, long initialRequest) {
        return new TestSubscriber<T>(delegate, initialRequest);
    }

    public static <T> TestSubscriber<T> create(Subscriber<T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    public static <T> TestSubscriber<T> create(Observer<T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    @Override
    public void onCompleted() {
        try {
            ++this.completions;
            this.lastSeenThread = Thread.currentThread();
            this.delegate.onCompleted();
        }
        finally {
            this.latch.countDown();
        }
    }

    @Deprecated
    public List<Notification<T>> getOnCompletedEvents() {
        int c = this.completions;
        ArrayList<Notification<T>> result = new ArrayList<Notification<T>>(c != 0 ? c : 1);
        for (int i = 0; i < c; ++i) {
            result.add(Notification.createOnCompleted());
        }
        return result;
    }

    public final int getCompletions() {
        return this.completions;
    }

    @Override
    public void onError(Throwable e) {
        try {
            this.lastSeenThread = Thread.currentThread();
            this.errors.add(e);
            this.delegate.onError(e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public List<Throwable> getOnErrorEvents() {
        return this.errors;
    }

    @Override
    public void onNext(T t) {
        this.lastSeenThread = Thread.currentThread();
        this.values.add(t);
        this.valueCount = this.values.size();
        this.delegate.onNext(t);
    }

    public final int getValueCount() {
        return this.valueCount;
    }

    public void requestMore(long n) {
        this.request(n);
    }

    public List<T> getOnNextEvents() {
        return this.values;
    }

    public void assertReceivedOnNext(List<T> items) {
        if (this.values.size() != items.size()) {
            this.assertionError("Number of items does not match. Provided: " + items.size() + "  Actual: " + this.values.size() + ".\nProvided values: " + items + "\nActual values: " + this.values + "\n");
        }
        for (int i = 0; i < items.size(); ++i) {
            this.assertItem(items.get(i), i);
        }
    }

    private void assertItem(T expected, int i) {
        T actual = this.values.get(i);
        if (expected == null) {
            if (actual != null) {
                this.assertionError("Value at index: " + i + " expected: [null] but was: [" + actual + "]\n");
            }
        } else if (!expected.equals(actual)) {
            this.assertionError("Value at index: " + i + " expected: [" + expected + "] (" + expected.getClass().getSimpleName() + ") but was: [" + actual + "] (" + (actual != null ? actual.getClass().getSimpleName() : "null") + ")\n");
        }
    }

    public final boolean awaitValueCount(int expected, long timeout, TimeUnit unit) {
        while (timeout != 0L && this.valueCount < expected) {
            try {
                unit.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted", e);
            }
            --timeout;
        }
        return this.valueCount >= expected;
    }

    public void assertTerminalEvent() {
        if (this.errors.size() > 1) {
            this.assertionError("Too many onError events: " + this.errors.size());
        }
        if (this.completions > 1) {
            this.assertionError("Too many onCompleted events: " + this.completions);
        }
        if (this.completions == 1 && this.errors.size() == 1) {
            this.assertionError("Received both an onError and onCompleted. Should be one or the other.");
        }
        if (this.completions == 0 && this.errors.isEmpty()) {
            this.assertionError("No terminal events received.");
        }
    }

    public void assertUnsubscribed() {
        if (!this.isUnsubscribed()) {
            this.assertionError("Not unsubscribed.");
        }
    }

    public void assertNoErrors() {
        List<Throwable> onErrorEvents = this.getOnErrorEvents();
        if (!onErrorEvents.isEmpty()) {
            this.assertionError("Unexpected onError events");
        }
    }

    public void awaitTerminalEvent() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted", e);
        }
    }

    public void awaitTerminalEvent(long timeout, TimeUnit unit) {
        try {
            this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted", e);
        }
    }

    public void awaitTerminalEventAndUnsubscribeOnTimeout(long timeout, TimeUnit unit) {
        try {
            boolean result = this.latch.await(timeout, unit);
            if (!result) {
                this.unsubscribe();
            }
        }
        catch (InterruptedException e) {
            this.unsubscribe();
        }
    }

    public Thread getLastSeenThread() {
        return this.lastSeenThread;
    }

    public void assertCompleted() {
        int s = this.completions;
        if (s == 0) {
            this.assertionError("Not completed!");
        } else if (s > 1) {
            this.assertionError("Completed multiple times: " + s);
        }
    }

    public void assertNotCompleted() {
        int s = this.completions;
        if (s == 1) {
            this.assertionError("Completed!");
        } else if (s > 1) {
            this.assertionError("Completed multiple times: " + s);
        }
    }

    public void assertError(Class<? extends Throwable> clazz) {
        List<Throwable> err = this.errors;
        if (err.isEmpty()) {
            this.assertionError("No errors");
        } else {
            if (err.size() > 1) {
                AssertionError ae = new AssertionError((Object)("Multiple errors: " + err.size()));
                ((Throwable)((Object)ae)).initCause(new CompositeException(err));
                throw ae;
            }
            if (!clazz.isInstance(err.get(0))) {
                AssertionError ae = new AssertionError((Object)("Exceptions differ; expected: " + clazz + ", actual: " + err.get(0)));
                ((Throwable)((Object)ae)).initCause(err.get(0));
                throw ae;
            }
        }
    }

    public void assertError(Throwable throwable) {
        List<Throwable> err = this.errors;
        if (err.isEmpty()) {
            this.assertionError("No errors");
        } else if (err.size() > 1) {
            this.assertionError("Multiple errors");
        } else if (!throwable.equals(err.get(0))) {
            this.assertionError("Exceptions differ; expected: " + throwable + ", actual: " + err.get(0));
        }
    }

    public void assertNoTerminalEvent() {
        List<Throwable> err = this.errors;
        int s = this.completions;
        if (!err.isEmpty() || s > 0) {
            if (err.isEmpty()) {
                this.assertionError("Found " + err.size() + " errors and " + s + " completion events instead of none");
            } else if (err.size() == 1) {
                this.assertionError("Found " + err.size() + " errors and " + s + " completion events instead of none");
            } else {
                this.assertionError("Found " + err.size() + " errors and " + s + " completion events instead of none");
            }
        }
    }

    public void assertNoValues() {
        int s = this.values.size();
        if (s != 0) {
            this.assertionError("No onNext events expected yet some received: " + s);
        }
    }

    public void assertValueCount(int count) {
        int s = this.values.size();
        if (s != count) {
            this.assertionError("Number of onNext events differ; expected: " + count + ", actual: " + s);
        }
    }

    public void assertValues(T ... values) {
        this.assertReceivedOnNext(Arrays.asList(values));
    }

    public void assertValue(T value) {
        this.assertReceivedOnNext(Collections.singletonList(value));
    }

    final void assertionError(String message) {
        StringBuilder b = new StringBuilder(message.length() + 32);
        b.append(message).append(" (");
        int c = this.completions;
        b.append(c).append(" completion");
        if (c != 1) {
            b.append('s');
        }
        b.append(')');
        if (!this.errors.isEmpty()) {
            int size = this.errors.size();
            b.append(" (+").append(size).append(" error");
            if (size != 1) {
                b.append('s');
            }
            b.append(')');
        }
        AssertionError ae = new AssertionError((Object)b.toString());
        if (!this.errors.isEmpty()) {
            if (this.errors.size() == 1) {
                ((Throwable)((Object)ae)).initCause(this.errors.get(0));
            } else {
                ((Throwable)((Object)ae)).initCause(new CompositeException(this.errors));
            }
        }
        throw ae;
    }

    public final void assertValuesAndClear(T expectedFirstValue, T ... expectedRestValues) {
        int n = 1 + expectedRestValues.length;
        this.assertValueCount(n);
        this.assertItem(expectedFirstValue, 0);
        for (int i = 0; i < expectedRestValues.length; ++i) {
            this.assertItem(expectedRestValues[i], i + 1);
        }
        this.values.clear();
        this.valueCount = 0;
    }
}

