/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import java.util.Objects;
import java.util.function.BiConsumer;

public class Range<T extends Integer> {
    private final T first;
    private final T last;

    public Range(T first, T last) {
        this.first = (Integer)Objects.requireNonNull(first);
        this.last = (Integer)Objects.requireNonNull(last);
        if (((Integer)first).compareTo((Integer)last) > 0) {
            throw new IllegalArgumentException("First must be less than or equal to last");
        }
    }

    public boolean contains(Range<T> other) {
        return ((Integer)this.first).compareTo((Integer)other.first) <= 0 && ((Integer)this.last).compareTo((Integer)other.last) >= 0;
    }

    public T getFirst() {
        return this.first;
    }

    public T getLast() {
        return this.last;
    }

    public void eachWithIndex(BiConsumer<Integer, Integer> consumer) {
        if (((Integer)this.first).intValue() == ((Integer)this.last).intValue()) {
            consumer.accept((Integer)this.first, 0);
            return;
        }
        int index = 0;
        for (int value = ((Integer)this.first).intValue(); value < (Integer)this.last; ++value) {
            consumer.accept(value, index++);
        }
    }

    public int count() {
        return (Integer)this.last - (Integer)this.first + 1;
    }

    public String toString() {
        return this.getClass().getName() + "{first=" + this.first + ", last=" + this.last + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.first, range.first) && Objects.equals(this.last, range.last);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.last);
    }
}

