/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryAabbsDataKHR;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryInstancesDataKHR;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryTrianglesDataKHR;

public class VkAccelerationStructureGeometryDataKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRIANGLES;
    public static final int AABBS;
    public static final int INSTANCES;

    public VkAccelerationStructureGeometryDataKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAccelerationStructureGeometryDataKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkAccelerationStructureGeometryTrianglesDataKHR triangles() {
        return VkAccelerationStructureGeometryDataKHR.ntriangles(this.address());
    }

    public VkAccelerationStructureGeometryAabbsDataKHR aabbs() {
        return VkAccelerationStructureGeometryDataKHR.naabbs(this.address());
    }

    public VkAccelerationStructureGeometryInstancesDataKHR instances() {
        return VkAccelerationStructureGeometryDataKHR.ninstances(this.address());
    }

    public VkAccelerationStructureGeometryDataKHR triangles(VkAccelerationStructureGeometryTrianglesDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.ntriangles(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR triangles(Consumer<VkAccelerationStructureGeometryTrianglesDataKHR> consumer) {
        consumer.accept(this.triangles());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR aabbs(VkAccelerationStructureGeometryAabbsDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.naabbs(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR aabbs(Consumer<VkAccelerationStructureGeometryAabbsDataKHR> consumer) {
        consumer.accept(this.aabbs());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR instances(VkAccelerationStructureGeometryInstancesDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.ninstances(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR instances(Consumer<VkAccelerationStructureGeometryInstancesDataKHR> consumer) {
        consumer.accept(this.instances());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR set(VkAccelerationStructureGeometryDataKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureGeometryDataKHR malloc() {
        return (VkAccelerationStructureGeometryDataKHR)VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkAccelerationStructureGeometryDataKHR calloc() {
        return (VkAccelerationStructureGeometryDataKHR)VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkAccelerationStructureGeometryDataKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkAccelerationStructureGeometryDataKHR)VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkAccelerationStructureGeometryDataKHR create(long address) {
        return (VkAccelerationStructureGeometryDataKHR)VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, (long)address);
    }

    @Nullable
    public static VkAccelerationStructureGeometryDataKHR createSafe(long address) {
        return address == 0L ? null : (VkAccelerationStructureGeometryDataKHR)VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureGeometryDataKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureGeometryDataKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkAccelerationStructureGeometryDataKHR malloc(MemoryStack stack) {
        return (VkAccelerationStructureGeometryDataKHR)VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureGeometryDataKHR calloc(MemoryStack stack) {
        return (VkAccelerationStructureGeometryDataKHR)VkAccelerationStructureGeometryDataKHR.wrap(VkAccelerationStructureGeometryDataKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkAccelerationStructureGeometryDataKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkAccelerationStructureGeometryTrianglesDataKHR ntriangles(long struct) {
        return VkAccelerationStructureGeometryTrianglesDataKHR.create(struct + (long)TRIANGLES);
    }

    public static VkAccelerationStructureGeometryAabbsDataKHR naabbs(long struct) {
        return VkAccelerationStructureGeometryAabbsDataKHR.create(struct + (long)AABBS);
    }

    public static VkAccelerationStructureGeometryInstancesDataKHR ninstances(long struct) {
        return VkAccelerationStructureGeometryInstancesDataKHR.create(struct + (long)INSTANCES);
    }

    public static void ntriangles(long struct, VkAccelerationStructureGeometryTrianglesDataKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TRIANGLES), (long)VkAccelerationStructureGeometryTrianglesDataKHR.SIZEOF);
    }

    public static void naabbs(long struct, VkAccelerationStructureGeometryAabbsDataKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)AABBS), (long)VkAccelerationStructureGeometryAabbsDataKHR.SIZEOF);
    }

    public static void ninstances(long struct, VkAccelerationStructureGeometryInstancesDataKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)INSTANCES), (long)VkAccelerationStructureGeometryInstancesDataKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureGeometryDataKHR.__union((Struct.Member[])new Struct.Member[]{VkAccelerationStructureGeometryDataKHR.__member((int)VkAccelerationStructureGeometryTrianglesDataKHR.SIZEOF, (int)VkAccelerationStructureGeometryTrianglesDataKHR.ALIGNOF), VkAccelerationStructureGeometryDataKHR.__member((int)VkAccelerationStructureGeometryAabbsDataKHR.SIZEOF, (int)VkAccelerationStructureGeometryAabbsDataKHR.ALIGNOF), VkAccelerationStructureGeometryDataKHR.__member((int)VkAccelerationStructureGeometryInstancesDataKHR.SIZEOF, (int)VkAccelerationStructureGeometryInstancesDataKHR.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRIANGLES = layout.offsetof(0);
        AABBS = layout.offsetof(1);
        INSTANCES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureGeometryDataKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureGeometryDataKHR ELEMENT_FACTORY = VkAccelerationStructureGeometryDataKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAccelerationStructureGeometryDataKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkAccelerationStructureGeometryTrianglesDataKHR triangles() {
            return VkAccelerationStructureGeometryDataKHR.ntriangles(this.address());
        }

        public VkAccelerationStructureGeometryAabbsDataKHR aabbs() {
            return VkAccelerationStructureGeometryDataKHR.naabbs(this.address());
        }

        public VkAccelerationStructureGeometryInstancesDataKHR instances() {
            return VkAccelerationStructureGeometryDataKHR.ninstances(this.address());
        }

        public Buffer triangles(VkAccelerationStructureGeometryTrianglesDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.ntriangles(this.address(), value);
            return this;
        }

        public Buffer triangles(Consumer<VkAccelerationStructureGeometryTrianglesDataKHR> consumer) {
            consumer.accept(this.triangles());
            return this;
        }

        public Buffer aabbs(VkAccelerationStructureGeometryAabbsDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.naabbs(this.address(), value);
            return this;
        }

        public Buffer aabbs(Consumer<VkAccelerationStructureGeometryAabbsDataKHR> consumer) {
            consumer.accept(this.aabbs());
            return this;
        }

        public Buffer instances(VkAccelerationStructureGeometryInstancesDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.ninstances(this.address(), value);
            return this;
        }

        public Buffer instances(Consumer<VkAccelerationStructureGeometryInstancesDataKHR> consumer) {
            consumer.accept(this.instances());
            return this;
        }
    }
}

