/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.ExecutionContextCustomizer;
import com.networknt.schema.SchemaIdValidator;
import com.networknt.schema.i18n.DefaultMessageSource;
import com.networknt.schema.i18n.MessageSource;
import com.networknt.schema.path.PathType;
import com.networknt.schema.regex.JDKRegularExpressionFactory;
import com.networknt.schema.regex.RegularExpressionFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SchemaRegistryConfig {
    private final ExecutionContextCustomizer executionContextCustomizer;
    private final boolean cacheRefs;
    private final String errorMessageKeyword;
    private final boolean failFast;
    private final Boolean formatAssertionsEnabled;
    private final Locale locale;
    private final boolean losslessNarrowing;
    private final MessageSource messageSource;
    private final PathType pathType;
    private final boolean preloadSchema;
    private final RegularExpressionFactory regularExpressionFactory;
    private final SchemaIdValidator schemaIdValidator;
    private final Map<String, Boolean> strictness;
    private boolean typeLoose;

    public static SchemaRegistryConfig getInstance() {
        return Holder.INSTANCE;
    }

    protected SchemaRegistryConfig(boolean cacheRefs, String errorMessageKeyword, ExecutionContextCustomizer executionContextCustomizer, boolean failFast, Boolean formatAssertionsEnabled, Locale locale, boolean losslessNarrowing, MessageSource messageSource, PathType pathType, boolean preloadSchema, RegularExpressionFactory regularExpressionFactory, SchemaIdValidator schemaIdValidator, Map<String, Boolean> strictness, boolean typeLoose) {
        this.cacheRefs = cacheRefs;
        this.errorMessageKeyword = errorMessageKeyword;
        this.executionContextCustomizer = executionContextCustomizer;
        this.failFast = failFast;
        this.formatAssertionsEnabled = formatAssertionsEnabled;
        this.locale = locale;
        this.losslessNarrowing = losslessNarrowing;
        this.messageSource = messageSource;
        this.pathType = pathType;
        this.preloadSchema = preloadSchema;
        this.regularExpressionFactory = regularExpressionFactory;
        this.schemaIdValidator = schemaIdValidator;
        this.strictness = strictness;
        this.typeLoose = typeLoose;
    }

    public ExecutionContextCustomizer getExecutionContextCustomizer() {
        return this.executionContextCustomizer;
    }

    public Boolean getFormatAssertionsEnabled() {
        return this.formatAssertionsEnabled;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            return DefaultMessageSource.getInstance();
        }
        return this.messageSource;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public RegularExpressionFactory getRegularExpressionFactory() {
        return this.regularExpressionFactory;
    }

    public SchemaIdValidator getSchemaIdValidator() {
        return this.schemaIdValidator;
    }

    public boolean isCacheRefs() {
        return this.cacheRefs;
    }

    public String getErrorMessageKeyword() {
        return this.errorMessageKeyword;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public boolean isLosslessNarrowing() {
        return this.losslessNarrowing;
    }

    public boolean isPreloadSchema() {
        return this.preloadSchema;
    }

    public boolean isStrict(String keyword) {
        return this.isStrict(keyword, Boolean.TRUE);
    }

    public boolean isStrict(String keyword, Boolean defaultValue) {
        return this.strictness.getOrDefault(Objects.requireNonNull(keyword, "keyword cannot be null"), defaultValue);
    }

    public boolean isTypeLoose() {
        return this.typeLoose;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaRegistryConfig config) {
        Builder builder = new Builder();
        builder.cacheRefs = config.cacheRefs;
        builder.errorMessageKeyword = config.errorMessageKeyword;
        builder.executionContextCustomizer = config.executionContextCustomizer;
        builder.failFast = config.failFast;
        builder.formatAssertionsEnabled = config.formatAssertionsEnabled;
        builder.locale = config.locale;
        builder.losslessNarrowing = config.losslessNarrowing;
        builder.messageSource = config.messageSource;
        builder.pathType = config.pathType;
        builder.preloadSchema = config.preloadSchema;
        builder.regularExpressionFactory = config.regularExpressionFactory;
        builder.schemaIdValidator = config.schemaIdValidator;
        builder.strictness = config.strictness;
        builder.typeLoose = config.typeLoose;
        return builder;
    }

    private static class Holder {
        private static final SchemaRegistryConfig INSTANCE = SchemaRegistryConfig.builder().build();

        private Holder() {
        }
    }

    public static class Builder
    extends BuilderSupport<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class BuilderSupport<T> {
        protected boolean cacheRefs = true;
        protected String errorMessageKeyword = null;
        protected ExecutionContextCustomizer executionContextCustomizer = null;
        protected boolean failFast = false;
        protected Boolean formatAssertionsEnabled = null;
        protected Locale locale = null;
        protected boolean losslessNarrowing = false;
        protected MessageSource messageSource = null;
        protected PathType pathType = PathType.JSON_POINTER;
        protected boolean preloadSchema = true;
        protected RegularExpressionFactory regularExpressionFactory = JDKRegularExpressionFactory.getInstance();
        protected SchemaIdValidator schemaIdValidator = SchemaIdValidator.DEFAULT;
        protected Map<String, Boolean> strictness = new HashMap<String, Boolean>(0);
        protected boolean typeLoose = false;

        protected abstract T self();

        public T cacheRefs(boolean cacheRefs) {
            this.cacheRefs = cacheRefs;
            return this.self();
        }

        public T errorMessageKeyword(String errorMessageKeyword) {
            this.errorMessageKeyword = errorMessageKeyword;
            return this.self();
        }

        public T executionContextCustomizer(ExecutionContextCustomizer executionContextCustomizer) {
            this.executionContextCustomizer = executionContextCustomizer;
            return this.self();
        }

        public T failFast(boolean failFast) {
            this.failFast = failFast;
            return this.self();
        }

        public T formatAssertionsEnabled(Boolean formatAssertionsEnabled) {
            this.formatAssertionsEnabled = formatAssertionsEnabled;
            return this.self();
        }

        public T locale(Locale locale) {
            this.locale = locale;
            return this.self();
        }

        public T losslessNarrowing(boolean losslessNarrowing) {
            this.losslessNarrowing = losslessNarrowing;
            return this.self();
        }

        public T messageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
            return this.self();
        }

        public T pathType(PathType pathType) {
            this.pathType = pathType;
            return this.self();
        }

        public T preloadSchema(boolean preloadSchema) {
            this.preloadSchema = preloadSchema;
            return this.self();
        }

        public T regularExpressionFactory(RegularExpressionFactory regularExpressionFactory) {
            this.regularExpressionFactory = regularExpressionFactory;
            return this.self();
        }

        public T schemaIdValidator(SchemaIdValidator schemaIdValidator) {
            this.schemaIdValidator = schemaIdValidator;
            return this.self();
        }

        public T strict(Map<String, Boolean> strict) {
            this.strictness = strict;
            return this.self();
        }

        public T strict(String keyword, boolean strict) {
            this.strictness.put(Objects.requireNonNull(keyword, "keyword cannot be null"), strict);
            return this.self();
        }

        public T typeLoose(boolean typeLoose) {
            this.typeLoose = typeLoose;
            return this.self();
        }

        public SchemaRegistryConfig build() {
            return new SchemaRegistryConfig(this.cacheRefs, this.errorMessageKeyword, this.executionContextCustomizer, this.failFast, this.formatAssertionsEnabled, this.locale, this.losslessNarrowing, this.messageSource, this.pathType, this.preloadSchema, this.regularExpressionFactory, this.schemaIdValidator, this.strictness, this.typeLoose);
        }
    }
}

