/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.remote.transaction.LoginFailureChangeLogTransaction;

public class RemoteUserLoginFailureProvider
implements UserLoginFailureProvider {
    private static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final LoginFailureChangeLogTransaction transaction;

    public RemoteUserLoginFailureProvider(LoginFailureChangeLogTransaction transaction) {
        this.transaction = Objects.requireNonNull(transaction);
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        if (log.isTraceEnabled()) {
            log.tracef("getUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        }
        return (UserLoginFailureModel)this.transaction.get(new LoginFailureKey(realm.getId(), userId));
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        if (log.isTraceEnabled()) {
            log.tracef("addUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        }
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        LoginFailureEntity entity = new LoginFailureEntity(realm.getId(), userId);
        return (UserLoginFailureModel)this.transaction.create(key, entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        if (log.isTraceEnabled()) {
            log.tracef("removeUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        }
        this.transaction.remove(new LoginFailureKey(realm.getId(), userId));
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        if (log.isTraceEnabled()) {
            log.tracef("removeAllUserLoginFailures(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        }
        this.transaction.removeByRealmId(realm.getId());
    }

    public void close() {
    }
}

