/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u ^ (- 0u)) => 0u
 * (0u ^ (- 6u)) => 4294967290u
 * (0u ^ (- 12u)) => 4294967284u
 * (0u ^ (- 32u)) => 4294967264u
 * (0u ^ (- 74u)) => 4294967222u
 * (6u ^ (- 0u)) => 6u
 * (6u ^ (- 6u)) => 4294967292u
 * (6u ^ (- 12u)) => 4294967282u
 * (6u ^ (- 32u)) => 4294967270u
 * (6u ^ (- 74u)) => 4294967216u
 * (12u ^ (- 0u)) => 12u
 * (12u ^ (- 6u)) => 4294967286u
 * (12u ^ (- 12u)) => 4294967288u
 * (12u ^ (- 32u)) => 4294967276u
 * (12u ^ (- 74u)) => 4294967226u
 * (32u ^ (- 0u)) => 32u
 * (32u ^ (- 6u)) => 4294967258u
 * (32u ^ (- 12u)) => 4294967252u
 * (32u ^ (- 32u)) => 4294967232u
 * (32u ^ (- 74u)) => 4294967190u
 * (74u ^ (- 0u)) => 74u
 * (74u ^ (- 6u)) => 4294967216u
 * (74u ^ (- 12u)) => 4294967230u
 * (74u ^ (- 32u)) => 4294967210u
 * (74u ^ (- 74u)) => 4294967292u
 */
#version 130

void main()
{
  float[(0u ^ (- 0u)) == 0u ? 1 : -1] array0;
  float[(0u ^ (- 6u)) == 4294967290u ? 1 : -1] array1;
  float[(0u ^ (- 12u)) == 4294967284u ? 1 : -1] array2;
  float[(0u ^ (- 32u)) == 4294967264u ? 1 : -1] array3;
  float[(0u ^ (- 74u)) == 4294967222u ? 1 : -1] array4;
  float[(6u ^ (- 0u)) == 6u ? 1 : -1] array5;
  float[(6u ^ (- 6u)) == 4294967292u ? 1 : -1] array6;
  float[(6u ^ (- 12u)) == 4294967282u ? 1 : -1] array7;
  float[(6u ^ (- 32u)) == 4294967270u ? 1 : -1] array8;
  float[(6u ^ (- 74u)) == 4294967216u ? 1 : -1] array9;
  float[(12u ^ (- 0u)) == 12u ? 1 : -1] array10;
  float[(12u ^ (- 6u)) == 4294967286u ? 1 : -1] array11;
  float[(12u ^ (- 12u)) == 4294967288u ? 1 : -1] array12;
  float[(12u ^ (- 32u)) == 4294967276u ? 1 : -1] array13;
  float[(12u ^ (- 74u)) == 4294967226u ? 1 : -1] array14;
  float[(32u ^ (- 0u)) == 32u ? 1 : -1] array15;
  float[(32u ^ (- 6u)) == 4294967258u ? 1 : -1] array16;
  float[(32u ^ (- 12u)) == 4294967252u ? 1 : -1] array17;
  float[(32u ^ (- 32u)) == 4294967232u ? 1 : -1] array18;
  float[(32u ^ (- 74u)) == 4294967190u ? 1 : -1] array19;
  float[(74u ^ (- 0u)) == 74u ? 1 : -1] array20;
  float[(74u ^ (- 6u)) == 4294967216u ? 1 : -1] array21;
  float[(74u ^ (- 12u)) == 4294967230u ? 1 : -1] array22;
  float[(74u ^ (- 32u)) == 4294967210u ? 1 : -1] array23;
  float[(74u ^ (- 74u)) == 4294967292u ? 1 : -1] array24;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length());
}
