/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.UnexpectedStructureException;

class BlockHeader {
    private byte[] m_header = new byte[8];
    private byte[] m_skip;
    private int m_offset;
    private String m_name;
    private int m_columnType;
    private int m_flags;

    BlockHeader() {
    }

    public BlockHeader read(byte[] byArray, int n, int n2) {
        this.m_offset = n;
        System.arraycopy(byArray, this.m_offset, this.m_header, 0, 8);
        this.m_offset += 8;
        int n3 = FastTrackUtility.getInt(byArray, this.m_offset);
        this.m_offset += 4;
        if (n3 < 1 || n3 > 255) {
            throw new UnexpectedStructureException();
        }
        this.m_name = new String(byArray, this.m_offset, n3, CharsetHelper.UTF16LE);
        this.m_offset += n3;
        this.m_columnType = FastTrackUtility.getShort(byArray, this.m_offset);
        this.m_offset += 2;
        this.m_flags = FastTrackUtility.getShort(byArray, this.m_offset);
        this.m_offset += 2;
        this.m_skip = new byte[n2];
        System.arraycopy(byArray, this.m_offset, this.m_skip, 0, n2);
        this.m_offset += n2;
        return this;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public String getName() {
        return this.m_name;
    }

    public int getColumnType() {
        return this.m_columnType;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println("  [BlockHeader");
        printWriter.print("    Header: " + FastTrackUtility.hexdump(this.m_header, 0, this.m_header.length, false, 16, ""));
        printWriter.println("    Name: " + this.m_name);
        printWriter.println("    Type: " + this.m_columnType);
        printWriter.println("    Flags: " + this.m_flags);
        printWriter.print("    Skip:\n" + FastTrackUtility.hexdump(this.m_skip, 0, this.m_skip.length, false, 16, "      "));
        printWriter.println("  ]");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }
}

