"""Generated message classes for faulttesting version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'faulttesting'


class Action(_messages.Message):
  r"""The action to be performed by the experiment.

  Fields:
    cloudSqlFailover: Specify a CloudSQLFailover action.
    gceFailCompute: Specify a GCEFailCompute action.
    gkeFailCompute: Specify a GKEFailCompute action.
    l7LbHttpFault: Specify a L7LBHTTPFault action.
  """

  cloudSqlFailover = _messages.MessageField('CloudSQLFailover', 1)
  gceFailCompute = _messages.MessageField('GCEFailCompute', 2)
  gkeFailCompute = _messages.MessageField('GKEFailCompute', 3)
  l7LbHttpFault = _messages.MessageField('L7LBHTTPFault', 4)


class AffectedResource(_messages.Message):
  r"""Cloud resource that is affected by an experiment.

  Enums:
    StateValueValuesEnum: The current state of the affected resource.

  Fields:
    affectedResourceUri: Required. The URI of a GCP cloud resource.
    cloudConsoleUrl: Output only. The URL to see this resource in the google
      cloud console
    displayName: Optional. The display name of the AffectedResource.
    error: Output only. The error encountered when preparing, injecting, or
      stopping the experiment for this resource.
    name: Identifier. The resource name of the AffectedResource, of the form:
      projects/{project_id}/locations/{location}/experiments/{experiment_id}/a
      ffectedResources/{affected_resource_id}.
    state: The current state of the affected resource.
    stateMessage: A human-readable description of what is happening to the
      affected resource.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the affected resource.

    Values:
      STATE_UNSPECIFIED: Not used.
      PREPARING: The experiment resources are being identified and checked for
        permissions.
      PREPARED: It is ready to run.
      INJECTING: The resources associated with the experiment are being
        modified.
      INJECTED: The resources have been modified and we are waiting for the
        test duration to expire.
      REVERTING: It is in the process of stopping.
      COMPLETED: This is experiment has completed and no further actions will
        happen on its behalf.
    """
    STATE_UNSPECIFIED = 0
    PREPARING = 1
    PREPARED = 2
    INJECTING = 3
    INJECTED = 4
    REVERTING = 5
    COMPLETED = 6

  affectedResourceUri = _messages.StringField(1)
  cloudConsoleUrl = _messages.StringField(2)
  displayName = _messages.StringField(3)
  error = _messages.MessageField('Status', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  stateMessage = _messages.StringField(7)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudSQLFailover(_messages.Message):
  r"""CloudSQLFailover causes a Cloud SQL primary instance to fail over to
  another instance.

  Fields:
    instance: Required. The identifying name of the Cloud SQL instance to fail
      over. Formatted like projects/{project_id}/instances/{instance_id}
  """

  instance = _messages.StringField(1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Experiment(_messages.Message):
  r"""A prospective, current, or past run of a failure-injection experiment.

  Enums:
    EndReasonValueValuesEnum: Output only. The reason the experiment ended.
      This should be set as soon as state becomes REVERTING.
    StateValueValuesEnum: Output only. The current state of the experiment.

  Fields:
    createTime: Output only. Time the experiment was created.
    description: Optional. Optional user-provided description or notes. Min
      length 0, max length 2000.
    displayName: Optional. Human-readable name of the experiment
    effectiveAction: Output only. The fault-injection action to be performed.
      This is a copy of the Action in the referenced ExperimentTemplate.
    endNotes: Output only. If end_reason is CANCELLED, this can have notes
      from the user about the circumstances.
    endReason: Output only. The reason the experiment ended. This should be
      set as soon as state becomes REVERTING.
    experimentTemplate: Required. The resource name of an ExperimentTemplate
      to create this experiment from. Required. Format projects/{project_id}/l
      ocations/{location}/experimentTemplates/{experimentTemplateId}. The
      server will read the named template and use its contents to fill
      template_display_name, template_description, template_tags,
      template_duration, and effective_action.
    name: Identifier. The resource name of the Experiment, of the form:
      projects/{project_id}/locations/{location}/experiments/{experiment_id}.
    startTime: Output only. Time the experiment started running.
    state: Output only. The current state of the experiment.
    stateUpdateTime: Output only. Time of the most recent state change.
    stopTime: Output only. Time the experiment terminated. Specifically when
      the experiment state becomes COMPLETED. The presence of this field can
      be used to determine if the experiment is stopped or not.
    templateDescription: Output only. The description of the
      ExperimentTemplate this experiment was created from. Min length 0, max
      length 2000.
    templateDisplayName: Output only. The display name of the
      ExperimentTemplate this experiment was created from. Min length 0, max
      length is 1000.
    templateDuration: Output only. The intended duration of the Experiment.
      Min duration 1 minute, max 10 days.
    templateTags: Output only. The tags of the ExperimentTemplate this
      experiment was created from. Min length 0, max combined length 1000.
  """

  class EndReasonValueValuesEnum(_messages.Enum):
    r"""Output only. The reason the experiment ended. This should be set as
    soon as state becomes REVERTING.

    Values:
      END_REASON_UNSPECIFIED: No EndReason has been set.
      CANCELLED: The experiment was stopped by the user.
      COMPLETED: The experiment finished normally.
    """
    END_REASON_UNSPECIFIED = 0
    CANCELLED = 1
    COMPLETED = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the experiment.

    Values:
      STATE_UNSPECIFIED: Not used.
      PREPARING: The experiment resources are being identified and checked for
        permissions.
      PREPARED: It is ready to run.
      INJECTING: The resources associated with the experiment are being
        modified.
      INJECTED: The resources have been modified and we are waiting for the
        test duration to expire.
      REVERTING: It is in the process of stopping.
      COMPLETED: This is experiment has completed and no further actions will
        happen on its behalf.
    """
    STATE_UNSPECIFIED = 0
    PREPARING = 1
    PREPARED = 2
    INJECTING = 3
    INJECTED = 4
    REVERTING = 5
    COMPLETED = 6

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  effectiveAction = _messages.MessageField('Action', 4)
  endNotes = _messages.StringField(5)
  endReason = _messages.EnumField('EndReasonValueValuesEnum', 6)
  experimentTemplate = _messages.StringField(7)
  name = _messages.StringField(8)
  startTime = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  stateUpdateTime = _messages.StringField(11)
  stopTime = _messages.StringField(12)
  templateDescription = _messages.StringField(13)
  templateDisplayName = _messages.StringField(14)
  templateDuration = _messages.StringField(15)
  templateTags = _messages.StringField(16, repeated=True)


class ExperimentTemplate(_messages.Message):
  r"""Template for a failure-injection experiment.

  Fields:
    action: Required. The action to be performed.
    createTime: Output only. The time the template was created.
    description: Optional. Optional user-provided description or notes. Min
      length 0. Max length 2000.
    displayName: Optional. Human-readable template name. Min length 0, max
      1000.
    duration: Required. How long the experiment is intended to run. Min
      duration is 0, max is 10 days.
    name: Identifier. The resource name of this experiment template. Format: p
      rojects/{project}/locations/{location}/experimentTemplates/{experiment_t
      emplate_id}
    tags: Optional. Optional user-provided tags. Min length 0, max combined
      length 1000.
    updateTime: Output only. The time the template was last updated.
  """

  action = _messages.MessageField('Action', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  duration = _messages.StringField(5)
  name = _messages.StringField(6)
  tags = _messages.StringField(7, repeated=True)
  updateTime = _messages.StringField(8)


class FaulttestingProjectsLocationsExperimentTemplatesCreateRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentTemplatesCreateRequest object.

  Fields:
    experimentTemplate: A ExperimentTemplate resource to be passed as the
      request body.
    experimentTemplateId: Optional. The ID to use for the experiment_template,
      which will become the final component of the experiment_template's
      resource name. Required. This value should be 4-63 characters, and valid
      characters are /a-z-/. Must start with a letter and cannot end with a
      hyphen.
    parent: Required. The project where this experiment template will be
      created. Format: projects/{project}/locations/{location}
  """

  experimentTemplate = _messages.MessageField('ExperimentTemplate', 1)
  experimentTemplateId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class FaulttestingProjectsLocationsExperimentTemplatesDeleteRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentTemplatesDeleteRequest object.

  Fields:
    name: Required. The name of the experiment template to delete. Format: pro
      jects/{project}/locations/{location}/experimentTemplates/{experiment_tem
      plate}
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsExperimentTemplatesGetRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentTemplatesGetRequest object.

  Fields:
    name: Required. The name of the experiment template. Format: projects/{pro
      ject}/locations/{location}/experimentTemplates/{experiment_template}
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsExperimentTemplatesListRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentTemplatesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of experiment templates to return
      from this call. The service may return fewer than this value. If
      unspecified, at most 1000 experiment templates will be returned. The
      maximum value is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListExperimentTemplates` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListExperimentTemplates` must match the call that provided the page
      token.
    parent: Required. The project and location from which to list experiment
      templates. Format: projects/{project}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class FaulttestingProjectsLocationsExperimentTemplatesPatchRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentTemplatesPatchRequest object.

  Fields:
    experimentTemplate: A ExperimentTemplate resource to be passed as the
      request body.
    name: Identifier. The resource name of this experiment template. Format: p
      rojects/{project}/locations/{location}/experimentTemplates/{experiment_t
      emplate_id}
    updateMask: Optional. The mask to control which fields get updated. If the
      mask is not present, all fields will be updated.
  """

  experimentTemplate = _messages.MessageField('ExperimentTemplate', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class FaulttestingProjectsLocationsExperimentsAffectedResourcesGetRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentsAffectedResourcesGetRequest
  object.

  Fields:
    name: Required. The name of the affected resource. Format: projects/{proje
      ct}/locations/{location}/experiments/{experiment}/affectedResources/{aff
      ected_resource}
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsExperimentsAffectedResourcesListRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentsAffectedResourcesListRequest
  object.

  Fields:
    filter: Optional. Filtering results
    pageSize: Optional. The maximum number of affected resources to return.
      The service may return fewer than this value. If unspecified, at most
      1000 affected resources will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListAffectedResources` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListAffectedResources` must match the call that provided the page
      token.
    parent: Required. The experiment from which to list affected resources.
      Format: projects/{project}/locations/{location}/experiments/{experiment}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class FaulttestingProjectsLocationsExperimentsCreateRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentsCreateRequest object.

  Fields:
    experiment: A Experiment resource to be passed as the request body.
    experimentId: Optional. The ID to use for the experiment, which will
      become the final component of the experiment's resource name. Optional.
      If omitted, the server will create a UUID. This value should be 4-63
      characters, and valid characters are /a-z-/. Cannot start or end with a
      hyphen.
    parent: Required. The project where this experiment will be created.
      Format: projects/{project}/locations/{location}
  """

  experiment = _messages.MessageField('Experiment', 1)
  experimentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class FaulttestingProjectsLocationsExperimentsDeleteRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentsDeleteRequest object.

  Fields:
    force: Optional. Should always be set to true. If set to true, any
      AffectedResources under this Experiment will also be deleted.
      (Otherwise, the request will only work if the Experiment has no
      AffectedResources.)
    name: Required. The name of the experiment to delete. Format:
      projects/{project}/locations/{location}/experiments/{experiment}
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class FaulttestingProjectsLocationsExperimentsGetRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentsGetRequest object.

  Fields:
    name: Required. The name of the experiment. Format:
      projects/{project}/locations/{location}/experiments/{experiment}
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsExperimentsListRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentsListRequest object.

  Fields:
    filter: Optional. Filter expression to restrict the experiments returned.
      Example: 'status=RUNNING'.
    pageSize: Optional. The maximum number of experiments to return. The
      service may return fewer than this value. If unspecified, at most 1000
      experiments will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListExperiments` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListExperiments` must
      match the call that provided the page token.
    parent: Required. The project and location from which to list experiments.
      Format: projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class FaulttestingProjectsLocationsExperimentsStartRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentsStartRequest object.

  Fields:
    name: Required. The resource name of the experiment to start. Format:
      projects/{project}/locations/{location}/experiments/{experiment}
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsExperimentsStopRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsExperimentsStopRequest object.

  Fields:
    name: Required. The resource name of the experiment to stop. Format:
      projects/{project}/locations/{location}/experiments/{experiment}
    stopExperimentRequest: A StopExperimentRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  stopExperimentRequest = _messages.MessageField('StopExperimentRequest', 2)


class FaulttestingProjectsLocationsGetRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsListRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class FaulttestingProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class FaulttestingProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class FaulttestingProjectsLocationsValidationsCreateRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsValidationsCreateRequest object.

  Fields:
    parent: Required. The project where this Validation will be created.
      Format: projects/{project}/locations/{location}
    validation: A Validation resource to be passed as the request body.
    validationId: Optional. The ID to use for the Validation, which will
      become the final component of the Validation's resource name. Optional.
      If omitted, the server will create a UUID. This value should be 4-63
      characters, and valid characters are /a-z-/. Cannot start or end with a
      hyphen.
  """

  parent = _messages.StringField(1, required=True)
  validation = _messages.MessageField('Validation', 2)
  validationId = _messages.StringField(3)


class FaulttestingProjectsLocationsValidationsDeleteRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsValidationsDeleteRequest object.

  Fields:
    force: Optional. Should always be set to true. If set to true, any
      ValidationResources under this Validation will also be deleted.
      (Otherwise, the request will only work if the Validation has no
      ValidationResources.)
    name: Required. The name of the Validation to delete. Format:
      projects/{project}/locations/{location}/validations/{validation}
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class FaulttestingProjectsLocationsValidationsGetRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsValidationsGetRequest object.

  Fields:
    name: Required. The name of the Validation. Format:
      projects/{project}/locations/{location}/validations/{validation}
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsValidationsListRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsValidationsListRequest object.

  Fields:
    filter: Optional. Filter expression to restrict the validations returned.
      Example: 'status=RUNNING'.
    pageSize: Optional. The maximum number of Validations to return. The
      service may return fewer than this value. If unspecified, at most 1000
      validations will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListValidations` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListValidations` must
      match the call that provided the page token.
    parent: Required. The project and location from which to list Validations.
      Format: projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class FaulttestingProjectsLocationsValidationsValidationResourcesGetRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsValidationsValidationResourcesGetRequest
  object.

  Fields:
    name: Required. The name of the validation resource. Format: projects/{pro
      ject}/locations/{location}/validations/{validation}/validationResources/
      {validation_resource}
  """

  name = _messages.StringField(1, required=True)


class FaulttestingProjectsLocationsValidationsValidationResourcesListRequest(_messages.Message):
  r"""A FaulttestingProjectsLocationsValidationsValidationResourcesListRequest
  object.

  Fields:
    filter: Optional. Filtering results
    pageSize: Optional. The maximum number of validation resources to return.
      The service may return fewer than this value. If unspecified, at most
      1000 validation resources will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListValidationResources` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListValidationResources` must match the call that provided the page
      token.
    parent: Required. The validation from which to list validation resources.
      Format: projects/{project}/locations/{location}/validations/{validation}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class GCEFailCompute(_messages.Message):
  r"""GCEFailCompute specifies which instances to fail.

  Fields:
    instance: Specify a single instance by name. Format:
      "projects/*/zones/*/instances/*".
    location: Specify that an entire zone or region should be affected.
    mig: Specify a managed instance group. Can be zonal or regional.
    secureTagValue: Specify a group of non-MIG (Managed Instance Group)
      instances by secure tag. See
      https://cloud.google.com/firewall/docs/tags-firewalls-overview for more
      details on tags. Format: "tagValues/[0-9]+"
  """

  instance = _messages.StringField(1)
  location = _messages.StringField(2)
  mig = _messages.MessageField('MigElement', 3)
  secureTagValue = _messages.StringField(4)


class GKEFailCompute(_messages.Message):
  r"""GKEFailCompute specifies infrastructure or workload to fail.

  Fields:
    cluster: Required. Options for selecting which GKE resources to fail. The
      GKE cluster resource name.
    k8sNamespace: Optional. Specify one or more Kubernetes namespaces.
    location: Optional. Specify a zone or region location.
  """

  cluster = _messages.StringField(1)
  k8sNamespace = _messages.StringField(2, repeated=True)
  location = _messages.StringField(3)


class HTTPAbort(_messages.Message):
  r"""Artificially return a specific HTTP status code for a percentage of
  requests.

  Fields:
    percentage: Required. Percentage of requests to abort, in the range 0 to
      100, inclusive.
    statusCode: Required. HTTP status code to return. In the range 200 to 599,
      inclusive.
  """

  percentage = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  statusCode = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class HTTPDelay(_messages.Message):
  r"""Artificially delay HTTP responses for a percentage of requests.

  Fields:
    delay: Required. Delay duration.
    percentage: Required. Percentage of requests to delay, in the range 0 to
      100, inclusive.
  """

  delay = _messages.StringField(1)
  percentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class L7LBHTTPFault(_messages.Message):
  r"""Injection of HTTP faults into a layer 7 load balancer.

  Fields:
    abort: Returns an HTTP error code for some requests.
    backendService: Optional. Optional identifying name of the backend service
      to inject faults into. Formatted like
      projects/{project}/regions/{region}/backendServices/{backendService} or
      projects/{project}/global/backendServices/{backendService} If not
      specified, all backend services connected to the forwarding_rule will be
      affected.
    delay: Delays some HTTP responses.
    forwardingRule: Required. The identifying name of the forwarding rule
      resource where the faults will be injected. Formatted like
      projects/{project}/regions/{region}/forwardingRules/{forwardingRule} or
      projects/{project}/global/forwardingRules/{forwardingRule}
  """

  abort = _messages.MessageField('HTTPAbort', 1)
  backendService = _messages.StringField(2)
  delay = _messages.MessageField('HTTPDelay', 3)
  forwardingRule = _messages.StringField(4)


class ListAffectedResourcesResponse(_messages.Message):
  r"""Response message for FaultTesting.ListAffectedResources.

  Fields:
    affectedResources: The affected resources from the specified experiment,
      ordered from newest to oldest based on creation time.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Unordered list. Locations that could not be reached.
  """

  affectedResources = _messages.MessageField('AffectedResource', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListExperimentTemplatesResponse(_messages.Message):
  r"""Request message for FaultTesting.ListExperimentTemplates.

  Fields:
    experimentTemplates: The experiment templates from the specified project.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Unordered list. Locations that could not be reached.
  """

  experimentTemplates = _messages.MessageField('ExperimentTemplate', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListExperimentsResponse(_messages.Message):
  r"""List out Experiments from a specified project.

  Fields:
    experiments: The experiments from the specified project, ordered from
      newest to oldest based on creation time.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Unordered list. Locations that could not be reached.
  """

  experiments = _messages.MessageField('Experiment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListValidationResourcesResponse(_messages.Message):
  r"""Response message for FaultTesting.ListValidationResources.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Unordered list. Locations that could not be reached.
    validationResources: The validation resources from the specified
      validation, ordered from newest to oldest based on creation time.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  validationResources = _messages.MessageField('ValidationResource', 3, repeated=True)


class ListValidationsResponse(_messages.Message):
  r"""List out Validations from a specified project.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Unordered list. Locations that could not be reached.
    validations: The Validations from the specified project, ordered from
      newest to oldest based on creation time.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  validations = _messages.MessageField('Validation', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MigElement(_messages.Message):
  r"""Details specifying a Managed Instance Group (MIG) and optionally a zone
  within it.

  Fields:
    instanceGroup: Required. The managed instance group. Can be zonal or
      regional.
    location: Optional. Optionally specify a zone location to further restrict
      a regional MIG.
  """

  instanceGroup = _messages.StringField(1)
  location = _messages.StringField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have google.longrunning.Operation.error value
      with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StopExperimentRequest(_messages.Message):
  r"""Request message for FaultTesting.StopExperiment."""


class Validation(_messages.Message):
  r"""A Validation is a test of an ExperimentTemplate's Action. It can have
  child ValidationResources which indicate the list of resources that will be
  affected if an Experiment is run from a template using this Action.

  Enums:
    StateValueValuesEnum: Output only. The current state of the Validation.
      Will be either PREPARING or COMPLETED.

  Fields:
    action: Required. The fault-injection action to be validated.
    createTime: Output only. Time the Validation was created.
    description: Optional. Optional user-provided description or notes. Min
      length 0, max length 2000.
    displayName: Optional. Human-readable name of the Validation.
    name: Identifier. The resource name of the Validation, of the form:
      projects/{project_id}/locations/{location}/validations/{validation}.
    state: Output only. The current state of the Validation. Will be either
      PREPARING or COMPLETED.
    stopTime: Output only. Time the Validation finished. Specifically when the
      Validation state becomes COMPLETED. The presence of this field can be
      used to determine if the Validation is done or not.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the Validation. Will be either
    PREPARING or COMPLETED.

    Values:
      STATE_UNSPECIFIED: Not used.
      PREPARING: The experiment resources are being identified and checked for
        permissions.
      PREPARED: It is ready to run.
      INJECTING: The resources associated with the experiment are being
        modified.
      INJECTED: The resources have been modified and we are waiting for the
        test duration to expire.
      REVERTING: It is in the process of stopping.
      COMPLETED: This is experiment has completed and no further actions will
        happen on its behalf.
    """
    STATE_UNSPECIFIED = 0
    PREPARING = 1
    PREPARED = 2
    INJECTING = 3
    INJECTED = 4
    REVERTING = 5
    COMPLETED = 6

  action = _messages.MessageField('Action', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  stopTime = _messages.StringField(7)


class ValidationResource(_messages.Message):
  r"""Cloud resource potentially affected by the action of a Validation.

  Enums:
    StateValueValuesEnum: The current state of the validation resource. Will
      be PREPARING or COMPLETED.

  Fields:
    affectedResourceUri: Required. The URI of a GCP cloud resource.
    cloudConsoleUrl: Output only. The URL to see this resource in the google
      cloud console
    displayName: Optional. The display name of the ValidationResource.
    error: Output only. The error encountered when validating this resource,
      if any.
    name: Identifier. The resource name of the ValidationResource, of the
      form: projects/{project}/locations/{location}/validations/{validation}/v
      alidationResources/{validation_resource}.
    state: The current state of the validation resource. Will be PREPARING or
      COMPLETED.
    stateMessage: A human-readable description of what is happening to the
      validation resource.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the validation resource. Will be PREPARING or
    COMPLETED.

    Values:
      STATE_UNSPECIFIED: Not used.
      PREPARING: The experiment resources are being identified and checked for
        permissions.
      PREPARED: It is ready to run.
      INJECTING: The resources associated with the experiment are being
        modified.
      INJECTED: The resources have been modified and we are waiting for the
        test duration to expire.
      REVERTING: It is in the process of stopping.
      COMPLETED: This is experiment has completed and no further actions will
        happen on its behalf.
    """
    STATE_UNSPECIFIED = 0
    PREPARING = 1
    PREPARED = 2
    INJECTING = 3
    INJECTED = 4
    REVERTING = 5
    COMPLETED = 6

  affectedResourceUri = _messages.StringField(1)
  cloudConsoleUrl = _messages.StringField(2)
  displayName = _messages.StringField(3)
  error = _messages.MessageField('Status', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  stateMessage = _messages.StringField(7)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
