/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(JAVASCRIPT_DEBUGGER)

#include "JSJavaScriptCallFrame.h"

#include "JSJavaScriptCallFrame.h"
#include "JavaScriptCallFrame.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSJavaScriptCallFrame);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSJavaScriptCallFrameTableValues[9] =
{
    { "caller", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameCaller), (intptr_t)0 THUNK_GENERATOR(0) },
    { "sourceID", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameSourceID), (intptr_t)0 THUNK_GENERATOR(0) },
    { "line", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameLine), (intptr_t)0 THUNK_GENERATOR(0) },
    { "column", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameColumn), (intptr_t)0 THUNK_GENERATOR(0) },
    { "scopeChain", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameScopeChain), (intptr_t)0 THUNK_GENERATOR(0) },
    { "thisObject", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameThisObject), (intptr_t)0 THUNK_GENERATOR(0) },
    { "functionName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameFunctionName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameType), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSJavaScriptCallFrameTable = { 17, 15, JSJavaScriptCallFrameTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSJavaScriptCallFramePrototypeTableValues[8] =
{
    { "GLOBAL_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameGLOBAL_SCOPE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "LOCAL_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameLOCAL_SCOPE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "WITH_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameWITH_SCOPE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "CLOSURE_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameCLOSURE_SCOPE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "CATCH_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameCATCH_SCOPE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "evaluate", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsJavaScriptCallFramePrototypeFunctionEvaluate), (intptr_t)1 THUNK_GENERATOR(0) },
    { "scopeType", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsJavaScriptCallFramePrototypeFunctionScopeType), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSJavaScriptCallFramePrototypeTable = { 17, 15, JSJavaScriptCallFramePrototypeTableValues, 0 };
const ClassInfo JSJavaScriptCallFramePrototype::s_info = { "JavaScriptCallFramePrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSJavaScriptCallFramePrototypeTable, 0 };

JSObject* JSJavaScriptCallFramePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSJavaScriptCallFrame>(exec, globalObject);
}

bool JSJavaScriptCallFramePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSJavaScriptCallFramePrototype, JSObject>(exec, &JSJavaScriptCallFramePrototypeTable, this, propertyName, slot);
}

bool JSJavaScriptCallFramePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSJavaScriptCallFramePrototype, JSObject>(exec, &JSJavaScriptCallFramePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSJavaScriptCallFrame::s_info = { "JavaScriptCallFrame", &JSDOMWrapper::s_info, &JSJavaScriptCallFrameTable, 0 };

JSJavaScriptCallFrame::JSJavaScriptCallFrame(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<JavaScriptCallFrame> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSJavaScriptCallFrame::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSJavaScriptCallFramePrototype(exec->globalData(), globalObject, JSJavaScriptCallFramePrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSJavaScriptCallFrame::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSJavaScriptCallFrame, Base>(exec, &JSJavaScriptCallFrameTable, this, propertyName, slot);
}

bool JSJavaScriptCallFrame::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSJavaScriptCallFrame, Base>(exec, &JSJavaScriptCallFrameTable, this, propertyName, descriptor);
}

JSValue jsJavaScriptCallFrameCaller(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->caller()));
    return result;
}


JSValue jsJavaScriptCallFrameSourceID(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = jsNumber(imp->sourceID());
    return result;
}


JSValue jsJavaScriptCallFrameLine(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = jsNumber(imp->line());
    return result;
}


JSValue jsJavaScriptCallFrameColumn(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = jsNumber(imp->column());
    return result;
}


JSValue jsJavaScriptCallFrameScopeChain(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(slotBase));
    return castedThis->scopeChain(exec);
}


JSValue jsJavaScriptCallFrameThisObject(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(slotBase));
    return castedThis->thisObject(exec);
}


JSValue jsJavaScriptCallFrameFunctionName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = jsString(exec, imp->functionName());
    return result;
}


JSValue jsJavaScriptCallFrameType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(slotBase));
    return castedThis->type(exec);
}


EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionEvaluate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSJavaScriptCallFrame::s_info))
        return throwVMTypeError(exec);
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(thisValue));
    return JSValue::encode(castedThis->evaluate(exec));
}

EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionScopeType(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSJavaScriptCallFrame::s_info))
        return throwVMTypeError(exec);
    JSJavaScriptCallFrame* castedThis = static_cast<JSJavaScriptCallFrame*>(asObject(thisValue));
    return JSValue::encode(castedThis->scopeType(exec));
}

// Constant getters

JSValue jsJavaScriptCallFrameGLOBAL_SCOPE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsJavaScriptCallFrameLOCAL_SCOPE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsJavaScriptCallFrameWITH_SCOPE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsJavaScriptCallFrameCLOSURE_SCOPE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsJavaScriptCallFrameCATCH_SCOPE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, JavaScriptCallFrame* impl)
{
    return wrap<JSJavaScriptCallFrame>(exec, globalObject, impl);
}

JavaScriptCallFrame* toJavaScriptCallFrame(JSC::JSValue value)
{
    return value.inherits(&JSJavaScriptCallFrame::s_info) ? static_cast<JSJavaScriptCallFrame*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
