/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.serialization.Cached;

public interface JvmInstallationMetadata {
    public static DefaultJvmInstallationMetadata from(File javaHome, String javaVersion, String javaVendor, String runtimeName, String runtimeVersion, String jvmName, String jvmVersion, String jvmVendor, String architecture) {
        return new DefaultJvmInstallationMetadata(javaHome, javaVersion, javaVendor, runtimeName, runtimeVersion, jvmName, jvmVersion, jvmVendor, architecture);
    }

    public static JvmInstallationMetadata failure(File javaHome, String errorMessage) {
        return new FailureInstallationMetadata(javaHome, errorMessage, null);
    }

    public static JvmInstallationMetadata failure(File javaHome, Exception cause) {
        return new FailureInstallationMetadata(javaHome, cause.getMessage(), cause);
    }

    public Path getJavaHome();

    public JavaVersion getLanguageVersion();

    public JvmVendor getVendor();

    public String getJavaVersion();

    public String getRuntimeName();

    public String getRuntimeVersion();

    public String getJvmName();

    public String getJvmVersion();

    public String getJvmVendor();

    public String getArchitecture();

    public String getDisplayName();

    public boolean hasCapability(JavaInstallationCapability var1);

    public String getErrorMessage();

    public Throwable getErrorCause();

    public boolean isValidInstallation();

    public static class FailureInstallationMetadata
    implements JvmInstallationMetadata {
        private final File javaHome;
        private final String errorMessage;
        @Nullable
        private final Exception cause;

        private FailureInstallationMetadata(File javaHome, String errorMessage, @Nullable Exception cause) {
            this.javaHome = javaHome;
            this.errorMessage = errorMessage;
            this.cause = cause;
        }

        @Override
        public Path getJavaHome() {
            return this.javaHome.toPath();
        }

        @Override
        public JavaVersion getLanguageVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public JvmVendor getVendor() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJavaVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getRuntimeName() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getRuntimeVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJvmName() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJvmVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJvmVendor() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getArchitecture() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getDisplayName() {
            return "Invalid installation: " + this.getErrorMessage();
        }

        @Override
        public boolean hasCapability(JavaInstallationCapability capability) {
            return false;
        }

        private UnsupportedOperationException unsupportedOperation() {
            return new UnsupportedOperationException("Installation is not valid. Original error message: " + this.getErrorMessage());
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public Throwable getErrorCause() {
            return this.cause;
        }

        @Override
        public boolean isValidInstallation() {
            return false;
        }
    }

    public static class DefaultJvmInstallationMetadata
    implements JvmInstallationMetadata {
        private final Path javaHome;
        private final JavaVersion languageVersion;
        private final String javaVersion;
        private final String javaVendor;
        private final String runtimeName;
        private final String runtimeVersion;
        private final String jvmName;
        private final String jvmVersion;
        private final String jvmVendor;
        private final String architecture;
        private final Cached<Set<JavaInstallationCapability>> capabilities = Cached.of(this::gatherCapabilities);

        private DefaultJvmInstallationMetadata(File javaHome, String javaVersion, String javaVendor, String runtimeName, String runtimeVersion, String jvmName, String jvmVersion, String jvmVendor, String architecture) {
            this.javaHome = javaHome.toPath();
            this.languageVersion = JavaVersion.toVersion((Object)javaVersion);
            this.javaVersion = javaVersion;
            this.javaVendor = javaVendor;
            this.runtimeName = runtimeName;
            this.runtimeVersion = runtimeVersion;
            this.jvmName = jvmName;
            this.jvmVersion = jvmVersion;
            this.jvmVendor = jvmVendor;
            this.architecture = architecture;
        }

        @Override
        public Path getJavaHome() {
            return this.javaHome;
        }

        @Override
        public JavaVersion getLanguageVersion() {
            return this.languageVersion;
        }

        @Override
        public JvmVendor getVendor() {
            return JvmVendor.fromString(this.javaVendor);
        }

        @Override
        public String getJavaVersion() {
            return this.javaVersion;
        }

        @Override
        public String getRuntimeName() {
            return this.runtimeName;
        }

        @Override
        public String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @Override
        public String getJvmName() {
            return this.jvmName;
        }

        @Override
        public String getJvmVersion() {
            return this.jvmVersion;
        }

        @Override
        public String getJvmVendor() {
            return this.jvmVendor;
        }

        @Override
        public String getArchitecture() {
            return this.architecture;
        }

        @Override
        public String getDisplayName() {
            String vendor = this.determineVendorName();
            String installationType = this.determineInstallationType(vendor);
            return MessageFormat.format("{0}{1}", vendor, installationType);
        }

        private String determineVendorName() {
            JvmVendor.KnownJvmVendor vendor = this.getVendor().getKnownVendor();
            if (vendor == JvmVendor.KnownJvmVendor.ORACLE && this.jvmName != null && this.jvmName.contains("OpenJDK")) {
                return "OpenJDK";
            }
            return this.getVendor().getDisplayName();
        }

        private String determineInstallationType(String vendor) {
            if (this.hasCapability(JavaInstallationCapability.JAVA_COMPILER)) {
                if (!vendor.toLowerCase().contains("jdk")) {
                    return " JDK";
                }
                return "";
            }
            return " JRE";
        }

        @Override
        public boolean hasCapability(JavaInstallationCapability capability) {
            return ((Set)this.capabilities.get()).contains((Object)capability);
        }

        private Set<JavaInstallationCapability> gatherCapabilities() {
            boolean isJ9vm;
            HashSet<JavaInstallationCapability> capabilities = new HashSet<JavaInstallationCapability>(2);
            File javaCompiler = new File(new File(this.javaHome.toFile(), "bin"), OperatingSystem.current().getExecutableName("javac"));
            if (javaCompiler.exists()) {
                capabilities.add(JavaInstallationCapability.JAVA_COMPILER);
            }
            if (isJ9vm = this.jvmName.contains("J9")) {
                capabilities.add(JavaInstallationCapability.J9_VIRTUAL_MACHINE);
            }
            return capabilities;
        }

        @Override
        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Throwable getErrorCause() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValidInstallation() {
            return true;
        }

        public String toString() {
            return "DefaultJvmInstallationMetadata{languageVersion=" + this.languageVersion + ", javaVersion='" + this.javaVersion + '\'' + ", javaVendor='" + this.javaVendor + '\'' + ", runtimeName='" + this.runtimeName + '\'' + ", runtimeVersion='" + this.runtimeVersion + '\'' + ", jvmName='" + this.jvmName + '\'' + ", jvmVersion='" + this.jvmVersion + '\'' + ", jvmVendor='" + this.jvmVendor + '\'' + ", architecture='" + this.architecture + '\'' + '}';
        }
    }

    public static enum JavaInstallationCapability {
        JAVA_COMPILER,
        J9_VIRTUAL_MACHINE;

    }
}

