/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000f\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasThrowableSupertype", "", "hasGenericOuterDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirThrowableSubclassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirThrowableSubclassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n38#2:62\n54#2:63\n54#2:67\n38#2:68\n1755#3,3:64\n*S KotlinDebug\n*F\n+ 1 FirThrowableSubclassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker\n*L\n32#1:62\n32#1:63\n54#1:67\n54#1:68\n46#1:64,3\n*E\n"})
public final class FirThrowableSubclassChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirThrowableSubclassChecker INSTANCE = new FirThrowableSubclassChecker();

    private FirThrowableSubclassChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!this.hasThrowableSupertype(declaration, context)) {
            return;
        }
        if (!((Collection)declaration.getTypeParameters()).isEmpty()) {
            boolean bl;
            Object object = CollectionsKt.firstOrNull(declaration.getTypeParameters());
            if (object != null && (object = object.getSource()) != null) {
                Object it = object;
                boolean bl2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getGENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context, null, 8, null);
            }
            FirClass firClass = declaration;
            if (firClass instanceof FirRegularClass) {
                FirMemberDeclaration $this$isInner$iv = declaration;
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) {
                    FirClassLikeDeclaration $this$isLocal$iv = declaration;
                    boolean $i$f$isLocal = false;
                    if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) return;
                }
                bl = true;
            } else {
                if (!(firClass instanceof FirAnonymousObject)) return;
                bl = true;
            }
            boolean shouldReport = bl;
            if (!shouldReport) return;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        if (!this.hasGenericOuterDeclaration(declaration, context)) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context, null, 8, null);
    }

    private final boolean hasThrowableSupertype(FirClass $this$hasThrowableSupertype, CheckerContext context) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes($this$hasThrowableSupertype);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof ConeErrorType) && FirHelpersKt.isSubtypeOfThrowable(it, context.getSession()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasGenericOuterDeclaration(FirClass $this$hasGenericOuterDeclaration, CheckerContext context) {
        if (!FirDeclarationUtilKt.getClassId($this$hasGenericOuterDeclaration).isLocal()) {
            return false;
        }
        for (FirDeclaration containingDeclaration : CollectionsKt.asReversed(context.getContainingDeclarations())) {
            if (containingDeclaration instanceof FirTypeParameterRefsOwner && !((Collection)((FirTypeParameterRefsOwner)((Object)containingDeclaration)).getTypeParameters()).isEmpty()) {
                return true;
            }
            if (!(containingDeclaration instanceof FirRegularClass)) continue;
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)containingDeclaration;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) continue;
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)containingDeclaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) continue;
            return false;
        }
        return false;
    }
}

