/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex.commit;

import com.intellij.openapi.project.Project;
import com.intellij.vcs.commit.AbstractCommitMessagePolicy;
import com.intellij.vcs.commit.CommitMessageUi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\b\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/ex/commit/ChunkCommitMessagePolicy;", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "project", "Lcom/intellij/openapi/project/Project;", "commitMessageUi", "Lcom/intellij/vcs/commit/CommitMessageUi;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/CommitMessageUi;)V", "init", "", "onBeforeCommit", "onAfterCommit", "getCommitMessage", "", "saveTempChunkCommitMessage", "commitMessage", "intellij.platform.vcs.impl"})
final class ChunkCommitMessagePolicy
extends AbstractCommitMessagePolicy {
    @NotNull
    private final CommitMessageUi commitMessageUi;

    public ChunkCommitMessagePolicy(@NotNull Project project, @NotNull CommitMessageUi commitMessageUi) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessageUi, (String)"commitMessageUi");
        super(project);
        this.commitMessageUi = commitMessageUi;
    }

    public final void init() {
        this.commitMessageUi.setText(this.getCommitMessage());
    }

    public final void onBeforeCommit() {
        String commitMessage = this.commitMessageUi.getText();
        this.getVcsConfiguration().saveCommitMessage(commitMessage);
    }

    public final void onAfterCommit() {
        this.saveTempChunkCommitMessage("");
        this.commitMessageUi.setText(this.getCommitMessage());
    }

    private final String getCommitMessage() {
        String string = this.getVcsConfiguration().getTempChunkCommitMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempChunkCommitMessage(...)");
        return string;
    }

    public final void saveTempChunkCommitMessage(@NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        this.getVcsConfiguration().saveTempChunkCommitMessage(commitMessage);
    }
}

