/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlBlock
extends AbstractXmlBlock {
    private final Indent myIndent;
    private final TextRange myTextRange;
    private static final Logger LOG = Logger.getInstance(XmlBlock.class);

    public XmlBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        this(node, wrap, alignment, policy, indent, textRange, false);
    }

    public XmlBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange, boolean preserveSpace) {
        super(node, wrap, alignment, policy, preserveSpace);
        this.myIndent = indent;
        this.myTextRange = textRange;
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myTextRange != null && !this.isCDATAStart() && !this.isCDATAEnd()) {
            TextRange textRange = this.myTextRange;
            if (textRange == null) {
                XmlBlock.$$$reportNull$$$0(0);
            }
            return textRange;
        }
        TextRange textRange = super.getTextRange();
        if (textRange == null) {
            XmlBlock.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    protected List<Block> buildChildren() {
        if (this.myNode.getElementType() == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return this.splitAttribute(this.myNode, this.myXmlFormattingPolicy);
        }
        if (this.myNode.getElementType() == XmlElementType.XML_COMMENT) {
            SmartList result2 = new SmartList();
            if (this.buildInjectedPsiBlocks((List<Block>)result2, this.myNode, this.myWrap, null, Indent.getNoneIndent())) {
                return result2;
            }
            return this.splitComment();
        }
        if (this.myNode.getFirstChildNode() != null) {
            boolean keepWhitespaces = this.shouldKeepWhitespaces();
            ArrayList<Block> result3 = new ArrayList<Block>(5);
            ASTNode child = this.myNode.getFirstChildNode();
            while (child != null) {
                if (child.getTextLength() > 0) {
                    if (XmlBlock.containsWhiteSpacesOnly(child)) {
                        if (keepWhitespaces) {
                            result3.add((Block)new ReadOnlyBlock(child));
                        }
                    } else {
                        child = this.processChild(result3, child, this.getDefaultWrap(child), null, this.getChildDefaultIndent());
                    }
                }
                if (child == null) continue;
                LOG.assertTrue(child.getTreeParent() == this.myNode);
                child = child.getTreeNext();
            }
            return result3;
        }
        return EMPTY;
    }

    private boolean shouldKeepWhitespaces() {
        if (this.isTextNode(this.myNode.getElementType())) {
            if (this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces()) {
                return true;
            }
            ASTNode treeParent = this.myNode.getTreeParent();
            XmlTag tag = XmlBlock.getTag(treeParent);
            if (tag != null && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(tag)) {
                return true;
            }
        }
        return false;
    }

    protected List<Block> splitAttribute(ASTNode node, XmlFormattingPolicy formattingPolicy) {
        ArrayList<Block> result2 = new ArrayList<Block>(3);
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || child.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                result2.add((Block)new XmlBlock(child, null, null, formattingPolicy, null, null, this.isPreserveSpace()));
                continue;
            }
            if (!child.getPsi().getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && XmlBlock.containsOuterLanguageElement(child)) {
                this.createLeafBlocks(child, result2);
                continue;
            }
            if (child.getElementType() == TokenType.ERROR_ELEMENT && child.getFirstChildNode() == null) continue;
            result2.add((Block)new ReadOnlyBlock(child));
        }
        return result2;
    }

    private void createLeafBlocks(ASTNode node, List<Block> result2) {
        if (node instanceof OuterLanguageElement) {
            this.processChild(result2, node, null, null, null);
            return;
        }
        ASTNode child = node.getFirstChildNode();
        if (child == null && !(node instanceof PsiWhiteSpace) && node.getElementType() != TokenType.ERROR_ELEMENT && node.getTextLength() > 0) {
            result2.add((Block)new ReadOnlyBlock(node));
            return;
        }
        while (child != null) {
            this.createLeafBlocks(child, result2);
            child = child.getTreeNext();
        }
    }

    private static boolean containsOuterLanguageElement(ASTNode node) {
        if (node instanceof OuterLanguageElement) {
            return true;
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child instanceof OuterLanguageElement) {
                return true;
            }
            if (!XmlBlock.containsOuterLanguageElement(child)) continue;
            return true;
        }
        return false;
    }

    protected List<Block> splitComment() {
        if (this.myNode.getElementType() != XmlElementType.XML_COMMENT) {
            return EMPTY;
        }
        ArrayList<Block> result2 = new ArrayList<Block>(3);
        boolean hasOuterLangElements = false;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child instanceof OuterLanguageElement) {
                hasOuterLangElements = true;
            }
            result2.add((Block)new XmlBlock(child, null, null, this.myXmlFormattingPolicy, this.getChildIndent(), null, this.isPreserveSpace()));
        }
        if (hasOuterLangElements) {
            return result2;
        }
        return EMPTY;
    }

    @Nullable
    protected Wrap getDefaultWrap(ASTNode node) {
        return null;
    }

    @Nullable
    protected Indent getChildDefaultIndent() {
        if (this.myNode.getElementType() == XmlElementType.HTML_DOCUMENT) {
            return Indent.getNoneIndent();
        }
        if (this.myNode.getElementType() == TokenType.DUMMY_HOLDER) {
            return Indent.getNoneIndent();
        }
        if (this.myNode.getElementType() == XmlElementType.XML_PROLOG) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            XmlBlock.$$$reportNull$$$0(2);
        }
        if (!(child1 instanceof AbstractBlock) || !(child2 instanceof AbstractBlock)) {
            return null;
        }
        IElementType elementType = this.myNode.getElementType();
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        IElementType type1 = node1.getElementType();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type2 = node2.getElementType();
        if ((this.isXmlTag(node2) || type2 == XmlTokenType.XML_END_TAG_START || this.isTextNode(type2)) && this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (this.isTextNode(elementType)) {
            return this.getSpacesInsideText(type1, type2);
        }
        if (this.isAttributeElementType(elementType)) {
            return this.getSpacesInsideAttribute(type1, type2);
        }
        if (type1 == XmlElementType.XML_PROLOG) {
            return this.createDefaultSpace(true, false);
        }
        if (elementType == XmlElementType.XML_DOCTYPE) {
            return this.createDefaultSpace(true, false);
        }
        if (type1 == XmlElementType.XML_COMMENT) {
            return this.createDefaultSpace(true, false);
        }
        return this.createDefaultSpace(false, false);
    }

    protected Spacing getSpacesInsideAttribute(IElementType type1, IElementType type2) {
        if (type1 == XmlTokenType.XML_EQ || type2 == XmlTokenType.XML_EQ) {
            int spaces = this.myXmlFormattingPolicy.getShouldAddSpaceAroundEqualityInAttribute() ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return this.createDefaultSpace(false, false);
    }

    private Spacing getSpacesInsideText(IElementType type1, IElementType type2) {
        if (type1 == XmlTokenType.XML_DATA_CHARACTERS && type2 == XmlTokenType.XML_DATA_CHARACTERS) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return this.createDefaultSpace(false, true);
    }

    public Indent getIndent() {
        if (this.myNode.getElementType() == XmlElementType.XML_PROLOG || this.myNode.getElementType() == XmlElementType.XML_DOCTYPE || SourceTreeToPsiMap.treeElementToPsi((ASTNode)this.myNode) instanceof XmlDocument) {
            return Indent.getNoneIndent();
        }
        return this.myIndent;
    }

    @Override
    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean isTextElement() {
        return this.isTextNode(this.myNode.getElementType()) || this.myNode.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || this.myNode.getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF || this.myNode.getElementType() == XmlElementType.XML_ENTITY_REF;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        PsiElement element = this.myNode.getPsi();
        if (element instanceof PsiFile || element instanceof XmlDocument || element instanceof XmlProlog) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            XmlBlock.$$$reportNull$$$0(3);
        }
        return childAttributes;
    }

    public XmlFormattingPolicy getPolicy() {
        return this.myXmlFormattingPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/xml/XmlBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/xml/XmlBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2 -> new IllegalArgumentException(string2);
        };
    }
}

