/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.server.Maven36ServerEmbedderImpl;
import org.jetbrains.idea.maven.server.Maven3ModelInheritanceAssembler;
import org.jetbrains.idea.maven.server.Maven3ServerEmbedder;
import org.jetbrains.idea.maven.server.Maven3ServerEmbedderImpl;
import org.jetbrains.idea.maven.server.Maven3ServerIndexerImpl;
import org.jetbrains.idea.maven.server.Maven3XProfileUtil;
import org.jetbrains.idea.maven.server.MavenCoreInitializationException;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenServerBase;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerStatsCollector;
import org.jetbrains.idea.maven.server.MavenServerStatus;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.security.MavenToken;

public class Maven36ServerImpl
extends MavenServerBase {
    public MavenServerEmbedder createEmbedder(MavenEmbedderSettings settings, MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            Maven36ServerEmbedderImpl result = new Maven36ServerEmbedderImpl(settings);
            UnicastRemoteObject.exportObject((Remote)((Object)result), 0);
            return result;
        }
        catch (MavenCoreInitializationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    public MavenServerIndexer createIndexer(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            Maven3ServerIndexerImpl result = new Maven3ServerIndexerImpl((Maven3ServerEmbedder)new Maven3ServerEmbedderImpl(new MavenEmbedderSettings(new MavenServerSettings()))){

                public Maven3ServerEmbedder createEmbedder(MavenServerSettings settings) throws RemoteException {
                    return new Maven36ServerEmbedderImpl(new MavenEmbedderSettings(settings));
                }
            };
            UnicastRemoteObject.exportObject((Remote)result, 0);
            return result;
        }
        catch (Throwable e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    @NotNull
    public MavenModel interpolateAndAlignModel(MavenModel model, File basedir, File pomDir, MavenToken token) {
        MavenModel mavenModel;
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            mavenModel = Maven3XProfileUtil.interpolateAndAlignModel((MavenModel)model, (File)basedir, (File)pomDir);
        }
        catch (Throwable e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
        if (mavenModel == null) {
            Maven36ServerImpl.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    public MavenModel assembleInheritance(MavenModel model, MavenModel parentModel, MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            return Maven3ModelInheritanceAssembler.assembleInheritance((MavenModel)model, (MavenModel)parentModel);
        }
        catch (Throwable e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    public ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, HashSet<String> alwaysOnProfiles, MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            return Maven3XProfileUtil.applyProfiles((MavenModel)model, (File)basedir, (MavenExplicitProfiles)explicitProfiles, alwaysOnProfiles);
        }
        catch (Throwable e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    public MavenServerStatus getDebugStatus(boolean clean) {
        MavenServerStatus status = new MavenServerStatus();
        if (!MavenServerStatsCollector.collectStatistics) {
            return new MavenServerStatus();
        }
        status.statusCollected = true;
        MavenServerStatsCollector.fill((MavenServerStatus)status, (boolean)clean);
        return status;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven36ServerImpl", "interpolateAndAlignModel"));
    }
}

