/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statements;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public final class InitializerProcessor {
    public static void extractInitializers(ClassWrapper wrapper) {
        MethodWrapper method = wrapper.getMethodWrapper("<clinit>", "()V");
        if (method != null && method.root != null) {
            InitializerProcessor.extractStaticInitializers(wrapper, method);
        }
        InitializerProcessor.extractDynamicInitializers(wrapper);
        InitializerProcessor.liftConstructor(wrapper);
        if (DecompilerContext.getOption("hes")) {
            InitializerProcessor.hideEmptySuper(wrapper);
        }
    }

    private static void liftConstructor(ClassWrapper wrapper) {
        block0: for (MethodWrapper method : wrapper.getMethods()) {
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null) {
                return;
            }
            int index = 0;
            List<Exprent> lstExprents = firstData.getExprents();
            for (Exprent exprent : lstExprents) {
                int action = 0;
                if (exprent.type == 2) {
                    StructField structField;
                    FieldExprent fExpr;
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5 && assignExpr.getRight().type == 12 && (fExpr = (FieldExprent)assignExpr.getLeft()).getClassname().equals(wrapper.getClassStruct().qualifiedName) && (structField = wrapper.getClassStruct().getField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) != null && structField.hasModifier(16)) {
                        action = 1;
                    }
                } else if (index > 0 && exprent.type == 8 && Statements.isInvocationInitConstructor((InvocationExprent)exprent, method, wrapper, true)) {
                    lstExprents.add(0, lstExprents.remove(index));
                    action = 2;
                }
                if (action != 1) continue block0;
                ++index;
            }
        }
    }

    private static void hideEmptySuper(ClassWrapper wrapper) {
        for (MethodWrapper method : wrapper.getMethods()) {
            InvocationExprent invExpr;
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null || firstData.getExprents() == null || firstData.getExprents().isEmpty()) {
                return;
            }
            Exprent exprent = firstData.getExprents().get(0);
            if (exprent.type != 8 || !Statements.isInvocationInitConstructor(invExpr = (InvocationExprent)exprent, method, wrapper, false)) continue;
            List<VarVersion> mask = ExprUtil.getSyntheticParametersMask(invExpr.getClassName(), invExpr.getStringDescriptor(), invExpr.getParameters().size());
            boolean hideSuper = true;
            for (int i = 0; i < invExpr.getDescriptor().params.length; ++i) {
                ClassesProcessor.ClassNode node;
                if (mask != null && mask.get(i) != null) continue;
                VarType type = invExpr.getDescriptor().params[i];
                if (type.getType() == 8 && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(type.getValue())) != null && (node.type == 2 || (node.access & 0x1000) != 0)) break;
                hideSuper = false;
                break;
            }
            if (!hideSuper) continue;
            firstData.getExprents().remove(0);
        }
    }

    public static void hideInitalizers(ClassWrapper wrapper) {
        for (MethodWrapper method : wrapper.getMethods()) {
            ClassesProcessor.ClassNode node;
            VarType type;
            StructMethod mt = method.methodStruct;
            String name = mt.getName();
            String desc = mt.getDescriptor();
            if (!mt.isSynthetic() || !"<init>".equals(name)) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(desc);
            if (md.params.length <= 0 || (type = md.params[md.params.length - 1]).getType() != 8 || ((node = DecompilerContext.getClassProcessor().getMapRootClasses().get(type.getValue())) == null || node.type != 2) && (node.access & 0x1000) == 0) continue;
            wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(name, desc));
        }
    }

    private static void extractStaticInitializers(ClassWrapper wrapper, MethodWrapper method) {
        RootStatement root = method.root;
        StructClass cl = wrapper.getClassStruct();
        Statement firstData = Statements.findFirstData(root);
        if (firstData != null) {
            boolean inlineInitializers;
            boolean bl = inlineInitializers = cl.hasModifier(512) || cl.hasModifier(16384);
            while (!firstData.getExprents().isEmpty()) {
                Exprent exprent = firstData.getExprents().get(0);
                boolean found = false;
                if (exprent.type == 2) {
                    FieldExprent fExpr;
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5 && (fExpr = (FieldExprent)assignExpr.getLeft()).isStatic() && fExpr.getClassname().equals(cl.qualifiedName) && cl.hasField(fExpr.getName(), fExpr.getDescriptor().descriptorString) && (inlineInitializers || InitializerProcessor.isExprentIndependent(assignExpr.getRight(), method))) {
                        String keyField = InterpreterUtil.makeUniqueKey(fExpr.getName(), fExpr.getDescriptor().descriptorString);
                        if (!wrapper.getStaticFieldInitializers().containsKey(keyField)) {
                            wrapper.getStaticFieldInitializers().addWithKey(assignExpr.getRight(), keyField);
                            firstData.getExprents().remove(0);
                            found = true;
                        }
                    }
                }
                if (found) continue;
                break;
            }
        }
    }

    private static void extractDynamicInitializers(ClassWrapper wrapper) {
        StructClass cl = wrapper.getClassStruct();
        boolean isAnonymous = DecompilerContext.getClassProcessor().getMapRootClasses().get((Object)cl.qualifiedName).type == 2;
        ArrayList<List<Exprent>> lstFirst = new ArrayList<List<Exprent>>();
        ArrayList<MethodWrapper> lstMethodWrappers = new ArrayList<MethodWrapper>();
        for (MethodWrapper method : wrapper.getMethods()) {
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null || firstData.getExprents().isEmpty()) {
                return;
            }
            lstFirst.add(firstData.getExprents());
            lstMethodWrappers.add(method);
            Exprent exprent = firstData.getExprents().get(0);
            if (isAnonymous || exprent.type == 8 && Statements.isInvocationInitConstructor((InvocationExprent)exprent, method, wrapper, false)) continue;
            return;
        }
        if (lstFirst.isEmpty()) {
            return;
        }
        Set recordComponents = Optional.ofNullable(cl.getRecordComponents()).stream().flatMap(l -> l.stream()).map(c -> InterpreterUtil.makeUniqueKey(c.getName(), c.getDescriptor())).collect(Collectors.toSet());
        block1: while (true) {
            List lst;
            String fieldWithDescr = null;
            Exprent value = null;
            for (int i = 0; i < lstFirst.size(); ++i) {
                lst = (List)lstFirst.get(i);
                if (lst.size() < (isAnonymous ? 1 : 2)) {
                    return;
                }
                Exprent exprent = (Exprent)lst.get(isAnonymous ? 0 : 1);
                boolean found = false;
                if (exprent.type == 2) {
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5) {
                        FieldExprent fExpr = (FieldExprent)assignExpr.getLeft();
                        String fieldKey = InterpreterUtil.makeUniqueKey(fExpr.getName(), fExpr.getDescriptor().descriptorString);
                        if (!fExpr.isStatic() && fExpr.getClassname().equals(cl.qualifiedName) && cl.hasField(fExpr.getName(), fExpr.getDescriptor().descriptorString) && !recordComponents.contains(fieldKey) && InitializerProcessor.isExprentIndependent(assignExpr.getRight(), (MethodWrapper)lstMethodWrappers.get(i))) {
                            if (fieldWithDescr == null) {
                                fieldWithDescr = fieldKey;
                                value = assignExpr.getRight();
                            } else if (!fieldWithDescr.equals(fieldKey) || !value.equals(assignExpr.getRight())) {
                                return;
                            }
                            found = true;
                        }
                    }
                }
                if (found) continue;
                return;
            }
            if (wrapper.getDynamicFieldInitializers().containsKey(fieldWithDescr)) break;
            wrapper.getDynamicFieldInitializers().addWithKey(value, fieldWithDescr);
            Iterator iterator = lstFirst.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                lst = (List)iterator.next();
                lst.remove(isAnonymous ? 0 : 1);
            }
            break;
        }
    }

    private static boolean isExprentIndependent(Exprent exprent, MethodWrapper method) {
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        block4: for (Exprent expr : lst) {
            switch (expr.type) {
                case 12: {
                    String varName;
                    VarVersion varPair = new VarVersion((VarExprent)expr);
                    if (method.varproc.getExternalVars().contains(varPair) || (varName = method.varproc.getVarName(varPair)).equals("this") || varName.endsWith(".this")) continue block4;
                    return false;
                }
                case 5: {
                    return false;
                }
            }
        }
        return true;
    }
}

