/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u0007\u001a\u00130\b\u00a2\u0006\u000e\b\t\u0012\n\b\n\u0012\u0006\b\n0\u000b8\fH\u0016J\u0019\u0010\r\u001a\u00130\b\u00a2\u0006\u000e\b\t\u0012\n\b\n\u0012\u0006\b\n0\u000b8\fH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J!\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/json/intentions/JsonSortPropertiesIntention;", "Lcom/intellij/codeInsight/intention/BaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getText", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "reformat", "obj", "Lcom/intellij/json/psi/JsonObject;", "startInWriteAction", "Session", "intellij.json"})
public class JsonSortPropertiesIntention
extends BaseElementAtCaretIntentionAction
implements LowPriorityAction,
LightEditCompatible,
DumbAware {
    @NotNull
    public String getText() {
        String string = JsonBundle.message((String)"json.intention.sort.properties", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message((String)"json.intention.sort.properties", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new Session(editor, element).hasUnsortedObjects();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JsonBundle.message((String)"file.is.readonly", (Object[])new Object[0]), (String)JsonBundle.message((String)"cannot.sort.properties", (Object[])new Object[0]), null);
            return;
        }
        Session session = new Session(editor, element);
        if (session.getRootObj() != null) {
            session.sort();
            this.reformat(project, editor, session.getRootObj());
        }
    }

    private final void reformat(Project project, Editor editor, JsonObject obj) {
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)obj));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        SmartPsiElementPointer pointer = smartPsiElementPointer;
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        JsonObject jsonObject = (JsonObject)pointer.getElement();
        if (jsonObject == null) {
            return;
        }
        JsonObject element = jsonObject;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformatText(element.getContainingFile(), (Collection)SetsKt.setOf((Object)element.getTextRange()));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J.\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001dH\u0002J&\u0010!\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/json/intentions/JsonSortPropertiesIntention$Session;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "contextElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;)V", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "rootObj", "Lcom/intellij/json/psi/JsonObject;", "getRootObj", "()Lcom/intellij/json/psi/JsonObject;", "objects", "", "collectObjects", "findRootObject", "hasUnsortedObjects", "", "sort", "", "isSorted", "obj", "cycleSortProperties", "advance", "", "properties", "", "Lcom/intellij/json/psi/JsonProperty;", "size", "cycleStart", "item", "exchange", "", "pos", "intellij.json"})
    @SourceDebugExtension(value={"SMAP\nJsonSortPropertiesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSortPropertiesIntention.kt\ncom/intellij/json/intentions/JsonSortPropertiesIntention$Session\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,156:1\n808#2,11:157\n1755#2,3:168\n1863#2,2:171\n1228#3,2:173\n*S KotlinDebug\n*F\n+ 1 JsonSortPropertiesIntention.kt\ncom/intellij/json/intentions/JsonSortPropertiesIntention$Session\n*L\n86#1:157,11\n98#1:168,3\n101#1:171,2\n112#1:173,2\n*E\n"})
    private static final class Session {
        @NotNull
        private final PsiElement contextElement;
        @NotNull
        private final SelectionModel selectionModel;
        @Nullable
        private final JsonObject rootObj;
        @NotNull
        private final Set<JsonObject> objects;

        public Session(@NotNull Editor editor, @NotNull PsiElement contextElement) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
            this.contextElement = contextElement;
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
            this.selectionModel = selectionModel;
            this.rootObj = this.findRootObject();
            this.objects = this.rootObj != null ? this.collectObjects(this.rootObj) : SetsKt.emptySet();
        }

        @Nullable
        public final JsonObject getRootObj() {
            return this.rootObj;
        }

        private final Set<JsonObject> collectObjects(JsonObject rootObj) {
            Set result = new LinkedHashSet();
            if (this.selectionModel.hasSelection()) {
                new JsonRecursiveElementVisitor(this, result){
                    final /* synthetic */ Session this$0;
                    final /* synthetic */ Set<JsonObject> $result;
                    {
                        this.this$0 = $receiver;
                        this.$result = $result;
                    }

                    public void visitObject(JsonObject o) {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        super.visitObject(o);
                        TextRange textRange = o.getTextRange();
                        boolean bl = textRange != null ? textRange.intersects(Session.access$getSelectionModel$p(this.this$0).getSelectionStart(), Session.access$getSelectionModel$p(this.this$0).getSelectionEnd()) : false;
                        if (bl) {
                            this.$result.add(o);
                        }
                    }
                }.visitObject(rootObj);
            }
            result.add(rootObj);
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private final JsonObject findRootObject() {
            JsonObject initObj;
            JsonObject jsonObject = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)this.contextElement, JsonObject.class);
            if (jsonObject == null) {
                Session $this$findRootObject_u24lambda_u240 = this;
                boolean bl = false;
                PsiFile psiFile = $this$findRootObject_u24lambda_u240.contextElement.getContainingFile();
                JsonFile jsonFile = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
                if (jsonFile == null) {
                    jsonObject = null;
                } else {
                    void $this$filterIsInstanceTo$iv$iv;
                    JsonFile jsonFile2 = jsonFile;
                    List list = jsonFile2.getAllTopLevelValues();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllTopLevelValues(...)");
                    Iterable $this$filterIsInstance$iv = list;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JsonObject)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (JsonObject)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                }
            }
            if ((initObj = jsonObject) == null || !this.selectionModel.hasSelection()) {
                return initObj;
            }
            JsonObject obj = initObj;
            while (true) {
                TextRange textRange = obj.getTextRange();
                boolean bl = textRange != null ? !textRange.containsRange(this.selectionModel.getSelectionStart(), this.selectionModel.getSelectionEnd()) : false;
                if (!bl || (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)obj), JsonObject.class) == null) break;
            }
            return obj;
        }

        public final boolean hasUnsortedObjects() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.objects;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JsonObject it = (JsonObject)element$iv;
                        boolean bl2 = false;
                        if (!(!this.isSorted(it))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final void sort() {
            Iterable $this$forEach$iv = this.objects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject it = (JsonObject)element$iv;
                boolean bl = false;
                if (this.isSorted(it)) continue;
                this.cycleSortProperties(it);
            }
        }

        private final boolean isSorted(JsonObject obj) {
            boolean bl;
            block1: {
                List list = obj.getPropertyList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyList(...)");
                Sequence $this$all$iv = SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), Session::isSorted$lambda$3));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    Object object = pair.component1();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
                    String l = (String)object;
                    Object object2 = pair.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component2(...)");
                    String r = (String)object2;
                    if (l.compareTo(r) <= 0) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        private final void cycleSortProperties(JsonObject obj) {
            List list = obj.getPropertyList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyList(...)");
            List properties = list;
            int size = properties.size();
            for (int cycleStart = 0; cycleStart < size; ++cycleStart) {
                JsonProperty item = (JsonProperty)properties.get(cycleStart);
                int pos = this.advance(properties, size, cycleStart, item);
                if (pos == -1) continue;
                if (pos != cycleStart) {
                    this.exchange(properties, pos, cycleStart);
                }
                while (pos != cycleStart && (pos = this.advance(properties, size, cycleStart, (JsonProperty)properties.get(cycleStart))) != -1) {
                    if (pos == cycleStart) continue;
                    this.exchange(properties, pos, cycleStart);
                }
            }
        }

        private final int advance(List<? extends JsonProperty> properties, int size, int cycleStart, JsonProperty item) {
            int pos = cycleStart;
            String string = item.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String itemName = string;
            for (int i = cycleStart + 1; i < size; ++i) {
                if (properties.get(i).getName().compareTo(itemName) >= 0) continue;
                ++pos;
            }
            if (pos == cycleStart) {
                return -1;
            }
            while (Intrinsics.areEqual((Object)itemName, (Object)properties.get(pos).getName())) {
                ++pos;
            }
            return pos;
        }

        private final void exchange(List<JsonProperty> properties, int pos, int item) {
            JsonProperty propertyAtPos = properties.get(pos);
            JsonProperty itemProperty = properties.get(item);
            PsiElement psiElement = propertyAtPos.getParent().addBefore((PsiElement)itemProperty, (PsiElement)propertyAtPos);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
            properties.set(pos, (JsonProperty)psiElement);
            PsiElement psiElement2 = itemProperty.getParent().addBefore((PsiElement)propertyAtPos, (PsiElement)itemProperty);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
            properties.set(item, (JsonProperty)psiElement2);
            propertyAtPos.delete();
            itemProperty.delete();
        }

        private static final String isSorted$lambda$3(JsonProperty it) {
            return it.getName();
        }

        public static final /* synthetic */ SelectionModel access$getSelectionModel$p(Session $this) {
            return $this.selectionModel;
        }
    }
}

