/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.Compatibility;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;

class CompatibilityHelper6
implements Compatibility {
    private static final long compressedKlassOffset;
    private static final long klassOffset;

    CompatibilityHelper6() {
    }

    @Override
    public Address getAddress(Method method) {
        return method.getHandle();
    }

    @Override
    public Address getAddress(Klass klass) {
        return klass.getHandle();
    }

    @Override
    public Klass asKlass(Oop ref) {
        return OopUtilities.classOopToKlass((Oop)ref);
    }

    @Override
    public List<InstanceKlass> getTransitiveInterfaces(InstanceKlass saKlass) {
        ArrayList<InstanceKlass> res = new ArrayList<InstanceKlass>();
        ObjArray interfaces = saKlass.getTransitiveInterfaces();
        long n = interfaces.getLength();
        int i = 0;
        while ((long)i < n) {
            res.add((InstanceKlass)interfaces.getObjAt((long)i));
            ++i;
        }
        return res;
    }

    @Override
    public String getSourceDebugExtension(InstanceKlass saKlass) {
        return saKlass.getSourceDebugExtension().asString();
    }

    @Override
    public InstanceKlass getMethodHandleKlass() {
        return null;
    }

    @Override
    public Klass getMethodHolder(Method method) {
        return method.getMethodHolder();
    }

    @Override
    public Address getKlassAddress(Oop oop) {
        if (VM.getVM().isCompressedOopsEnabled()) {
            return oop.getHandle().getCompOopHandleAt(compressedKlassOffset);
        }
        return oop.getHandle().getOopHandleAt(klassOffset);
    }

    @Override
    public List<Klass> allClasses(SystemDictionary systemDictionary, VM vm) {
        final ArrayList<Klass> saKlasses = new ArrayList<Klass>();
        systemDictionary.allClassesDo(new SystemDictionary.ClassVisitor(){

            public void visit(Klass k) {
                if (k instanceof ArrayKlass) {
                    saKlasses.add(k);
                } else {
                    int status = k.getClassStatus();
                    if ((status & 2) != 0) {
                        saKlasses.add(k);
                    }
                }
            }
        });
        return saKlasses;
    }

    @Override
    public List<ReferenceTypeImpl> visibleClasses(final Oop ref, final VirtualMachineImpl vm) {
        final ArrayList<ReferenceTypeImpl> res = new ArrayList<ReferenceTypeImpl>();
        SystemDictionary sysDict = vm.saSystemDictionary();
        sysDict.classesDo(new SystemDictionary.ClassAndLoaderVisitor(){

            public void visit(Klass k, Oop loader) {
                if (ref.equals((Object)loader)) {
                    for (Klass l = k; l != null; l = l.arrayKlassOrNull()) {
                        res.add(vm.referenceType(l));
                    }
                }
            }
        });
        sysDict.primArrayClassesDo(new SystemDictionary.ClassAndLoaderVisitor(){

            public void visit(Klass k, Oop loader) {
                if (ref.equals((Object)loader)) {
                    res.add(vm.referenceType(k));
                }
            }
        });
        vm.saUniverse().basicTypeClassesDo(new SystemDictionary.ClassVisitor(){

            public void visit(Klass k) {
                res.add(vm.referenceType(k));
            }
        });
        return res;
    }

    @Override
    public List<JavaThread> getThreads(VM vm) {
        ArrayList<JavaThread> res = new ArrayList<JavaThread>();
        for (JavaThread thread = vm.getThreads().first(); thread != null; thread = thread.next()) {
            res.add(thread);
        }
        return res;
    }

    static {
        long coff = -1L;
        long koff = -1L;
        try {
            Field field = Oop.class.getDeclaredField("klass");
            field.setAccessible(true);
            coff = ((sun.jvm.hotspot.oops.Field)field.get(null)).getOffset();
            Field field1 = Oop.class.getDeclaredField("compressedKlass");
            field1.setAccessible(true);
            koff = ((sun.jvm.hotspot.oops.Field)field1.get(null)).getOffset();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        compressedKlassOffset = coff;
        klassOffset = koff;
    }
}

