/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.VersionUpdatedException;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.model.RepositoryKind;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.IndexedMavenId;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.statistics.MavenIndexUsageCollector;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public final class MavenIndexImpl
implements MavenIndex,
MavenSearchIndex {
    private static final String DATA_DIR_PREFIX = "data";
    private static final String ARTIFACT_IDS_MAP_FILE = "artifactIds-map.dat";
    private static final String VERSIONS_MAP_FILE = "versions-map.dat";
    private static final String ARCHETYPES_MAP_FILE = "archetypes-map.dat";
    private final MavenIndexerWrapper myNexusIndexer;
    private final File myDir;
    @Deprecated(forRemoval=true)
    private final Set<String> myRegisteredRepositoryIds;
    private final String myRepositoryPathOrUrl;
    private final RepositoryKind myKind;
    private final AtomicBoolean myDataClosed = new AtomicBoolean(false);
    private final Lock indexUpdateLock = new ReentrantLock();
    private volatile Long myUpdateTimestamp;
    private volatile IndexData myData;
    private volatile String myFailureMessage;
    private volatile boolean isBroken;
    private volatile boolean isClose;
    private String myDataDirName;

    public MavenIndexImpl(MavenIndexerWrapper indexer, MavenIndexUtils.IndexPropertyHolder propertyHolder) throws MavenIndexException {
        this.myNexusIndexer = indexer;
        this.myDir = propertyHolder.dir;
        this.myKind = propertyHolder.kind;
        this.myRegisteredRepositoryIds = propertyHolder.repositoryIds;
        this.myRepositoryPathOrUrl = propertyHolder.repositoryPathOrUrl;
        this.myUpdateTimestamp = propertyHolder.updateTimestamp;
        this.myDataDirName = propertyHolder.dataDirName;
        this.myFailureMessage = propertyHolder.failureMessage;
        this.open();
    }

    public String getDataDirName() {
        return this.myDataDirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws MavenIndexException {
        Boolean bl;
        boolean isCentral;
        try {
            try {
                this.doOpen();
            }
            catch (Exception e) {
                boolean versionUpdated;
                if (e instanceof ProcessCanceledException) {
                    MavenLog.LOG.error("PCE should not be thrown", new Attachment[]{new Attachment("pce", (Throwable)e)});
                }
                if (!(versionUpdated = e.getCause() instanceof VersionUpdatedException)) {
                    MavenLog.LOG.warn((Throwable)e);
                }
                try {
                    this.doOpen();
                }
                catch (Exception e2) {
                    throw new MavenIndexException("Cannot open index " + this.myDir.getPath(), e2);
                }
                this.markAsBroken();
            }
            isCentral = this.isForCentral();
            bl = this.myKind == RepositoryKind.LOCAL;
        }
        catch (Throwable throwable) {
            boolean isCentral2 = this.isForCentral();
            MavenIndexUsageCollector.INDEX_OPENED.log((Object)(this.myKind == RepositoryKind.LOCAL ? 1 : 0), (Object)isCentral2, (Object)(this.myKind == RepositoryKind.REMOTE && !isCentral2 ? 1 : 0));
            this.save();
            throw throwable;
        }
        MavenIndexUsageCollector.INDEX_OPENED.log((Object)bl, (Object)isCentral, (Object)(this.myKind == RepositoryKind.REMOTE && !isCentral ? 1 : 0));
        this.save();
    }

    private void doOpen() throws Exception {
        MavenLog.LOG.debug("open index " + this);
        ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            MavenIndexImpl mavenIndexImpl = this;
            synchronized (mavenIndexImpl) {
                File dataDir;
                if (this.myDataDirName == null) {
                    dataDir = this.createNewDataDir();
                    this.myDataDirName = dataDir.getName();
                } else {
                    dataDir = new File(this.myDir, this.myDataDirName);
                    dataDir.mkdirs();
                }
                if (this.myData != null) {
                    this.myData.close(true);
                }
                if (this.isClose) {
                    return null;
                }
                this.myData = new IndexData(dataDir);
                return null;
            }
        });
    }

    private void cleanupBrokenData() {
        this.close(true);
        File currentDataDir = this.getCurrentDataDir();
        File currentDataContextDir = this.getCurrentDataContextDir();
        File[] files2 = currentDataDir.listFiles();
        if (files2 != null) {
            for (File file : files2) {
                if (FileUtil.filesEqual((File)file, (File)currentDataContextDir)) continue;
                FileUtil.delete((File)file);
            }
        } else {
            FileUtil.delete((File)currentDataDir);
        }
    }

    public synchronized void finalClose(boolean releaseIndexContext) {
        this.isClose = true;
        this.close(releaseIndexContext);
    }

    @Override
    public void close(boolean releaseIndexContext) {
        IndexData data = this.myData;
        try {
            if (data != null) {
                data.close(releaseIndexContext);
            }
        }
        catch (MavenIndexException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        this.myData = null;
    }

    private synchronized void save() {
    }

    @Override
    public String getRepositoryId() {
        return StringUtil.join(this.myRegisteredRepositoryIds, (String)",");
    }

    @Override
    public File getRepositoryFile() {
        return this.myKind == RepositoryKind.LOCAL ? new File(this.myRepositoryPathOrUrl) : null;
    }

    @Override
    public String getRepositoryUrl() {
        return this.myKind == RepositoryKind.REMOTE ? this.myRepositoryPathOrUrl : null;
    }

    @Override
    public String getRepositoryPathOrUrl() {
        return this.myRepositoryPathOrUrl;
    }

    @Override
    @NotNull
    public MavenRepositoryInfo getRepository() {
        return new MavenRepositoryInfo(this.getRepositoryId(), this.getRepositoryId(), this.myRepositoryPathOrUrl, this.myKind);
    }

    public long getUpdateTimestamp() {
        return this.myUpdateTimestamp == null ? -1L : this.myUpdateTimestamp;
    }

    @Override
    public String getFailureMessage() {
        return this.myFailureMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOrRepair(boolean fullUpdate, MavenProgressIndicator progress, boolean explicit) throws MavenProcessCanceledException {
        StructuredIdeActivity activity = MavenIndexUsageCollector.INDEX_UPDATE.started(null);
        boolean isSuccess = false;
        try {
            this.indexUpdateLock.lock();
            MavenLog.LOG.debug("start update index " + this);
            File newDataDir = this.createNewDataDir();
            File newDataContextDir = MavenIndexImpl.getDataContextDir(newDataDir);
            File currentDataContextDir = this.getCurrentDataContextDir();
            boolean reuseExistingContext = fullUpdate ? this.myKind != RepositoryKind.LOCAL && this.hasValidContext(currentDataContextDir) : this.hasValidContext(currentDataContextDir);
            boolean bl = fullUpdate = fullUpdate || !reuseExistingContext && this.myKind == RepositoryKind.LOCAL;
            if (reuseExistingContext) {
                try {
                    FileUtil.copyDir((File)currentDataContextDir, (File)newDataContextDir);
                }
                catch (IOException e) {
                    throw new MavenIndexException(e);
                }
            }
            if (fullUpdate) {
                MavenIndexId mavenIndexId = this.getMavenIndexId(newDataContextDir, "update");
                try {
                    this.updateNexusContext(mavenIndexId, progress, explicit);
                }
                finally {
                    this.myNexusIndexer.releaseIndex(mavenIndexId);
                }
            }
            this.updateIndexData(progress, newDataDir, fullUpdate);
            this.isBroken = false;
            this.myFailureMessage = null;
            MavenLog.LOG.debug("finish update index " + this);
            isSuccess = true;
        }
        catch (MavenProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleUpdateException(e);
        }
        finally {
            boolean isCentral = this.isForCentral();
            boolean finalIsSuccess = isSuccess;
            activity.finished(() -> Arrays.asList(MavenIndexUsageCollector.IS_LOCAL.with((Object)(this.myKind == RepositoryKind.LOCAL ? 1 : 0)), MavenIndexUsageCollector.IS_CENTRAL.with((Object)(this.myKind == RepositoryKind.REMOTE && isCentral ? 1 : 0)), MavenIndexUsageCollector.IS_PRIVATE_REMOTE.with((Object)(this.myKind == RepositoryKind.REMOTE && !isCentral ? 1 : 0)), MavenIndexUsageCollector.IS_SUCCESS.with((Object)finalIsSuccess), MavenIndexUsageCollector.MANUAL.with((Object)explicit)));
            this.indexUpdateLock.unlock();
        }
        this.save();
    }

    private boolean isForCentral() {
        return this.myRepositoryPathOrUrl != null && this.myRepositoryPathOrUrl.contains("repo.maven.apache.org");
    }

    private boolean hasValidContext(@NotNull File contextDir) {
        if (contextDir == null) {
            MavenIndexImpl.$$$reportNull$$$0(0);
        }
        return contextDir.isDirectory() && this.myNexusIndexer.indexExists(contextDir);
    }

    private void handleUpdateException(Exception e) {
        String failureMessage = e.getMessage();
        if (failureMessage != null && failureMessage.contains("nexus-maven-repository-index.properties") && failureMessage.contains("FileNotFoundException")) {
            failureMessage = "Repository is non-nexus repo, or is not indexed";
            MavenLog.LOG.debug("Failed to update Maven indices for: " + this.myRegisteredRepositoryIds + " " + this.myRepositoryPathOrUrl, (Throwable)e);
        } else {
            MavenLog.LOG.warn("Failed to update Maven indices for: " + this.myRegisteredRepositoryIds + " " + this.myRepositoryPathOrUrl, (Throwable)e);
        }
        this.myFailureMessage = failureMessage;
    }

    private MavenIndexId getMavenIndexId(File contextDir, String suffix) throws MavenServerIndexerException {
        String indexId = this.myDir.getName() + "-" + suffix;
        File repositoryFile = this.getRepositoryFile();
        return new MavenIndexId(indexId, this.getRepositoryId(), repositoryFile == null ? null : repositoryFile.getAbsolutePath(), this.getRepositoryUrl(), contextDir.getAbsolutePath());
    }

    private void updateNexusContext(@NotNull MavenIndexId indexId, @NotNull MavenProgressIndicator progress, boolean multithreaded) throws MavenServerIndexerException, MavenProcessCanceledException {
        if (indexId == null) {
            MavenIndexImpl.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            MavenIndexImpl.$$$reportNull$$$0(2);
        }
        this.myNexusIndexer.updateIndex(indexId, progress, multithreaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexData(MavenProgressIndicator progress, File newDataDir, boolean fullUpdate) throws MavenIndexException {
        IndexData newData = new IndexData(newDataDir);
        try {
            this.doUpdateIndexData(newData, progress);
            newData.flush();
        }
        catch (Throwable e) {
            newData.close(true);
            FileUtil.delete((File)newDataDir);
            if (e instanceof MavenServerIndexerException) {
                throw new MavenIndexException(e);
            }
            if (e instanceof IOException) {
                throw new MavenIndexException(e);
            }
            throw new RuntimeException(e);
        }
        MavenIndexImpl mavenIndexImpl = this;
        synchronized (mavenIndexImpl) {
            if (this.isClose) {
                newData.close(false);
                return;
            }
            if (this.myData != null) {
                this.myData.close(true);
            }
            this.myData = newData;
            this.myDataDirName = newDataDir.getName();
            if (fullUpdate) {
                this.myUpdateTimestamp = System.currentTimeMillis();
            }
            for (File each : FileUtil.notNullize((File[])this.myDir.listFiles())) {
                if (!each.getName().startsWith(DATA_DIR_PREFIX) || each.getName().equals(this.myDataDirName)) continue;
                FileUtil.delete((File)each);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateIndexData(IndexData data, MavenProgressIndicator progress) throws IOException, MavenServerIndexerException {
        HashMap groupToArtifactMap = new HashMap();
        HashMap groupWithArtifactToVersionMap = new HashMap();
        HashMap archetypeIdToDescriptionMap = new HashMap();
        progress.pushState();
        progress.setIndeterminate(true);
        try {
            StringBuilder builder2 = new StringBuilder();
            MavenIndicesProcessor mavenIndicesProcessor = artifacts -> {
                for (IndexedMavenId id : artifacts) {
                    if ("pom.lastUpdated".equals(id.packaging)) continue;
                    builder2.setLength(0);
                    builder2.append(id.groupId).append(":").append(id.artifactId);
                    String ga = builder2.toString();
                    MavenIndexImpl.getOrCreate(groupToArtifactMap, id.groupId).add(id.artifactId);
                    MavenIndexImpl.getOrCreate(groupWithArtifactToVersionMap, ga).add(id.version);
                    if (!"maven-archetype".equals(id.packaging)) continue;
                    builder2.setLength(0);
                    builder2.append(id.version).append(":").append(StringUtil.notNullize((String)id.description));
                    MavenIndexImpl.getOrCreate(archetypeIdToDescriptionMap, ga).add(builder2.toString());
                }
            };
            this.myNexusIndexer.processArtifacts(data.mavenIndexId, mavenIndicesProcessor, progress);
            MavenIndexImpl.persist(groupToArtifactMap, data.groupToArtifactMap);
            MavenIndexImpl.persist(groupWithArtifactToVersionMap, data.groupWithArtifactToVersionMap);
            MavenIndexImpl.persist(archetypeIdToDescriptionMap, data.archetypeIdToDescriptionMap);
        }
        finally {
            progress.popState();
        }
    }

    private static void closeAndClean(PersistentHashMap<String, Set<String>> map) {
        try {
            map.closeAndClean();
        }
        catch (IOException e) {
            MavenLog.LOG.error((Throwable)e);
        }
    }

    public void closeAndClean() {
        if (this.myDataClosed.compareAndSet(false, true)) {
            MavenIndexImpl.closeAndClean(this.myData.groupToArtifactMap);
            MavenIndexImpl.closeAndClean(this.myData.groupWithArtifactToVersionMap);
            MavenIndexImpl.closeAndClean(this.myData.archetypeIdToDescriptionMap);
            this.close(false);
        }
    }

    public File getDir() {
        return this.myDir;
    }

    @TestOnly
    private synchronized File getCurrentDataDir() {
        return new File(this.myDir, this.myDataDirName);
    }

    private File getCurrentDataContextDir() {
        return new File(this.getCurrentDataDir(), "context");
    }

    @NotNull
    private File createNewDataDir() {
        File file = MavenIndices.createNewDir(this.myDir, DATA_DIR_PREFIX, 100);
        if (file == null) {
            MavenIndexImpl.$$$reportNull$$$0(3);
        }
        return file;
    }

    @Override
    @NotNull
    public List<AddArtifactResponse> tryAddArtifacts(@NotNull Collection<? extends File> artifactFiles) {
        if (artifactFiles == null) {
            MavenIndexImpl.$$$reportNull$$$0(4);
        }
        List failedResponses = ContainerUtil.map(artifactFiles, file -> new AddArtifactResponse(file, null));
        List list = this.doIndexAndRecoveryTask(() -> {
            boolean locked = this.indexUpdateLock.tryLock();
            if (!locked) {
                return failedResponses;
            }
            try {
                IndexData indexData = this.myData;
                if (indexData != null) {
                    List<AddArtifactResponse> addArtifactResponses = indexData.addArtifacts(artifactFiles);
                    for (AddArtifactResponse addArtifactResponse : addArtifactResponses) {
                        IndexedMavenId id = addArtifactResponse.indexedMavenId();
                        if (id == null) continue;
                        String groupWithArtifact = id.groupId + ":" + id.artifactId;
                        MavenIndexImpl.addToCache(indexData.groupToArtifactMap, id.groupId, id.artifactId);
                        MavenIndexImpl.addToCache(indexData.groupWithArtifactToVersionMap, groupWithArtifact, id.version);
                        if (!"maven-archetype".equals(id.packaging)) continue;
                        MavenIndexImpl.addToCache(indexData.archetypeIdToDescriptionMap, groupWithArtifact, id.version + ":" + StringUtil.notNullize((String)id.description));
                    }
                    indexData.flush();
                    List<AddArtifactResponse> list = addArtifactResponses;
                    return list;
                }
                List list = failedResponses;
                return list;
            }
            finally {
                this.indexUpdateLock.unlock();
            }
        }, failedResponses);
        if (list == null) {
            MavenIndexImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public Collection<String> getGroupIds() {
        return this.doIndexTask(() -> this.getGroupIdsRaw(), Collections.emptySet());
    }

    @Override
    public Set<String> getArtifactIds(String groupId) {
        return this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)this.myData.groupToArtifactMap.get((Object)groupId))), Collections.emptySet());
    }

    @TestOnly
    public synchronized void printInfo() {
        this.doIndexTask(() -> {
            MavenLog.LOG.debug("BaseFile: " + this.myData.groupToArtifactMap);
            MavenLog.LOG.debug("All data objects: " + this.getGroupIdsRaw());
            return null;
        }, null);
    }

    @Override
    public Set<String> getVersions(String groupId, String artifactId) {
        String ga = groupId + ":" + artifactId;
        return this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)this.myData.groupWithArtifactToVersionMap.get((Object)ga))), Collections.emptySet());
    }

    @Override
    public boolean hasGroupId(String groupId) {
        if (this.isBroken) {
            return false;
        }
        IndexData indexData = this.myData;
        if (indexData == null) {
            return false;
        }
        return this.doIndexTask(() -> indexData.groupToArtifactMap.containsMapping((Object)groupId), false);
    }

    @Override
    public boolean hasArtifactId(String groupId, String artifactId) {
        if (this.isBroken) {
            return false;
        }
        IndexData indexData = this.myData;
        if (indexData == null) {
            return false;
        }
        String key = groupId + ":" + artifactId;
        return this.doIndexTask(() -> indexData.groupWithArtifactToVersionMap.containsMapping((Object)key), false);
    }

    @Override
    public boolean hasVersion(String groupId, String artifactId, String version) {
        if (this.isBroken) {
            return false;
        }
        IndexData indexData = this.myData;
        if (indexData == null) {
            return false;
        }
        String groupWithArtifactWithVersion = groupId + ":" + artifactId + ":" + version;
        String groupWithArtifact = groupWithArtifactWithVersion.substring(0, groupWithArtifactWithVersion.length() - version.length() - 1);
        return this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)indexData.groupWithArtifactToVersionMap.get((Object)groupWithArtifact))).contains(version), false);
    }

    @Override
    public Set<MavenArtifactInfo> search(String pattern, int maxResult) {
        IndexData indexData = this.myData;
        if (indexData == null) {
            return Collections.emptySet();
        }
        return this.doIndexAndRecoveryTask(() -> indexData.search(pattern, maxResult), Collections.emptySet());
    }

    @Override
    public Set<MavenArchetype> getArchetypes() {
        return this.doIndexAndRecoveryTask(() -> {
            HashSet archetypes = new HashSet();
            IndexData indexData = this.myData;
            if (indexData == null) {
                return Collections.emptySet();
            }
            indexData.archetypeIdToDescriptionMap.consumeKeysWithExistingMapping(ga -> {
                List gaParts = StringUtil.split((String)ga, (String)":");
                String groupId = (String)gaParts.get(0);
                String artifactId = (String)gaParts.get(1);
                try {
                    for (String vd : (Set)indexData.archetypeIdToDescriptionMap.get(ga)) {
                        int index = vd.indexOf(58);
                        if (index == -1) continue;
                        String version = vd.substring(0, index);
                        String description = vd.substring(index + 1);
                        archetypes.add(new MavenArchetype(groupId, artifactId, version, this.myRepositoryPathOrUrl, description));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return archetypes;
        }, Collections.emptySet());
    }

    private <T> T doIndexTask(IndexTask<T> task, T defaultValue) {
        if (!this.isBroken) {
            try {
                return task.doTask();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                MavenLog.LOG.warn((Throwable)e);
                this.markAsBroken();
            }
        }
        return defaultValue;
    }

    private <T> T doIndexAndRecoveryTask(IndexTask<T> task, T defaultValue) {
        if (!this.isBroken) {
            try {
                return task.doTask();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e1) {
                MavenLog.LOG.warn((Throwable)e1);
                this.cleanupBrokenData();
                try {
                    this.open();
                }
                catch (MavenIndexException e2) {
                    MavenLog.LOG.warn((Throwable)e2);
                }
            }
        }
        this.markAsBroken();
        return defaultValue;
    }

    private void markAsBroken() {
        if (this.isClose) {
            return;
        }
        if (!this.isBroken) {
            MavenLog.LOG.info("index is broken " + this);
            MavenIndexUsageCollector.INDEX_BROKEN.log();
            ((MavenSearchIndex.IndexListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(INDEX_IS_BROKEN)).indexIsBroken(this);
        }
        this.isBroken = true;
    }

    @NotNull
    private Collection<String> getGroupIdsRaw() throws IOException {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.myData.groupToArtifactMap.processKeysWithExistingMapping((Processor)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            MavenIndexImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public String toString() {
        return "MavenIndex{myKind=" + this.myKind + "', myRepositoryPathOrUrl='" + this.myRepositoryPathOrUrl + ", ids=" + this.myRegisteredRepositoryIds + "}";
    }

    private static <T> Set<T> getOrCreate(Map<String, Set<T>> map, String key) {
        return map.computeIfAbsent(key, k -> new TreeSet());
    }

    private static <T> void persist(Map<String, T> map, PersistentHashMap<String, T> persistentMap) throws IOException {
        for (Map.Entry<String, T> each : map.entrySet()) {
            persistentMap.put((Object)each.getKey(), each.getValue());
        }
    }

    private static File getDataContextDir(File dataDir) {
        return new File(dataDir, "context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToCache(PersistentHashMap<String, Set<String>> cache, String key, String value) throws IOException {
        if (key == null || value == null || cache == null) {
            return;
        }
        PersistentHashMap<String, Set<String>> persistentHashMap = cache;
        synchronized (persistentHashMap) {
            TreeSet<String> values = (TreeSet<String>)cache.get((Object)key);
            if (values == null) {
                values = new TreeSet<String>();
            }
            if (values.add(value)) {
                cache.put((Object)key, values);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndexImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndexImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDataDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tryAddArtifacts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupIdsRaw";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasValidContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateNexusContext";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryAddArtifacts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    private class IndexData {
        final PersistentHashMap<String, Set<String>> groupToArtifactMap;
        final PersistentHashMap<String, Set<String>> groupWithArtifactToVersionMap;
        final PersistentHashMap<String, Set<String>> archetypeIdToDescriptionMap;
        final MavenIndexId mavenIndexId;

        IndexData(File dir) throws MavenIndexException {
            try {
                this.groupToArtifactMap = IndexData.createPersistentMap(new File(dir, MavenIndexImpl.ARTIFACT_IDS_MAP_FILE));
                this.groupWithArtifactToVersionMap = IndexData.createPersistentMap(new File(dir, MavenIndexImpl.VERSIONS_MAP_FILE));
                this.archetypeIdToDescriptionMap = IndexData.createPersistentMap(new File(dir, MavenIndexImpl.ARCHETYPES_MAP_FILE));
                this.mavenIndexId = MavenIndexImpl.this.getMavenIndexId(MavenIndexImpl.getDataContextDir(dir), dir.getName());
            }
            catch (IOException | MavenServerIndexerException e) {
                this.close(true);
                throw new MavenIndexException(e);
            }
        }

        private static PersistentHashMap<String, Set<String>> createPersistentMap(File f) throws IOException {
            return new PersistentHashMap(f.toPath(), (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new SetDescriptor());
        }

        void close(boolean releaseIndexContext) throws MavenIndexException {
            MavenIndexException[] exceptions;
            block4: {
                exceptions = new MavenIndexException[1];
                try {
                    if (releaseIndexContext) {
                        MavenIndexImpl.this.myNexusIndexer.releaseIndex(this.mavenIndexId);
                    }
                }
                catch (MavenServerIndexerException e) {
                    MavenLog.LOG.warn((Throwable)e);
                    if (exceptions[0] != null) break block4;
                    exceptions[0] = new MavenIndexException(e);
                }
            }
            IndexData.safeClose(this.groupToArtifactMap, exceptions);
            IndexData.safeClose(this.groupWithArtifactToVersionMap, exceptions);
            IndexData.safeClose(this.archetypeIdToDescriptionMap, exceptions);
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        }

        private static void safeClose(@Nullable Closeable enumerator, MavenIndexException[] exceptions) {
            block3: {
                try {
                    if (enumerator != null) {
                        enumerator.close();
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn((Throwable)e);
                    if (exceptions[0] != null) break block3;
                    exceptions[0] = new MavenIndexException(e);
                }
            }
        }

        void flush() {
            this.groupToArtifactMap.force();
            this.groupWithArtifactToVersionMap.force();
            this.archetypeIdToDescriptionMap.force();
        }

        @NotNull
        List<AddArtifactResponse> addArtifacts(Collection<? extends File> artifactFiles) {
            List<AddArtifactResponse> list = MavenIndexImpl.this.myNexusIndexer.addArtifacts(this.mavenIndexId, artifactFiles);
            if (list == null) {
                IndexData.$$$reportNull$$$0(0);
            }
            return list;
        }

        Set<MavenArtifactInfo> search(String pattern, int maxResult) throws MavenServerIndexerException {
            return MavenIndexImpl.this.myNexusIndexer.search(this.mavenIndexId, pattern, maxResult);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/indices/MavenIndexImpl$IndexData", "addArtifacts"));
        }
    }

    @FunctionalInterface
    private static interface IndexTask<T> {
        public T doTask() throws Exception;
    }

    private static class SetDescriptor
    implements DataExternalizer<Set<String>> {
        private SetDescriptor() {
        }

        public void save(@NotNull DataOutput s, Set<String> set) throws IOException {
            if (s == null) {
                SetDescriptor.$$$reportNull$$$0(0);
            }
            s.writeInt(set.size());
            for (String each : set) {
                s.writeUTF(each);
            }
        }

        public Set<String> read(@NotNull DataInput s) throws IOException {
            if (s == null) {
                SetDescriptor.$$$reportNull$$$0(1);
            }
            int count = s.readInt();
            TreeSet<String> result2 = new TreeSet<String>();
            try {
                while (count-- > 0) {
                    result2.add(s.readUTF());
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "s";
            objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndexImpl$SetDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

