/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.psi.PsiElement;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;

public class InstructionImpl
implements Instruction {
    private final Set<Instruction> myPredecessors = new ObjectArraySet(1);
    private final Set<Instruction> mySuccessors = new ObjectArraySet(1);
    private Set<NegatingGotoInstruction> myNegations;
    protected final PsiElement myPsiElement;
    private int myNumber = -1;

    @Override
    @Nullable
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    public InstructionImpl(@Nullable PsiElement element) {
        this.myPsiElement = element;
    }

    @Override
    @NotNull
    public Iterable<Instruction> successors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            InstructionImpl.$$$reportNull$$$0(0);
        }
        Deque<CallInstruction> stack = environment.callStack(this);
        for (Instruction instruction : this.mySuccessors) {
            environment.update(stack, instruction);
        }
        Set<Instruction> set = this.mySuccessors;
        if (set == null) {
            InstructionImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public Iterable<Instruction> predecessors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            InstructionImpl.$$$reportNull$$$0(2);
        }
        Deque<CallInstruction> stack = environment.callStack(this);
        for (Instruction instruction : this.myPredecessors) {
            environment.update(stack, instruction);
        }
        Set<Instruction> set = this.myPredecessors;
        if (set == null) {
            InstructionImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allSuccessors() {
        Set<Instruction> set = this.mySuccessors;
        if (set == null) {
            InstructionImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allPredecessors() {
        Set<Instruction> set = this.myPredecessors;
        if (set == null) {
            InstructionImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NonNls
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myNumber);
        builder.append("(");
        for (Instruction successor : this.mySuccessors) {
            builder.append(successor.num());
            builder.append(',');
        }
        if (!this.mySuccessors.isEmpty()) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append(") ").append(this.getElementPresentation());
        return builder.toString();
    }

    @NotNull
    @NonNls
    protected String getElementPresentation() {
        String string = "element: " + this.myPsiElement;
        if (string == null) {
            InstructionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public int num() {
        assert (this.myNumber != -1);
        return this.myNumber;
    }

    @Override
    @NotNull
    public Iterable<? extends NegatingGotoInstruction> getNegatingGotoInstruction() {
        if (this.myNegations == null) {
            List list = Collections.emptyList();
            if (list == null) {
                InstructionImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        Set<NegatingGotoInstruction> set = this.myNegations;
        if (set == null) {
            InstructionImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    public void addSuccessor(InstructionImpl instruction) {
        this.mySuccessors.add(instruction);
    }

    public void addPredecessor(InstructionImpl instruction) {
        this.myPredecessors.add(instruction);
    }

    void addNegationsFrom(Instruction instruction) {
        if (this.myNegations == null) {
            this.myNegations = new ObjectArraySet(1);
        }
        for (NegatingGotoInstruction negatingGotoInstruction : instruction.getNegatingGotoInstruction()) {
            this.myNegations.add(negatingGotoInstruction);
        }
        if (instruction instanceof NegatingGotoInstruction) {
            this.myNegations.add((NegatingGotoInstruction)instruction);
        }
    }

    final void setNumber(int num) {
        assert (this.myNumber == -1);
        this.myNumber = num;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "successors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "predecessors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allSuccessors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "allPredecessors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNegatingGotoInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "successors";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "predecessors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

