/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RedundantEmptyInitializerBlockInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RemoveInitializerBlockFix", "kotlin.code-insight.inspections.shared"})
public final class RedundantEmptyInitializerBlockInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.classInitializerVisitor(arg_0 -> RedundantEmptyInitializerBlockInspection.buildVisitor$lambda$0(holder, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(ProblemsHolder $holder, KtClassInitializer initializer2) {
        KtExpression ktExpression = initializer2.getBody();
        KtBlockExpression ktBlockExpression = ktExpression instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null;
        if (ktBlockExpression == null) {
            return Unit.INSTANCE;
        }
        KtBlockExpression body2 = ktBlockExpression;
        List list2 = body2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        if (!((Collection)list2).isEmpty()) {
            return Unit.INSTANCE;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveInitializerBlockFix()};
        $holder.registerProblem((PsiElement)initializer2, KotlinBundle.message((String)"redundant.empty.initializer.block", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RedundantEmptyInitializerBlockInspection$RemoveInitializerBlockFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.code-insight.inspections.shared"})
    private static final class RemoveInitializerBlockFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"remove.initializer.block.fix.text", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement = descriptor2.getPsiElement();
                KtClassInitializer ktClassInitializer = psiElement instanceof KtClassInitializer ? (KtClassInitializer)psiElement : null;
                if (ktClassInitializer == null) break block0;
                ktClassInitializer.delete();
            }
        }
    }
}

