/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.util.containers.Stack;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020)H\u0002J$\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u000b2\b\u0010,\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0006H\u0002J\b\u00100\u001a\u00020\u0011H\u0002J\b\u00101\u001a\u00020\u0006H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/ClassNameCalculatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "names", "Lcom/intellij/util/containers/Stack;", "", "anonymousIndices", "", "collectedNames", "Ljava/util/WeakHashMap;", "Lorg/jetbrains/kotlin/psi/KtElement;", "allNames", "", "getAllNames", "()Ljava/util/Map;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitScript", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "visitClassOrObject", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitObjectLiteralExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getTopLevelName", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "push", "element", "name", "recordName", "", "saveName", "pop", "nextAnonymousName", "kotlin.jvm-debugger.base.util"})
final class ClassNameCalculatorVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final Stack<String> names = new Stack();
    @NotNull
    private final Stack<Integer> anonymousIndices = new Stack();
    @NotNull
    private WeakHashMap<KtElement, String> collectedNames = new WeakHashMap();

    @NotNull
    public final Map<KtElement, String> getAllNames() {
        return this.collectedNames;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.saveName((KtElement)file, JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file).getFileClassFqName().asString());
        super.visitKtFile(file);
    }

    public void visitScript(@NotNull KtScript script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ClassNameCalculatorVisitor.push$default(this, (KtElement)script, script.getFqName().asString(), false, 4, null);
        super.visitScript(script);
        this.pop();
    }

    public void visitClassOrObject(@NotNull KtClassOrObject klass) {
        String string;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.getName() == null) {
            super.visitClassOrObject(klass);
            return;
        }
        KtElement ktElement = (KtElement)klass;
        if (klass.isTopLevel()) {
            FqName fqName2 = klass.getFqName();
            string = fqName2 != null ? fqName2.asString() : null;
        } else {
            string = klass.getName();
        }
        ClassNameCalculatorVisitor.push$default(this, ktElement, string, false, 4, null);
        super.visitClassOrObject(klass);
        this.pop();
    }

    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ClassNameCalculatorVisitor.push$default(this, (KtElement)expression, this.nextAnonymousName(), false, 4, null);
        super.visitObjectLiteralExpression(expression);
        this.pop();
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ClassNameCalculatorVisitor.push$default(this, (KtElement)expression, this.nextAnonymousName(), false, 4, null);
        super.visitLambdaExpression(expression);
        this.pop();
    }

    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ClassNameCalculatorVisitor.push$default(this, (KtElement)expression, this.nextAnonymousName(), false, 4, null);
        super.visitCallableReferenceExpression(expression);
        this.pop();
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.push((KtElement)property, property.isTopLevel() ? this.getTopLevelName((KtDeclaration)property) : property.getName(), false);
        if (property.hasDelegate()) {
            this.nextAnonymousName();
        }
        super.visitProperty(property);
        this.pop();
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        boolean isLocal = function.isLocal();
        boolean isFunctionLiteral = isLocal && function.getName() == null;
        String name2 = function.isTopLevel() ? this.getTopLevelName((KtDeclaration)function) : (isFunctionLiteral ? this.nextAnonymousName() : function.getName());
        this.push((KtElement)function, name2, isFunctionLiteral);
        if (function.hasModifier(KtTokens.SUSPEND_KEYWORD) && !isLocal) {
            this.nextAnonymousName();
        }
        super.visitNamedFunction(function);
        this.pop();
    }

    private final String getTopLevelName(KtDeclaration declaration) {
        String string = declaration.getName();
        if (string == null) {
            return null;
        }
        String selfName = string;
        KtFile ktFile2 = declaration.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        JvmFileClassInfo info2 = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)ktFile2);
        return info2.getFacadeClassFqName().asString() + "$" + selfName;
    }

    private final void push(KtElement element, String name2, boolean recordName) {
        this.names.push((Object)name2);
        this.anonymousIndices.push((Object)0);
        if (recordName) {
            this.saveName(element, CollectionsKt.joinToString$default((Iterable)((Iterable)this.names), (CharSequence)"$", null, null, (int)0, null, null, (int)62, null));
        }
    }

    static /* synthetic */ void push$default(ClassNameCalculatorVisitor classNameCalculatorVisitor, KtElement ktElement, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        classNameCalculatorVisitor.push(ktElement, string, bl);
    }

    private final void saveName(KtElement element, String name2) {
        ((Map)this.collectedNames).put(element, name2);
    }

    private final void pop() {
        this.names.pop();
        this.anonymousIndices.pop();
    }

    private final String nextAnonymousName() {
        int index2 = ((Number)this.anonymousIndices.pop()).intValue() + 1;
        this.anonymousIndices.push((Object)index2);
        return String.valueOf(index2);
    }
}

