/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.overrides;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.intellij.usageView.UsageViewLongNameLocation;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.hierarchy.overrides.KotlinOverrideHierarchyProviderKt;
import org.jetbrains.kotlin.idea.hierarchy.overrides.KotlinOverrideTreeStructure;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\f\u0012\u0006\b\u0000\u0012\u00020\r0\u000bH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0017\u0010\u0010\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0014J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0005H\u0014J#\u0010\u001a\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u001d*\b\u0012\u0002\b\u0003\u0018\u00010\u001c0\u001c0\u001b\u00a2\u0006\u0002\b\u001eH\u0014J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0005H\u0014\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/overrides/KotlinOverrideHierarchyBrowser;", "Lcom/intellij/ide/hierarchy/MethodHierarchyBrowserBase;", "project", "Lcom/intellij/openapi/project/Project;", "baseElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;)V", "createTrees", "", "trees", "", "", "Ljavax/swing/JTree;", "createLegendPanel", "Ljavax/swing/JPanel;", "getElementFromDescriptor", "Lorg/jetbrains/annotations/Nullable;", "descriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "isApplicableElement", "", "psiElement", "createHierarchyTreeStructure", "Lcom/intellij/ide/hierarchy/HierarchyTreeStructure;", "typeName", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getContentDisplayName", "element", "kotlin.idea"})
public final class KotlinOverrideHierarchyBrowser
extends MethodHierarchyBrowserBase {
    public KotlinOverrideHierarchyBrowser(@NotNull Project project, @NotNull PsiElement baseElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseElement, (String)"baseElement");
        super(project, baseElement);
    }

    protected void createTrees(@NotNull Map<? super String, ? super JTree> trees) {
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        ActionManager actionManager = ActionManager.getInstance();
        JTree jTree = this.createTree(false);
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"createTree(...)");
        JTree tree2 = jTree;
        PopupHandler.installPopupMenu((JComponent)tree2, (String)"MethodHierarchyPopupMenu", (String)"MethodHierarchyViewPopup");
        new MethodHierarchyBrowserBase.BaseOnThisMethodAction().registerCustomShortcutSet(actionManager.getAction("MethodHierarchy").getShortcutSet(), (JComponent)tree2);
        trees.put(MethodHierarchyBrowserBase.getMethodType(), tree2);
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return MethodHierarchyBrowserBase.createStandardLegendPanel((String)KotlinBundle.message((String)"hierarchy.legend.member.is.defined.in.class", (Object[])new Object[0]), (String)KotlinBundle.message((String)"hierarchy.legend.member.defined.in.superclass", (Object[])new Object[0]), (String)KotlinBundle.message((String)"hierarchy.legend.member.should.be.defined", (Object[])new Object[0]));
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return descriptor2.getPsiElement();
    }

    protected boolean isApplicableElement(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return KotlinOverrideHierarchyProviderKt.isOverrideHierarchyElement(psiElement);
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        HierarchyTreeStructure hierarchyTreeStructure;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (Intrinsics.areEqual((Object)typeName, (Object)MethodHierarchyBrowserBase.getMethodType())) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            hierarchyTreeStructure = new KotlinOverrideTreeStructure(project, (KtCallableDeclaration)psiElement);
        } else {
            hierarchyTreeStructure = null;
        }
        return hierarchyTreeStructure;
    }

    @NotNull
    protected Comparator<NodeDescriptor<?>> getComparator() {
        Comparator comparator = JavaHierarchyUtil.getComparator((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getComparator(...)");
        return comparator;
    }

    @Nullable
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement targetElement = LightClassUtilsKt.getUnwrapped((PsiElement)element);
        if (targetElement instanceof KtDeclaration) {
            return ElementDescriptionUtil.getElementDescription((PsiElement)targetElement, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE));
        }
        return super.getContentDisplayName(typeName, element);
    }
}

