/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0000H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0005*\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "<init>", "()V", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "clone", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "addRainbowHighlight", "target", "rainbowElement", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "isRainbowDeclaration", "Companion", "kotlin.highlighting.shared"})
@SourceDebugExtension(value={"SMAP\nKotlinRainbowVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRainbowVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/KotlinRainbowVisitor\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,107:1\n150#2:108\n150#2:109\n150#2:110\n*S KotlinDebug\n*F\n+ 1 KotlinRainbowVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/KotlinRainbowVisitor\n*L\n94#1:108\n95#1:109\n103#1:110\n*E\n"})
public final class KotlinRainbowVisitor
extends RainbowVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<TargetElementEvaluatorEx2> KOTLIN_TARGET_ELEMENT_EVALUATOR$delegate = LazyKt.lazy(KotlinRainbowVisitor::KOTLIN_TARGET_ELEMENT_EVALUATOR_delegate$lambda$2);

    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof KtFile;
    }

    @NotNull
    public KotlinRainbowVisitor clone() {
        return new KotlinRainbowVisitor();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visit(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement parent = element.getParent();
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)KtTokens.IDENTIFIER)) {
            KtNamedDeclaration ktNamedDeclaration = parent instanceof KtNamedDeclaration ? (KtNamedDeclaration)parent : null;
            if (Intrinsics.areEqual((Object)(ktNamedDeclaration != null ? ktNamedDeclaration.getNameIdentifier() : null), (Object)element) && this.isRainbowDeclaration(parent)) {
                KotlinRainbowVisitor.addRainbowHighlight$default(this, parent, element, null, 4, null);
                return;
            }
        }
        if (element instanceof KtSimpleNameExpression) {
            boolean bl;
            Class[] classArray = new Class[]{KtLambdaExpression.class, KtValueArgumentList.class};
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, KtQualifiedExpression.class, (boolean)true, (Class[])classArray);
            KtQualifiedExpression ktQualifiedExpression = qualifiedExpression;
            if (ktQualifiedExpression != null && (ktQualifiedExpression = ktQualifiedExpression.getSelectorExpression()) != null) {
                if (PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)ktQualifiedExpression), (PsiElement)element, (boolean)false, (int)2, null)) {
                    return;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            KtSimpleNameReference reference2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)element));
            PsiElement targetElement = reference2.resolve();
            if (targetElement != null) {
                if (!this.isRainbowDeclaration(targetElement)) return;
                KotlinRainbowVisitor.addRainbowHighlight$default(this, targetElement, element, null, 4, null);
                return;
            }
            if (!Intrinsics.areEqual((Object)((KtSimpleNameExpression)element).getReferencedNameAsName(), (Object)StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME)) return;
            PsiElement itTargetElement = Companion.getKOTLIN_TARGET_ELEMENT_EVALUATOR().getElementByReference((PsiReference)reference2, 1);
            if (itTargetElement == null) return;
            KotlinRainbowVisitor.addRainbowHighlight$default(this, itTargetElement, element, null, 4, null);
            return;
        }
        if (!(element instanceof KDocName)) return;
        PsiReference psiReference = ((KDocName)element).getReference();
        PsiReference psiReference2 = psiReference;
        if (psiReference == null) return;
        if ((psiReference2 = psiReference2.resolve()) == null) {
            return;
        }
        PsiReference target = psiReference2;
        if (!this.isRainbowDeclaration((PsiElement)target)) return;
        this.addRainbowHighlight((PsiElement)target, element, KotlinHighlightingColors.KDOC_LINK);
    }

    private final void addRainbowHighlight(PsiElement target, PsiElement rainbowElement, TextAttributesKey attributesKey) {
        KtDeclaration ktDeclaration;
        TextAttributesKey attributesKeyToUse;
        Iterator lambdaSequenceIterator = SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)target), KotlinRainbowVisitor::addRainbowHighlight$lambda$0), KotlinRainbowVisitor::addRainbowHighlight$lambda$1).iterator();
        TextAttributesKey textAttributesKey = attributesKey;
        if (textAttributesKey == null) {
            textAttributesKey = attributesKeyToUse = target instanceof KtParameter ? KotlinHighlightingColors.PARAMETER : KotlinHighlightingColors.LOCAL_VARIABLE;
        }
        if (lambdaSequenceIterator.hasNext()) {
            PsiElement lambda2 = (PsiElement)lambdaSequenceIterator.next();
            int lambdaNestingLevel = 0;
            while (lambdaSequenceIterator.hasNext()) {
                ++lambdaNestingLevel;
                lambda2 = (PsiElement)lambdaSequenceIterator.next();
            }
            this.addInfo(this.getInfo(lambda2, rainbowElement, lambdaNestingLevel + rainbowElement.getText(), attributesKeyToUse));
            return;
        }
        PsiElement $this$getStrictParentOfType$iv = target;
        boolean $i$f$getStrictParentOfType = false;
        KtDeclarationWithBody ktDeclarationWithBody = (KtDeclarationWithBody)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDeclarationWithBody.class, (boolean)true);
        if (ktDeclarationWithBody != null) {
            ktDeclaration = (KtDeclaration)ktDeclarationWithBody;
        } else {
            PsiElement $this$getStrictParentOfType$iv2 = target;
            boolean $i$f$getStrictParentOfType2 = false;
            KtAnonymousInitializer ktAnonymousInitializer = (KtAnonymousInitializer)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtAnonymousInitializer.class, (boolean)true);
            if (ktAnonymousInitializer != null) {
                ktDeclaration = (KtDeclaration)ktAnonymousInitializer;
            } else {
                return;
            }
        }
        KtDeclaration context2 = ktDeclaration;
        this.addInfo(this.getInfo((PsiElement)context2, rainbowElement, rainbowElement.getText(), attributesKeyToUse));
    }

    static /* synthetic */ void addRainbowHighlight$default(KotlinRainbowVisitor kotlinRainbowVisitor, PsiElement psiElement, PsiElement psiElement2, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 4) != 0) {
            textAttributesKey = null;
        }
        kotlinRainbowVisitor.addRainbowHighlight(psiElement, psiElement2, textAttributesKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRainbowDeclaration(PsiElement $this$isRainbowDeclaration) {
        if ($this$isRainbowDeclaration instanceof KtProperty) {
            if (((KtProperty)$this$isRainbowDeclaration).isLocal()) return true;
        }
        if ($this$isRainbowDeclaration instanceof KtParameter) {
            PsiElement $this$getStrictParentOfType$iv = $this$isRainbowDeclaration;
            boolean $i$f$getStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtPrimaryConstructor.class, (boolean)true) == null) return true;
        }
        if ($this$isRainbowDeclaration instanceof KtDestructuringDeclarationEntry) return true;
        if (!($this$isRainbowDeclaration instanceof KtFunctionLiteral)) return false;
        return true;
    }

    private static final boolean addRainbowHighlight$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof KtDeclaration) || it instanceof KtNamedFunction && ((KtNamedFunction)it).getNameIdentifier() == null || it instanceof KtFunctionLiteral;
    }

    private static final boolean addRainbowHighlight$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtLambdaExpression || it instanceof KtNamedFunction && ((KtNamedFunction)it).getNameIdentifier() == null;
    }

    private static final TargetElementEvaluatorEx2 KOTLIN_TARGET_ELEMENT_EVALUATOR_delegate$lambda$2() {
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = TargetElementUtilBase.getElementEvaluatorsEx2((Language)((Language)KotlinLanguage.INSTANCE));
        if (targetElementEvaluatorEx2 == null) {
            throw new IllegalStateException("no TargetElementEvaluatorEx2".toString());
        }
        return targetElementEvaluatorEx2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRainbowVisitor$Companion;", "", "<init>", "()V", "KOTLIN_TARGET_ELEMENT_EVALUATOR", "Lcom/intellij/codeInsight/TargetElementEvaluatorEx2;", "getKOTLIN_TARGET_ELEMENT_EVALUATOR", "()Lcom/intellij/codeInsight/TargetElementEvaluatorEx2;", "KOTLIN_TARGET_ELEMENT_EVALUATOR$delegate", "Lkotlin/Lazy;", "kotlin.highlighting.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TargetElementEvaluatorEx2 getKOTLIN_TARGET_ELEMENT_EVALUATOR() {
            Lazy lazy = KOTLIN_TARGET_ELEMENT_EVALUATOR$delegate;
            return (TargetElementEvaluatorEx2)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

