/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions.multiDollarStrings;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.PrefixedStringTemplateUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\t\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0001H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0012\u001a\u00020\f*\u00020\u0013H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\f*\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DEFAULT_INTERPOLATION_PREFIX_LENGTH", "", "INTERPOLATION_PREFIX_LENGTH_THRESHOLD", "DOLLAR", "", "convertToMultiDollarString", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "element", "simplifyDollarEntries", "longestUnsafeDollarSequenceLength", "threshold", "isSimplifiableInterpolatedDollar", "", "Lorg/jetbrains/kotlin/psi/KtBlockStringTemplateEntry;", "replaceExpressionEntries", "", "stringTemplate", "prefixLength", "isEscapedDollar", "Lorg/jetbrains/kotlin/psi/KtEscapeStringTemplateEntry;", "isSafeToReplaceWithDollar", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "kotlin.code-insight.intentions.k2"})
@SourceDebugExtension(value={"SMAP\nmultiDollarStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 multiDollarStringUtils.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/multiDollarStrings/MultiDollarStringUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,149:1\n1#2:150\n621#3,6:151\n1069#3,2:157\n621#3,6:159\n621#3,6:165\n*S KotlinDebug\n*F\n+ 1 multiDollarStringUtils.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/multiDollarStrings/MultiDollarStringUtilsKt\n*L\n104#1:151,6\n107#1:157,2\n112#1:159,6\n146#1:165,6\n*E\n"})
public final class MultiDollarStringUtilsKt {
    private static final int DEFAULT_INTERPOLATION_PREFIX_LENGTH = 2;
    private static final int INTERPOLATION_PREFIX_LENGTH_THRESHOLD = 5;
    @NotNull
    private static final String DOLLAR = "$";

    @NotNull
    public static final KtStringTemplateExpression convertToMultiDollarString(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element.getInterpolationPrefix() == null)) {
            boolean $i$a$-require-MultiDollarStringUtilsKt$convertToMultiDollarString$22 = false;
            String $i$a$-require-MultiDollarStringUtilsKt$convertToMultiDollarString$22 = "Can't convert the string which already has a prefix to multi-dollar string";
            throw new IllegalArgumentException($i$a$-require-MultiDollarStringUtilsKt$convertToMultiDollarString$22.toString());
        }
        int longestUnsafeDollarSequence = MultiDollarStringUtilsKt.longestUnsafeDollarSequenceLength(element, 5);
        int prefixLength = (2 <= longestUnsafeDollarSequence ? longestUnsafeDollarSequence < 5 : false) ? longestUnsafeDollarSequence + 1 : 2;
        MultiDollarStringUtilsKt.replaceExpressionEntries(element, prefixLength);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement psiElement = element.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createMultiDollarStringTemplate(KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)element), prefixLength, !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element)));
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        KtStringTemplateExpression replaced = (KtStringTemplateExpression)psiElement;
        return replaced;
    }

    @NotNull
    public static final KtStringTemplateExpression simplifyDollarEntries(@NotNull KtStringTemplateExpression element) {
        Object object;
        KtPsiFactory ktPsiFactory;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ktPsiFactory = new KtPsiFactory(project, false, 2, null);
                object = element.getInterpolationPrefix();
                if (object == null) break block5;
                Integer n = object.getTextLength();
                int it = ((Number)n).intValue();
                boolean bl = false;
                object = it > 1 ? n : null;
                if (object != null) break block6;
            }
            return element;
        }
        int prefixLength = (Integer)object;
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])element.getEntries());
        while (iterator2.hasNext()) {
            KtStringTemplateEntry entry = (KtStringTemplateEntry)iterator2.next();
            KtStringTemplateEntry ktStringTemplateEntry = entry;
            if (ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry) {
                if (!MultiDollarStringUtilsKt.isEscapedDollar((KtEscapeStringTemplateEntry)entry) || !MultiDollarStringUtilsKt.isSafeToReplaceWithDollar(entry, prefixLength)) continue;
                ((KtEscapeStringTemplateEntry)entry).replace((PsiElement)ktPsiFactory.createLiteralStringTemplateEntry(DOLLAR));
                continue;
            }
            if (!(ktStringTemplateEntry instanceof KtBlockStringTemplateEntry)) continue;
            KtExpression ktExpression = ((KtBlockStringTemplateEntry)entry).getExpression();
            if (!ArraysKt.contains((Object[])PrefixedStringTemplateUtilsKt.getDollarLiteralExpressions(), (Object)(ktExpression != null ? ktExpression.getText() : null)) || !MultiDollarStringUtilsKt.isSafeToReplaceWithDollar(entry, prefixLength)) continue;
            ((KtBlockStringTemplateEntry)entry).replace((PsiElement)ktPsiFactory.createLiteralStringTemplateEntry(DOLLAR));
        }
        KtStringTemplateExpression replacement = ktPsiFactory.createMultiDollarStringTemplate(KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)element), prefixLength, !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element));
        PsiElement psiElement = element.replace((PsiElement)replacement);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        return (KtStringTemplateExpression)psiElement;
    }

    public static final int longestUnsafeDollarSequenceLength(@NotNull KtStringTemplateExpression element, int threshold) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int longest = 0;
        int current = 0;
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])element.getEntries());
        while (iterator2.hasNext()) {
            boolean bl;
            String $this$takeLastWhile$iv;
            int index$iv;
            boolean $i$f$takeLastWhile;
            KtStringTemplateEntry entry;
            block14: {
                entry = (KtStringTemplateEntry)iterator2.next();
                KtStringTemplateEntry ktStringTemplateEntry = entry;
                if (ktStringTemplateEntry instanceof KtSimpleNameStringTemplateEntry) {
                    current = 0;
                    continue;
                }
                if (ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry) {
                    if (MultiDollarStringUtilsKt.isEscapedDollar((KtEscapeStringTemplateEntry)entry)) {
                        ++current;
                        continue;
                    }
                    current = 0;
                    continue;
                }
                if (ktStringTemplateEntry instanceof KtBlockStringTemplateEntry) {
                    if (MultiDollarStringUtilsKt.isSimplifiableInterpolatedDollar((KtBlockStringTemplateEntry)entry)) {
                        ++current;
                        continue;
                    }
                    current = 0;
                    continue;
                }
                if (!(ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry)) continue;
                if (PrefixedStringTemplateUtilsKt.canBeConsideredIdentifierOrBlock((KtLiteralStringTemplateEntry)entry)) {
                    String string;
                    block13: {
                        if (current > longest) {
                            longest = current;
                        }
                        if (longest >= threshold) break;
                        Intrinsics.checkNotNullExpressionValue((Object)((KtLiteralStringTemplateEntry)entry).getText(), (String)"getText(...)");
                        $i$f$takeLastWhile = false;
                        for (index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                            char it22 = $this$takeLastWhile$iv.charAt(index$iv);
                            int n = 0;
                            if (it22 == '$') continue;
                            String it22 = $this$takeLastWhile$iv;
                            n = index$iv + 1;
                            String string2 = it22.substring(n);
                            string = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            break block13;
                        }
                        string = $this$takeLastWhile$iv;
                    }
                    current = string.length();
                    continue;
                }
                String string = ((KtLiteralStringTemplateEntry)entry).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                CharSequence $this$all$iv = string;
                boolean $i$f$all = false;
                for (index$iv = 0; index$iv < $this$all$iv.length(); ++index$iv) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(index$iv);
                    boolean bl2 = false;
                    if (it == '$') continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
            if (bl) {
                current += ((KtLiteralStringTemplateEntry)entry).getText().length();
                continue;
            }
            String string = ((KtLiteralStringTemplateEntry)entry).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.endsWith$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null)) {
                String string3;
                block15: {
                    Intrinsics.checkNotNullExpressionValue((Object)((KtLiteralStringTemplateEntry)entry).getText(), (String)"getText(...)");
                    $i$f$takeLastWhile = false;
                    for (index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                        char it = $this$takeLastWhile$iv.charAt(index$iv);
                        boolean bl3 = false;
                        if (it == '$') continue;
                        String string4 = $this$takeLastWhile$iv;
                        int n = index$iv + 1;
                        String string5 = string4.substring(n);
                        string3 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        break block15;
                    }
                    string3 = $this$takeLastWhile$iv;
                }
                current = string3.length();
                continue;
            }
            current = 0;
        }
        return longest;
    }

    public static /* synthetic */ int longestUnsafeDollarSequenceLength$default(KtStringTemplateExpression ktStringTemplateExpression, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return MultiDollarStringUtilsKt.longestUnsafeDollarSequenceLength(ktStringTemplateExpression, n);
    }

    private static final boolean isSimplifiableInterpolatedDollar(KtBlockStringTemplateEntry $this$isSimplifiableInterpolatedDollar) {
        KtExpression ktExpression = $this$isSimplifiableInterpolatedDollar.getExpression();
        return ArraysKt.contains((Object[])PrefixedStringTemplateUtilsKt.getDollarLiteralExpressions(), (Object)(ktExpression != null ? ktExpression.getText() : null));
    }

    private static final void replaceExpressionEntries(KtStringTemplateExpression stringTemplate, int prefixLength) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])stringTemplate.getEntries());
        while (iterator2.hasNext()) {
            KtStringTemplateEntry entry = (KtStringTemplateEntry)iterator2.next();
            if (!(entry instanceof KtStringTemplateEntryWithExpression)) continue;
            ((KtStringTemplateEntryWithExpression)entry).replace((PsiElement)PrefixedStringTemplateUtilsKt.changePrefixLength((KtStringTemplateEntryWithExpression)entry, prefixLength));
        }
    }

    private static final boolean isEscapedDollar(KtEscapeStringTemplateEntry $this$isEscapedDollar) {
        return Intrinsics.areEqual((Object)$this$isEscapedDollar.getUnescapedValue(), (Object)DOLLAR);
    }

    private static final boolean isSafeToReplaceWithDollar(KtStringTemplateEntry $this$isSafeToReplaceWithDollar, int prefixLength) {
        String string;
        block4: {
            if (!($this$isSafeToReplaceWithDollar.getPrevSibling() instanceof KtLiteralStringTemplateEntry)) {
                return true;
            }
            PsiElement psiElement = $this$isSafeToReplaceWithDollar.getNextSibling();
            KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = psiElement instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)psiElement : null;
            if (ktLiteralStringTemplateEntry == null) {
                return true;
            }
            KtLiteralStringTemplateEntry nextSiblingStringLiteral = ktLiteralStringTemplateEntry;
            if (!PrefixedStringTemplateUtilsKt.canBeConsideredIdentifierOrBlock(nextSiblingStringLiteral)) {
                return true;
            }
            String string2 = $this$isSafeToReplaceWithDollar.getPrevSibling().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String $this$takeLastWhile$iv = string2;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (Intrinsics.areEqual((Object)String.valueOf(it), (Object)DOLLAR)) continue;
                String string3 = $this$takeLastWhile$iv;
                int n = index$iv + 1;
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                break block4;
            }
            string = $this$takeLastWhile$iv;
        }
        int trailingDollarsLength = string.length();
        return trailingDollarsLength + 1 < prefixLength;
    }
}

