/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.refactoring.pullUp.MarkingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownContext;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownImplKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.search.declarationsSearch.ClassInheritorsSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002&'B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0014J!\u0010\u000f\u001a\u00060\u0010R\u00020\u00002\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0014\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u001d\u0010\u0017\u001a\u00020\u00162\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020 H\u0002J\u001d\u0010$\u001a\u00020 2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0014\u00a2\u0006\u0002\u0010%R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "sourceClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "membersToMove", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtClass;Ljava/util/List;)V", "context", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownContext;", "getCommandName", "", "createUsageViewDescriptor", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "getBeforeData", "Lcom/intellij/refactoring/listeners/RefactoringEventData;", "getAfterData", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/refactoring/listeners/RefactoringEventData;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "preprocessUsages", "", "refUsages", "Lcom/intellij/openapi/util/Ref;", "pushDownToClass", "", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "removeOriginalMembers", "performRefactoring", "([Lcom/intellij/usageView/UsageInfo;)V", "UsageViewDescriptorImpl", "SubclassUsage", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinPushDownProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPushDownProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1557#2:202\n1628#2,3:203\n1611#2,9:221\n1863#2:230\n1864#2:232\n1620#2:233\n1557#2:234\n1628#2,3:235\n1863#2,2:240\n37#3,2:206\n37#3,2:238\n11483#4,9:208\n13409#4:217\n13410#4:219\n11492#4:220\n13409#4:242\n13410#4:244\n1#5:218\n1#5:231\n1#5:243\n*S KotlinDebug\n*F\n+ 1 KotlinPushDownProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor\n*L\n83#1:202\n83#1:203,3\n92#1:221,9\n92#1:230\n92#1:232\n92#1:233\n93#1:234\n93#1:235,3\n192#1:240,2\n83#1:206,2\n94#1:238,2\n87#1:208,9\n87#1:217\n87#1:219\n87#1:220\n195#1:242\n195#1:244\n87#1:218\n92#1:231\n*E\n"})
public final class KotlinPushDownProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final KotlinPushDownContext context;

    public KotlinPushDownProcessor(@NotNull Project project, @NotNull KtClass sourceClass, @NotNull List<KotlinMemberInfo> membersToMove) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceClass, (String)"sourceClass");
        Intrinsics.checkNotNullParameter(membersToMove, (String)"membersToMove");
        super(project);
        this.context = new KotlinPushDownContext(sourceClass, membersToMove);
    }

    @NotNull
    protected String getCommandName() {
        return KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN();
    }

    @NotNull
    protected UsageViewDescriptorImpl createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptorImpl();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected RefactoringEventData getBeforeData() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        RefactoringEventData refactoringEventData;
        RefactoringEventData $this$getBeforeData_u24lambda_u241 = refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        $this$getBeforeData_u24lambda_u241.addElement((PsiElement)this.context.getSourceClass());
        Iterable iterable = this.context.getMembersToMove();
        RefactoringEventData refactoringEventData2 = $this$getBeforeData_u24lambda_u241;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinMemberInfo kotlinMemberInfo = (KotlinMemberInfo)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add((KtNamedDeclaration)it.getMember());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        refactoringEventData2.addElements((PsiElement[])thisCollection$iv.toArray(new KtNamedDeclaration[0]));
        return refactoringEventData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        RefactoringEventData refactoringEventData;
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        RefactoringEventData $this$getAfterData_u24lambda_u243 = refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        UsageInfo[] usageInfoArray = usages;
        RefactoringEventData refactoringEventData2 = $this$getAfterData_u24lambda_u243;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            KtClassOrObject it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl2 = false;
            void it = element$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement = it.getElement();
            if ((psiElement instanceof KtClassOrObject ? (KtClassOrObject)psiElement : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        refactoringEventData2.addElements((Collection)((List)destination$iv$iv));
        return refactoringEventData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        PsiElement psiElement = (PsiElement)this.context.getSourceClass();
        SearchScope searchScope = this.context.getSourceClass().getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        Iterable $this$mapNotNull$iv = (Iterable)ClassInheritorsSearchKt.searchInheritors(new HierarchySearchRequest<PsiElement>(psiElement, searchScope, false));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        PsiElement psiElement2 = $this$forEach$iv$iv$iv.iterator();
        while (psiElement2.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = psiElement2.next();
            boolean bl = false;
            PsiClass it = (PsiClass)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            psiElement2 = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$findUsages$stub_for_inlining = false;
            boolean bl = false;
            collection.add(new SubclassUsage((PsiElement)p0));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SubclassUsage[0]);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        Object[] objectArray;
        String message2;
        int answer;
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        UsageInfo[] usageInfoArray = (UsageInfo[])refUsages.get();
        if (usageInfoArray == null) {
            usageInfoArray = UsageInfo.EMPTY_ARRAY;
        }
        UsageInfo[] usages = usageInfoArray;
        Intrinsics.checkNotNull((Object)usages);
        if (usages.length == 0 && (answer = Messages.showYesNoDialog((String)StringsKt.capitalize((String)(message2 = KotlinBundle.message((String)"text.0.have.no.inheritors.warning", (Object[])(objectArray = new Object[]{PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)this.context.getSourceClassDescriptor())})))), (String)KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN(), (Icon)Messages.getWarningIcon())) == 1) {
            return false;
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        String string = RefactoringBundle.message((String)"detecting.possible.conflicts");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        MultiMap multiMap = (MultiMap)ProgressUtilsKt.runSynchronouslyWithProgress(project, string, true, () -> KotlinPushDownProcessor.preprocessUsages$lambda$6(this, usages));
        if (multiMap == null) {
            return false;
        }
        MultiMap conflicts = multiMap;
        return this.showConflicts(conflicts, usages);
    }

    private final void pushDownToClass(KtClassOrObject targetClass) {
        SimpleType simpleType = this.context.getSourceClassDescriptor().getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        SimpleType sourceClassType = simpleType;
        DeclarationDescriptor declarationDescriptor = ResolutionFacade.resolveToDescriptor$default(this.context.getResolutionFacade(), (KtDeclaration)targetClass, null, 2, null);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor targetClassDescriptor = (ClassDescriptor)declarationDescriptor;
        KotlinType kotlinType = (KotlinType)sourceClassType;
        SimpleType simpleType2 = targetClassDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getDefaultType(...)");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = TypeUtils.getTypeSubstitution(kotlinType, (KotlinType)simpleType2);
        TypeSubstitutor substitutor2 = TypeUtils.orEmpty((TypeSubstitutor)(linkedHashMap != null ? TypeUtils.toSubstitutor((Map<TypeConstructor, ? extends TypeProjection>)linkedHashMap) : null));
        for (KotlinMemberInfo memberInfo : this.context.getMembersToMove()) {
            KtNamedDeclaration ktNamedDeclaration;
            KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
            if (this.context.getMemberDescriptors().get(member) == null) continue;
            KtNamedDeclaration ktNamedDeclaration2 = member;
            if (ktNamedDeclaration2 instanceof KtProperty || ktNamedDeclaration2 instanceof KtNamedFunction) {
                CallableMemberDescriptor cfr_ignored_0 = (CallableMemberDescriptor)memberDescriptor;
                Intrinsics.checkNotNull((Object)member, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                ktNamedDeclaration = (KtNamedDeclaration)PushDownImplKt.moveCallableMemberToClass((KtCallableDeclaration)member, (CallableMemberDescriptor)memberDescriptor, targetClass, targetClassDescriptor, substitutor2, memberInfo.isToAbstract());
            } else {
                if (!(ktNamedDeclaration2 instanceof KtClassOrObject) && !(ktNamedDeclaration2 instanceof KtPsiClassWrapper)) continue;
                if (memberInfo.getOverrides() != null) {
                    KtSuperTypeListEntry ktSuperTypeListEntry = PullUpUtilsKt.getSuperTypeEntryByDescriptor((KtClassOrObject)this.context.getSourceClass(), (ClassDescriptor)memberDescriptor, this.context.getSourceClassContext());
                    if (ktSuperTypeListEntry == null) continue;
                    KtSuperTypeListEntry it = ktSuperTypeListEntry;
                    boolean bl = false;
                    PullUpUtilsKt.addSuperTypeEntry(it, targetClass, targetClassDescriptor, this.context.getSourceClassContext(), substitutor2);
                    continue;
                }
                ktNamedDeclaration = PullUpUtilsKt.addMemberToTarget(member, targetClass);
            }
            KtNamedDeclaration movedMember = ktNamedDeclaration;
            MarkingUtilsKt.applyMarking(movedMember, substitutor2, targetClassDescriptor);
        }
    }

    private final void removeOriginalMembers() {
        for (KotlinMemberInfo memberInfo : this.context.getMembersToMove()) {
            DeclarationDescriptor memberDescriptor;
            KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
            if (this.context.getMemberDescriptors().get(member) == null) continue;
            KtNamedDeclaration ktNamedDeclaration = member;
            if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtNamedFunction) {
                Intrinsics.checkNotNull((Object)member, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                KtCallableDeclaration cfr_ignored_0 = (KtCallableDeclaration)member;
                CallableMemberDescriptor cfr_ignored_1 = (CallableMemberDescriptor)memberDescriptor;
                if (((CallableMemberDescriptor)memberDescriptor).getModality() != Modality.ABSTRACT && memberInfo.isToAbstract()) {
                    if (((KtTypeParameterListOwnerStub)member).hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                        ((KtTypeParameterListOwnerStub)member).addModifier(KtTokens.PROTECTED_KEYWORD);
                    }
                    KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)member;
                    CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)memberDescriptor;
                    TypeSubstitutor typeSubstitutor = TypeSubstitutor.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor, (String)"EMPTY");
                    PullUpUtilsKt.makeAbstract(ktCallableDeclaration, callableMemberDescriptor, typeSubstitutor, this.context.getSourceClass());
                    KtTypeReference ktTypeReference = ((KtCallableDeclaration)member).getTypeReference();
                    if (ktTypeReference != null) {
                        DelayedRequestsWaitingSetKt.addToShorteningWaitSet$default((KtElement)ktTypeReference, null, 1, null);
                    }
                    continue;
                }
                ((KtTypeParameterListOwnerStub)member).delete();
                continue;
            }
            if (!(ktNamedDeclaration instanceof KtClassOrObject) && !(ktNamedDeclaration instanceof KtPsiClassWrapper)) continue;
            if (memberInfo.getOverrides() != null) {
                KtSuperTypeListEntry ktSuperTypeListEntry = PullUpUtilsKt.getSuperTypeEntryByDescriptor((KtClassOrObject)this.context.getSourceClass(), (ClassDescriptor)memberDescriptor, this.context.getSourceClassContext());
                if (ktSuperTypeListEntry == null) continue;
                KtSuperTypeListEntry it = ktSuperTypeListEntry;
                boolean bl = false;
                this.context.getSourceClass().removeSuperTypeListEntry(it);
                continue;
            }
            member.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        ArrayList markedElements = new ArrayList();
        try {
            UsageInfo[] $this$forEach$iv = (UsageInfo[])this.context.getMembersToMove();
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                KotlinMemberInfo it = (KotlinMemberInfo)((Object)t);
                boolean bl = false;
                Collection collection = markedElements;
                PsiElement psiElement = it.getMember();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getMember(...)");
                CollectionsKt.addAll((Collection)collection, (Iterable)MarkingUtilsKt.markElements((KtNamedDeclaration)psiElement, this.context.getSourceClassContext(), this.context.getSourceClassDescriptor(), null));
            }
            $this$forEach$iv = usages;
            $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                KtClassOrObject it;
                UsageInfo element$iv;
                UsageInfo it2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                PsiElement psiElement = it2.getElement();
                if ((psiElement instanceof KtClassOrObject ? (KtClassOrObject)psiElement : null) == null) continue;
                it = it;
                boolean bl2 = false;
                this.pushDownToClass(it);
            }
            this.removeOriginalMembers();
        }
        finally {
            MarkingUtilsKt.clearMarking(markedElements);
        }
    }

    private static final MultiMap preprocessUsages$lambda$6$lambda$5(KotlinPushDownProcessor this$0, UsageInfo[] $usages) {
        KotlinPushDownContext kotlinPushDownContext = this$0.context;
        Intrinsics.checkNotNull((Object)$usages);
        return PushDownConflictsUtilsKt.analyzePushDownConflicts(kotlinPushDownContext, $usages);
    }

    private static final MultiMap preprocessUsages$lambda$6(KotlinPushDownProcessor this$0, UsageInfo[] $usages) {
        return (MultiMap)ActionsKt.runReadAction(() -> KotlinPushDownProcessor.preprocessUsages$lambda$6$lambda$5(this$0, $usages));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$SubclassUsage;", "Lcom/intellij/usageView/UsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "kotlin.idea"})
    public static final class SubclassUsage
    extends UsageInfo {
        public SubclassUsage(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\f\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "Lcom/intellij/usageView/UsageViewDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor;)V", "getProcessedElementsHeader", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getElements", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "()[Lorg/jetbrains/kotlin/psi/KtClass;", "getCodeReferencesText", "usagesCount", "", "filesCount", "getCommentReferencesText", "", "kotlin.idea"})
    public final class UsageViewDescriptorImpl
    implements UsageViewDescriptor {
        @NotNull
        public String getProcessedElementsHeader() {
            String string = RefactoringBundle.message((String)"push.down.members.elements.header");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public KtClass[] getElements() {
            KtClass[] ktClassArray = new KtClass[]{KotlinPushDownProcessor.this.context.getSourceClass()};
            return ktClassArray;
        }

        @NotNull
        public String getCodeReferencesText(int usagesCount, int filesCount) {
            Object[] objectArray = new Object[]{UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount)};
            String string = RefactoringBundle.message((String)"classes.to.push.down.members.to", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Nullable
        public Void getCommentReferencesText(int usagesCount, int filesCount) {
            return null;
        }
    }
}

