/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinASStatisticsEventFlags;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IS_KMP_MODULE", "", "calculateAndPackEventsFlagsToLong", "", "module", "Lcom/intellij/openapi/module/Module;", "Builder", "kotlin.base.statistics"})
public final class KotlinASStatisticsEventFlags {
    @NotNull
    public static final KotlinASStatisticsEventFlags INSTANCE = new KotlinASStatisticsEventFlags();
    @NotNull
    private static final Logger LOG;
    private static final int IS_KMP_MODULE;

    private KotlinASStatisticsEventFlags() {
    }

    public final long calculateAndPackEventsFlagsToLong(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new Builder().build((Function1<? super Builder, Unit>)((Function1)arg_0 -> KotlinASStatisticsEventFlags.calculateAndPackEventsFlagsToLong$lambda$0(module, arg_0)));
    }

    private static final Unit calculateAndPackEventsFlagsToLong$lambda$0(Module $module, Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $this$build.registerEvent(IS_KMP_MODULE, KotlinFacetUtils.isKpmModule($module));
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(KotlinASStatisticsEventFlags.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\rJ\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0011\u001a\u00020\tH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinASStatisticsEventFlags$Builder;", "", "<init>", "()V", "events", "", "", "", "build", "", "f", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "registerEvent", "eventIndex", "value", "calculateLong", "kotlin.base.statistics"})
    private static final class Builder {
        @NotNull
        private final Map<Integer, Boolean> events = new LinkedHashMap();

        public final long build(@NotNull Function1<? super Builder, Unit> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            f.invoke((Object)this);
            return this.calculateLong();
        }

        public final void registerEvent(int eventIndex, boolean value) {
            if (this.events.get(eventIndex) != null) {
                LOG.error("Event with index " + eventIndex + " already registered");
                return;
            }
            if (eventIndex < 0 || eventIndex > 63) {
                LOG.error("Event index should be in range [0, 63], but it is " + eventIndex);
                return;
            }
            Integer n = eventIndex;
            Boolean bl = value;
            this.events.put(n, bl);
        }

        private final long calculateLong() {
            Ref.LongRef flags = new Ref.LongRef();
            for (Map.Entry<Integer, Boolean> entry : this.events.entrySet()) {
                int bitIndex = ((Number)entry.getKey()).intValue();
                boolean value = entry.getValue();
                if (!value) continue;
                Builder.calculateLong$setBit(flags, bitIndex);
            }
            return flags.element;
        }

        private static final void calculateLong$setBit(Ref.LongRef flags, int bitIndex) {
            flags.element |= 1L << bitIndex;
        }
    }
}

