/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\u001aI\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00020\u0001\"\b\b\u0000\u0010\u0004*\u00020\u0005\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0006\u001a\u0002H\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00030\b\u00a2\u0006\u0002\u0010\t\u001a#\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000b\"\b\b\u0000\u0010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\u0004\u00a2\u0006\u0002\u0010\f\u001a\u001f\u0010\r\u001a\u0004\u0018\u0001H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\u0004\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"generateBridges", "", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "Function", "Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "function", "signature", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;Lkotlin/jvm/functions/Function1;)Ljava/util/Set;", "findAllReachableDeclarations", "", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;)Ljava/util/Set;", "findConcreteSuperDeclaration", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;)Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "backend-common"})
@SourceDebugExtension(value={"SMAP\nbridges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 bridges.kt\norg/jetbrains/kotlin/backend/common/bridges/BridgesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n2632#2,3:139\n1510#2,3:142\n1513#2,3:152\n1557#2:155\n1628#2,3:156\n774#2:160\n865#2,2:161\n381#3,7:145\n1#4:159\n*S KotlinDebug\n*F\n+ 1 bridges.kt\norg/jetbrains/kotlin/backend/common/bridges/BridgesKt\n*L\n59#1:139,3\n63#1:142,3\n63#1:152,3\n82#1:155\n82#1:156,3\n127#1:160\n127#1:161,2\n63#1:145,7\n*E\n"})
public final class BridgesKt {
    @NotNull
    public static final <Function extends FunctionHandle, Signature> Set<Bridge<Signature, Function>> generateBridges(@NotNull Function function2, @NotNull Function1<? super Function, ? extends Signature> signature) {
        Iterator<FunctionHandle> $this$groupByTo$iv;
        boolean fake;
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        Intrinsics.checkNotNullParameter(signature, (String)"signature");
        if (function2.isAbstract()) {
            return SetsKt.emptySet();
        }
        boolean bl = fake = !function2.isDeclaration();
        if (fake) {
            boolean bl2;
            block14: {
                Iterable<FunctionHandle> $this$none$iv = function2.getOverridden();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object e : $this$none$iv) {
                        FunctionHandle it = (FunctionHandle)e;
                        boolean bl3 = false;
                        if (!it.isAbstract()) continue;
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return SetsKt.emptySet();
            }
        }
        Function Function23 = BridgesKt.findConcreteSuperDeclaration(function2);
        if (Function23 == null) {
            return SetsKt.emptySet();
        }
        Function implementation2 = Function23;
        Iterable iterable = BridgesKt.findAllReachableDeclarations(function2);
        Map map = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv = iterator2.next();
            Object key$iv = signature.invoke(element$iv);
            Map $this$getOrPut$iv$iv = map;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        LinkedHashMap bridgesToGenerate = (LinkedHashMap)map;
        if (fake) {
            Iterable<FunctionHandle> iterable2 = function2.getOverridden();
            Intrinsics.checkNotNull(iterable2, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<Function of org.jetbrains.kotlin.backend.common.bridges.BridgesKt.generateBridges>");
            for (FunctionHandle functionHandle : iterable2) {
                if (functionHandle.isAbstract()) continue;
                for (FunctionHandle functionHandle2 : BridgesKt.findAllReachableDeclarations(functionHandle)) {
                    bridgesToGenerate.remove(signature.invoke((Object)functionHandle2));
                }
            }
        }
        Object method = signature.invoke(implementation2);
        bridgesToGenerate.remove(method);
        Set set = bridgesToGenerate.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable iterable3 = set;
        boolean $i$f$map = false;
        Iterable iterable4 = iterable3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable4) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)entry);
            Object overriddenSignature = entry.getKey();
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            List overriddenFunctions = (List)v;
            collection.add(new Bridge(overriddenSignature, method, CollectionsKt.toSet((Iterable)overriddenFunctions)));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final <Function extends FunctionHandle> Set<Function> findAllReachableDeclarations(@NotNull Function function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        DFS.NodeHandlerWithListResult collector2 = new DFS.NodeHandlerWithListResult<Function, Function>(){

            public void afterChildren(Function current) {
                Intrinsics.checkNotNullParameter(current, (String)"current");
                if (current.isDeclaration()) {
                    ((LinkedList)this.result).add(current);
                }
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf(function2), BridgesKt::findAllReachableDeclarations$lambda$2, (DFS.NodeHandler)((DFS.NodeHandler)collector2));
        return new LinkedHashSet((Collection)collector2.result());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <Function extends FunctionHandle> Function findConcreteSuperDeclaration(@NotNull Function function2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        if (!(!function2.isAbstract())) {
            boolean $i$a$-require-BridgesKt$findConcreteSuperDeclaration$22 = false;
            String $i$a$-require-BridgesKt$findConcreteSuperDeclaration$22 = "Only concrete functions have implementations: " + function2;
            throw new IllegalArgumentException($i$a$-require-BridgesKt$findConcreteSuperDeclaration$22.toString());
        }
        if (function2.isDeclaration()) {
            return function2;
        }
        Set<Function> result = BridgesKt.findAllReachableDeclarations(function2);
        HashSet toRemove = new HashSet();
        for (Function declaration : result) {
            Set<Function> reachable = BridgesKt.findAllReachableDeclarations(declaration);
            reachable.remove(declaration);
            toRemove.addAll(reachable);
        }
        result.removeAll(toRemove);
        Iterable $this$filter$iv = result;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionHandle it = (FunctionHandle)element$iv$iv;
            boolean bl = false;
            if (!(!it.isAbstract() && it.getMayBeUsedAsSuperImplementation())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List concreteRelevantDeclarations = (List)destination$iv$iv;
        if (concreteRelevantDeclarations.size() != 1) {
            if (!function2.getMightBeIncorrectCode()) {
                throw new IllegalStateException(("Concrete fake override " + function2 + " should have exactly one concrete super-declaration: " + concreteRelevantDeclarations).toString());
            }
            return null;
        }
        return (Function)((FunctionHandle)concreteRelevantDeclarations.get(0));
    }

    private static final Iterable findAllReachableDeclarations$lambda$2(FunctionHandle it) {
        Iterable<FunctionHandle> iterable = it.getOverridden();
        Intrinsics.checkNotNull(iterable, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<Function of org.jetbrains.kotlin.backend.common.bridges.BridgesKt.findAllReachableDeclarations>");
        return iterable;
    }
}

