/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.compiler.charts.jps;

import com.google.gson.Gson;
import com.intellij.util.containers.ContainerUtil;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.MemoryMXBean;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CustomBuilderMessage;

public class CompileStatisticBuilderMessage
extends CustomBuilderMessage {
    private static final Gson JSON = new Gson();

    private CompileStatisticBuilderMessage(@NotNull String messageType, @NotNull String data) {
        if (messageType == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(0);
        }
        if (data == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(1);
        }
        super("jps.compile.statistic", messageType, data);
    }

    @NotNull
    public static CompileStatisticBuilderMessage create(@NotNull Set<? extends BuildTarget<?>> targets, @NotNull String event) {
        if (targets == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(2);
        }
        if (event == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(3);
        }
        List events = ContainerUtil.map(targets, target -> CompileStatisticBuilderMessage.map(target, event.equals("STARTED") ? StartTarget::new : FinishTarget::new));
        return new CompileStatisticBuilderMessage(event, JSON.toJson((Object)events));
    }

    @NotNull
    private static <T extends TargetEvent> T map(@NotNull BuildTarget<?> target, @NotNull Supplier<T> event) {
        if (target == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(4);
        }
        if (event == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(5);
        }
        TargetEvent data = (TargetEvent)event.get();
        data.name = target instanceof ModuleBasedTarget ? ((ModuleBasedTarget)target).getModule().getName() : target.getId();
        data.type = target.getTargetType().getTypeId();
        data.isFileBased = target.getTargetType().isFileBased();
        data.isTest = target.getTargetType() instanceof JavaModuleBuildTargetType && ((JavaModuleBuildTargetType)target.getTargetType()).isTests();
        TargetEvent targetEvent = data;
        if (targetEvent == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(6);
        }
        return (T)targetEvent;
    }

    @Nullable
    public static BuildMessage create(@NotNull MemoryMXBean memory, @NotNull OperatingSystemMXBean os) {
        if (memory == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(7);
        }
        if (os == null) {
            CompileStatisticBuilderMessage.$$$reportNull$$$0(8);
        }
        CpuMemoryStatistics statistics = new CpuMemoryStatistics();
        statistics.heapUsed = memory.getHeapMemoryUsage().getUsed();
        statistics.heapMax = memory.getHeapMemoryUsage().getMax();
        statistics.nonHeapUsed = memory.getNonHeapMemoryUsage().getUsed();
        statistics.nonHeapMax = memory.getNonHeapMemoryUsage().getMax();
        double cpuLoad = 0.0;
        int maxRetries = 5;
        while (maxRetries-- > 0 && cpuLoad <= 0.0) {
            cpuLoad = os.getSystemCpuLoad();
        }
        if (cpuLoad < 0.0) {
            return null;
        }
        statistics.cpu = (long)(cpuLoad * 100.0);
        return new CompileStatisticBuilderMessage("STATISTIC", JSON.toJson((Object)statistics));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/compiler/charts/jps/CompileStatisticBuilderMessage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/compiler/charts/jps/CompileStatisticBuilderMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class TargetEvent {
        public String name;
        public String type;
        public boolean isTest;
        public boolean isFileBased;
        public long time = System.nanoTime();
        public long thread = Thread.currentThread().getId();
    }

    public static class CpuMemoryStatistics {
        public long heapUsed;
        public long heapMax;
        public long nonHeapUsed;
        public long nonHeapMax;
        public long cpu;
        public long time = System.nanoTime();
    }

    public static class FinishTarget
    extends TargetEvent {
    }

    public static class StartTarget
    extends TargetEvent {
    }
}

