/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.CreateConnectionDetails;
import com.oracle.bmc.devops.model.TlsVerifyConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateGitlabServerAccessTokenConnectionDetails
extends CreateConnectionDetails {
    @JsonProperty(value="accessToken")
    private final String accessToken;
    @JsonProperty(value="baseUrl")
    private final String baseUrl;
    @JsonProperty(value="tlsVerifyConfig")
    private final TlsVerifyConfig tlsVerifyConfig;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateGitlabServerAccessTokenConnectionDetails(String description, String displayName, String projectId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String accessToken, String baseUrl, TlsVerifyConfig tlsVerifyConfig) {
        super(description, displayName, projectId, freeformTags, definedTags);
        this.accessToken = accessToken;
        this.baseUrl = baseUrl;
        this.tlsVerifyConfig = tlsVerifyConfig;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public TlsVerifyConfig getTlsVerifyConfig() {
        return this.tlsVerifyConfig;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateGitlabServerAccessTokenConnectionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", accessToken=").append(String.valueOf(this.accessToken));
        sb.append(", baseUrl=").append(String.valueOf(this.baseUrl));
        sb.append(", tlsVerifyConfig=").append(String.valueOf((Object)this.tlsVerifyConfig));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateGitlabServerAccessTokenConnectionDetails)) {
            return false;
        }
        CreateGitlabServerAccessTokenConnectionDetails other = (CreateGitlabServerAccessTokenConnectionDetails)((Object)o);
        return Objects.equals(this.accessToken, other.accessToken) && Objects.equals(this.baseUrl, other.baseUrl) && Objects.equals((Object)this.tlsVerifyConfig, (Object)other.tlsVerifyConfig) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.accessToken == null ? 43 : this.accessToken.hashCode());
        result = result * 59 + (this.baseUrl == null ? 43 : this.baseUrl.hashCode());
        result = result * 59 + (this.tlsVerifyConfig == null ? 43 : this.tlsVerifyConfig.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="accessToken")
        private String accessToken;
        @JsonProperty(value="baseUrl")
        private String baseUrl;
        @JsonProperty(value="tlsVerifyConfig")
        private TlsVerifyConfig tlsVerifyConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            this.__explicitlySet__.add("accessToken");
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            this.__explicitlySet__.add("baseUrl");
            return this;
        }

        public Builder tlsVerifyConfig(TlsVerifyConfig tlsVerifyConfig) {
            this.tlsVerifyConfig = tlsVerifyConfig;
            this.__explicitlySet__.add("tlsVerifyConfig");
            return this;
        }

        public CreateGitlabServerAccessTokenConnectionDetails build() {
            CreateGitlabServerAccessTokenConnectionDetails model = new CreateGitlabServerAccessTokenConnectionDetails(this.description, this.displayName, this.projectId, this.freeformTags, this.definedTags, this.accessToken, this.baseUrl, this.tlsVerifyConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateGitlabServerAccessTokenConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("accessToken")) {
                this.accessToken(model.getAccessToken());
            }
            if (model.wasPropertyExplicitlySet("baseUrl")) {
                this.baseUrl(model.getBaseUrl());
            }
            if (model.wasPropertyExplicitlySet("tlsVerifyConfig")) {
                this.tlsVerifyConfig(model.getTlsVerifyConfig());
            }
            return this;
        }
    }
}

