/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.OverlayLayout;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.undo.UndoableEdit;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormCookie;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormToolBar;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.NonVisualTray;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.VisualMapper;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.wizard.ConnectionWizard;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorLookupPanelsPolicy;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.SaveCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class FormDesigner {
    static final String PROP_DESIGNER_SIZE = "designerSize";
    public static final String PROP_TOP_DESIGN_COMPONENT = "topDesignComponent";
    private JComponent canvasRoot;
    private JLayeredPane layeredPane;
    private ComponentLayer componentLayer;
    private HandleLayer handleLayer;
    private NonVisualTray nonVisualTray;
    private FormToolBar formToolBar;
    private InPlaceEditLayer textEditLayer;
    private FormProperty editedProperty;
    private InPlaceEditLayer.FinishListener finnishListener;
    private MenuEditLayer menuEditLayer;
    private FormModel formModel;
    private FormModelListener formModelListener;
    private RADVisualComponent topDesignComponent;
    private boolean designerSizeExplictlySet;
    private static FormDesigner selectedDesigner;
    private FormEditor formEditor;
    private List<RADComponent> selectedComponents = new ArrayList<RADComponent>();
    private List<RADVisualComponent> selectedLayoutComponents = new ArrayList<RADVisualComponent>();
    private ExplorerManager explorerManager;
    private boolean synchronizingSelection;
    private VisualReplicator replicator;
    private LayoutDesigner layoutDesigner;
    private List<Action> designerActions;
    private Action[] resizabilityActions;
    private int designerMode;
    public static final int MODE_SELECT = 0;
    public static final int MODE_CONNECT = 1;
    public static final int MODE_ADD = 2;
    private boolean initialized = false;
    private boolean active;
    private RADComponent connectionSource;
    private RADComponent connectionTarget;
    private InstanceContent lookupContent;
    private FormProxyLookup lookup;
    private boolean settingLookup;
    private UndoRedo.Provider undoRedoProvider;
    private PropertyChangeSupport propertyChangeSupport;

    public FormDesigner(FormEditor formEditor) {
        FormLoaderSettings settings = FormLoaderSettings.getInstance();
        Color backgroundColor = settings.getFormDesignerBackgroundColor();
        Color borderColor = settings.getFormDesignerBorderColor();
        JPanel loadingPanel = new JPanel();
        loadingPanel.setLayout(new FlowLayout(0, 12, 12));
        loadingPanel.setBackground(backgroundColor);
        JLabel loadingLbl = new JLabel(FormUtils.getBundleString("LBL_FormLoading"));
        loadingLbl.setOpaque(true);
        loadingLbl.setBorder(new LineBorder(borderColor, 4));
        loadingLbl.setPreferredSize(new Dimension(408, 308));
        loadingLbl.setHorizontalAlignment(0);
        loadingPanel.add(loadingLbl);
        this.canvasRoot = loadingPanel;
        this.formEditor = formEditor;
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectionListener());
        this.initLookup();
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        assert (this.formEditor.isFormLoaded());
        this.initialized = true;
        this.formModel = this.formEditor.getFormModel();
        this.componentLayer = new ComponentLayer(this.formModel);
        this.handleLayer = new HandleLayer(this);
        this.nonVisualTray = FormEditor.isNonVisualTrayEnabled() ? new NonVisualTray(this.explorerManager, (Node)this.formEditor.getOthersContainerNode()) : null;
        JPanel designPanel = new JPanel(new BorderLayout());
        designPanel.add((Component)this.componentLayer, "Center");
        if (this.nonVisualTray != null) {
            designPanel.add((Component)this.nonVisualTray, "South");
        }
        this.layeredPane = new JLayeredPane(){

            @Override
            protected void paintChildren(Graphics g) {
                FormDesigner.this.handleLayer.maskDraggingComponents();
                super.paintChildren(g);
            }
        };
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.add((Component)designPanel, (Object)1000);
        this.layeredPane.add((Component)this.handleLayer, (Object)1001);
        this.canvasRoot = this.layeredPane;
        this.explorerManager.setRootContext((Node)this.formEditor.getFormRootNode());
        this.undoRedoProvider = new UndoRedo.Provider(){

            public UndoRedo getUndoRedo() {
                UndoRedo.Manager ur = FormDesigner.this.formModel != null ? FormDesigner.this.formModel.getUndoRedoManager() : null;
                return ur != null ? ur : UndoRedo.NONE;
            }
        };
        this.lookupContent.add((Object)this.undoRedoProvider);
        this.initLookup();
        if (this.formModelListener == null) {
            this.formModelListener = new FormListener();
        }
        this.formModel.addFormModelListener(this.formModelListener);
        this.replicator = new VisualReplicator(true, FormUtils.getViewConverters(), FormEditor.getBindingSupport(this.formModel));
        this.resetTopDesignComponent(false);
        this.handleLayer.setViewOnly(this.formModel.isReadOnly());
        if (this.formModel.getLayoutModel() != null) {
            this.layoutDesigner = new LayoutDesigner(this.formModel.getLayoutModel(), new LayoutMapper());
            int paintLayout = FormLoaderSettings.getInstance().getPaintAdvancedLayoutInfo();
            this.layoutDesigner.setPaintAlignment((paintLayout & 1) != 0);
            this.layoutDesigner.setPaintGaps((paintLayout & 2) != 0);
        }
        this.updateWholeDesigner();
        this.formEditor.reinstallListener();
        if (this.formEditor.getFormDesigner() == null) {
            this.formEditor.setFormDesigner(this);
        }
        this.getMenuEditLayer();
        designPanel.putClientProperty("print.printable", Boolean.TRUE);
    }

    public void close() {
        if (this.menuEditLayer != null) {
            this.menuEditLayer.hideMenuLayer();
            this.menuEditLayer = null;
        }
        FormDesigner.setSelectedDesigner(this, false);
        if (this.initialized) {
            this.clearSelectionImpl();
            this.explorerManager.setRootContext(Node.EMPTY);
        }
        this.initialized = false;
        this.canvasRoot = null;
        this.componentLayer = null;
        this.handleLayer = null;
        if (this.nonVisualTray != null) {
            this.nonVisualTray.close();
            this.nonVisualTray = null;
        }
        this.layeredPane = null;
        if (this.textEditLayer != null) {
            if (this.textEditLayer.isVisible()) {
                this.textEditLayer.finishEditing(false);
            }
            this.textEditLayer.removeFinishListener(this.getFinnishListener());
            this.textEditLayer = null;
        }
        if (this.undoRedoProvider != null) {
            this.lookupContent.remove((Object)this.undoRedoProvider);
            this.undoRedoProvider = null;
        }
        if (this.formModel != null) {
            if (this.formModelListener != null) {
                this.formModel.removeFormModelListener(this.formModelListener);
            }
            this.topDesignComponent = null;
            this.designerSizeExplictlySet = false;
            this.formModel = null;
        }
        this.replicator = null;
        this.layoutDesigner = null;
        this.designerMode = 0;
        this.connectionSource = null;
        this.connectionTarget = null;
        this.formEditor = null;
    }

    private void initLookup() {
        Lookup dataObjectLookup;
        Lookup saveCookieLookup;
        Lookup paletteLookup;
        Lookup plainContentLookup;
        Lookup explorerLookup;
        if (this.lookup == null) {
            this.lookup = new FormProxyLookup();
            explorerLookup = null;
            this.lookupContent = new InstanceContent();
            this.lookupContent.add((Object)new NavigatorLookupPanelsPolicy(){

                public int getPanelsPolicy() {
                    return 1;
                }
            });
            this.lookupContent.add((Object)new NavigatorLookupHint(){

                public String getContentType() {
                    return "text/x-form";
                }
            });
            plainContentLookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
            paletteLookup = PaletteUtils.getPaletteLookup(this.formEditor.getFormDataObject().getPrimaryFile());
            saveCookieLookup = new Lookup(){

                public <T> T lookup(Class<T> clazz) {
                    if (clazz.isAssignableFrom(SaveCookie.class) && FormDesigner.this.formEditor != null) {
                        return (T)FormDesigner.this.formEditor.getFormDataObject().getLookup().lookup(clazz);
                    }
                    return null;
                }

                public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
                    if (template.getType().isAssignableFrom(SaveCookie.class) && FormDesigner.this.formEditor != null) {
                        return FormDesigner.this.formEditor.getFormDataObject().getLookup().lookup(template);
                    }
                    return Lookup.EMPTY.lookup(template);
                }
            };
            dataObjectLookup = null;
        } else {
            Lookup[] lookups = this.lookup.getSubLookups();
            explorerLookup = lookups[0];
            plainContentLookup = lookups[1];
            paletteLookup = lookups[2];
            saveCookieLookup = lookups[3];
            dataObjectLookup = lookups[4];
        }
        if (!this.initialized) {
            explorerLookup = Lookup.EMPTY;
        } else if (explorerLookup == Lookup.EMPTY) {
            ActionMap map = ComponentInspector.getInstance().setupActionMap(this.canvasRoot.getActionMap());
            explorerLookup = ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map);
        }
        if (dataObjectLookup == null || dataObjectLookup == Lookup.EMPTY && !this.initialized) {
            FormDataObject formDataObject = this.formEditor.getFormDataObject();
            dataObjectLookup = formDataObject.getNodeDelegate().getLookup();
        }
        this.lookup.setSubLookups(new Lookup[]{explorerLookup, plainContentLookup, paletteLookup, saveCookieLookup, dataObjectLookup});
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchNodeInLookup(boolean includeDataNodeLookup) {
        int index;
        boolean dataNodeLookup;
        if (this.settingLookup) {
            return;
        }
        Lookup[] lookups = this.lookup.getSubLookups();
        boolean bl = dataNodeLookup = lookups[index = lookups.length - 1] != Lookup.EMPTY;
        if (includeDataNodeLookup != dataNodeLookup) {
            lookups[index] = includeDataNodeLookup ? this.formEditor.getFormDataObject().getNodeDelegate().getLookup() : Lookup.EMPTY;
            try {
                this.settingLookup = true;
                this.lookup.setSubLookups(lookups);
            }
            finally {
                this.settingLookup = false;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }
    }

    private void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    public HandleLayer getHandleLayer() {
        return this.handleLayer;
    }

    ComponentLayer getComponentLayer() {
        return this.componentLayer;
    }

    NonVisualTray getNonVisualTray() {
        return this.nonVisualTray;
    }

    public void setToolBar(JToolBar toolbar) {
        this.formToolBar = new FormToolBar(this, toolbar);
    }

    public JToolBar getToolBar() {
        return this.getFormToolBar().getToolBar();
    }

    FormToolBar getFormToolBar() {
        if (this.formToolBar == null) {
            this.formToolBar = new FormToolBar(this, null);
        }
        return this.formToolBar;
    }

    public LayoutDesigner getLayoutDesigner() {
        return this.layoutDesigner;
    }

    public FormEditor getFormEditor() {
        return this.formEditor;
    }

    public Object getComponent(RADComponent metacomp) {
        return this.replicator != null ? this.replicator.getClonedComponent(metacomp.getId()) : null;
    }

    public Object getComponent(String componentId) {
        return this.replicator != null ? this.replicator.getClonedComponent(componentId) : null;
    }

    public RADComponent getMetaComponent(Object comp) {
        String id = this.replicator.getClonedComponentId(comp);
        return id != null ? this.formModel.getMetaComponent(id) : null;
    }

    public RADVisualComponent getTopDesignComponent() {
        return this.topDesignComponent;
    }

    public boolean isTopRADComponent() {
        RADComponent topMetaComp = this.formModel.getTopRADComponent();
        return topMetaComp != null && topMetaComp == this.topDesignComponent;
    }

    public void setTopDesignComponent(RADVisualComponent component, boolean update) {
        this.highlightTopDesignComponentName(false);
        RADVisualComponent old = this.topDesignComponent;
        this.topDesignComponent = component;
        this.designerSizeExplictlySet = false;
        this.highlightTopDesignComponentName(!this.isTopRADComponent());
        if (update) {
            this.selectedLayoutComponents.clear();
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
        this.firePropertyChange(PROP_TOP_DESIGN_COMPONENT, old, component);
        FormDesigner.updateTestAction();
        if (!this.selectedLayoutComponents.contains(this.topDesignComponent)) {
            this.selectedLayoutComponents.add(this.topDesignComponent);
            if (this.layoutDesigner != null && this.topDesignComponent instanceof RADVisualContainer && ((RADVisualContainer)this.topDesignComponent).getLayoutSupport() == null) {
                this.layoutDesigner.setSelectedComponents(this.topDesignComponent.getId());
            }
        }
    }

    private static void updateTestAction() {
        TestAction testAction = (TestAction)SystemAction.get(TestAction.class);
        testAction.updateEnabled();
    }

    private void highlightTopDesignComponentName(boolean bl) {
        RADComponentNode node;
        if (this.topDesignComponent != null && (node = this.topDesignComponent.getNodeReference()) != null) {
            node.highlightDisplayName(bl);
        }
    }

    public void resetTopDesignComponent(boolean update) {
        RADComponent top = this.formModel.getTopRADComponent();
        this.setTopDesignComponent(top instanceof RADVisualComponent ? (RADVisualComponent)top : null, update);
    }

    public boolean isInDesigner(RADVisualComponent metacomp) {
        Object comp;
        if (this.replicator != null && (comp = this.replicator.getClonedComponent(metacomp)) instanceof Component) {
            return this.componentLayer.isAncestorOf((Component)comp);
        }
        return false;
    }

    void updateWholeDesigner() {
        if (this.formModelListener != null) {
            this.formModelListener.formChanged(null);
        }
    }

    private void updateComponentLayer(boolean fireChange) {
        UndoableEdit layoutUndoEdit;
        if (this.formModel == null) {
            return;
        }
        if (this.getLayoutDesigner() == null) {
            return;
        }
        this.componentLayer.revalidate();
        RepaintManager.currentManager(this.componentLayer).validateInvalidComponents();
        LayoutModel layoutModel = this.formModel.getLayoutModel();
        UndoableEdit undoableEdit = layoutUndoEdit = this.formModel.isCompoundEditInProgress() && !layoutModel.isUndoableEditInProgress() ? layoutModel.getUndoableEdit() : null;
        if (this.getLayoutDesigner().updateCurrentState() && fireChange) {
            this.formModel.fireFormChanged(true);
        }
        if (layoutModel.endUndoableEdit() && layoutUndoEdit != null) {
            this.formModel.addUndoableEdit(layoutUndoEdit);
        }
        this.updateResizabilityActions();
        this.componentLayer.repaint();
    }

    void updateContainerLayout(RADVisualContainer metacont) {
        this.replicator.updateContainerLayout(metacont);
        this.componentLayer.revalidate();
        this.componentLayer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Container createFormView(final RADComponent metacomp, final FormLAF.PreviewInfo previewInfo) throws Exception {
        Container result = null;
        FormModel formModel = metacomp.getFormModel();
        FileObject formFile = FormEditor.getFormDataObject(formModel).getFormFile();
        final ClassLoader classLoader = ClassPathUtils.getProjectClassLoader(formFile);
        Locale defaultLocale = FormDesigner.switchToDesignLocale(formModel);
        try {
            FormLAF.setUsePreviewDefaults(classLoader, previewInfo);
            result = (Container)FormLAF.executeWithLookAndFeel(formModel, new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    FormModel formModel = metacomp.getFormModel();
                    VisualReplicator r = new VisualReplicator(false, FormUtils.getViewConverters(), FormEditor.getBindingSupport(formModel));
                    r.setTopMetaComponent(metacomp);
                    Object container = r.createClone();
                    if (container instanceof RootPaneContainer) {
                        JRootPane rootPane = ((RootPaneContainer)container).getRootPane();
                        JLayeredPane newPane = new JLayeredPane(){

                            @Override
                            public void paint(Graphics g) {
                                try {
                                    FormLAF.setUsePreviewDefaults(classLoader, previewInfo);
                                    super.paint(g);
                                }
                                finally {
                                    FormLAF.setUsePreviewDefaults(null, null);
                                }
                            }
                        };
                        JLayeredPane oldPane = rootPane.getLayeredPane();
                        Component[] comps = oldPane.getComponents();
                        for (int i = 0; i < comps.length; ++i) {
                            newPane.add(comps[i], (Object)oldPane.getLayer(comps[i]));
                        }
                        rootPane.setLayeredPane(newPane);
                        rootPane.getGlassPane().setVisible(true);
                        rootPane.putClientProperty("designPreview", Boolean.TRUE);
                    }
                    return container;
                }
            });
        }
        finally {
            FormLAF.setUsePreviewDefaults(null, null);
            if (defaultLocale != null) {
                Locale.setDefault(defaultLocale);
            }
        }
        return result;
    }

    private static Locale switchToDesignLocale(FormModel formModel) {
        Locale defaultLocale = null;
        String locale = FormEditor.getResourceSupport(formModel).getDesignLocale();
        if (locale != null && !locale.equals("")) {
            String variant;
            int i;
            defaultLocale = Locale.getDefault();
            String[] parts = locale.split("_");
            if ("".equals(parts[i = 0])) {
                ++i;
            }
            String language = i < parts.length ? parts[i++] : null;
            String country = i < parts.length ? parts[i++] : "";
            String string = variant = i < parts.length ? parts[i] : "";
            if (language != null) {
                Locale.setDefault(new Locale(language, country, variant));
            }
        }
        return defaultLocale;
    }

    Component getTopDesignComponentView() {
        return (Component)this.replicator.getClonedComponent(this.topDesignComponent);
    }

    Point pointFromComponentToHandleLayer(Point p, Component sourceComp) {
        Component comp;
        JLayeredPane commonParent = this.layeredPane;
        for (comp = sourceComp; comp != commonParent; comp = comp.getParent()) {
            p.x += comp.getX();
            p.y += comp.getY();
        }
        for (comp = this.handleLayer; comp != commonParent; comp = comp.getParent()) {
            p.x -= comp.getX();
            p.y -= comp.getY();
        }
        return p;
    }

    Point pointFromHandleToComponentLayer(Point p, Component targetComp) {
        Component comp;
        JLayeredPane commonParent = this.layeredPane;
        for (comp = this.handleLayer; comp != commonParent; comp = comp.getParent()) {
            p.x += comp.getX();
            p.y += comp.getY();
        }
        for (comp = targetComp; comp != commonParent; comp = comp.getParent()) {
            p.x -= comp.getX();
            p.y -= comp.getY();
        }
        return p;
    }

    boolean isCoordinatesRoot(Component comp) {
        return this.layeredPane == comp;
    }

    private Rectangle componentBoundsToTop(Component component) {
        if (component == null) {
            return null;
        }
        Component top = this.getTopDesignComponentView();
        int dx = 0;
        int dy = 0;
        if (component != top) {
            for (Container comp = component.getParent(); comp != top && comp != null; comp = comp.getParent()) {
                dx += comp.getX();
                dy += comp.getY();
            }
        } else {
            dx = -top.getX();
            dy = -top.getY();
        }
        Rectangle bounds = component.getBounds();
        bounds.x += dx;
        bounds.y += dy;
        return bounds;
    }

    void setDesignerMode(int mode) {
        boolean prepared;
        PaletteItem pitem;
        this.getFormToolBar().updateDesignerMode(mode);
        if (mode == this.designerMode || !this.initialized) {
            return;
        }
        if (mode == 2 && (pitem = PaletteUtils.getSelectedItem()) != null && FormDesigner.getSelectedDesigner() == this && !(prepared = pitem.prepareComponentInitializer(this.formEditor.getFormDataObject().getPrimaryFile()))) {
            this.toggleSelectionMode();
            return;
        }
        this.designerMode = mode;
        this.resetConnection();
        if (mode == 1) {
            this.clearSelection();
        }
        this.handleLayer.endDragging(null);
        AssistantModel aModel = FormEditor.getAssistantModel(this.formModel);
        switch (mode) {
            case 1: {
                aModel.setContext("connectSource");
                break;
            }
            case 0: {
                aModel.setContext("select");
            }
        }
    }

    public int getDesignerMode() {
        return this.designerMode;
    }

    public void toggleSelectionMode() {
        this.setDesignerMode(0);
        PaletteUtils.clearPaletteSelection();
    }

    void toggleConnectionMode() {
        this.setDesignerMode(1);
        PaletteUtils.clearPaletteSelection();
    }

    void toggleAddMode() {
        this.setDesignerMode(2);
        PaletteUtils.clearPaletteSelection();
    }

    Dimension getDesignerSize() {
        return this.componentLayer.getDesignerSize();
    }

    void setDesignerSize(Dimension size, Dimension oldSize) {
        if (this.topDesignComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)this.topDesignComponent).setDesignerSize(size);
        } else if (this.topDesignComponent != null) {
            if (this.topDesignComponent == this.formModel.getTopRADComponent()) {
                oldSize = (Dimension)this.topDesignComponent.getAuxValue(PROP_DESIGNER_SIZE);
                this.topDesignComponent.setAuxValue(PROP_DESIGNER_SIZE, size);
            }
            if (oldSize == null) {
                oldSize = this.getDesignerSize();
            }
            this.getFormModel().fireSyntheticPropertyChanged(this.topDesignComponent, PROP_DESIGNER_SIZE, oldSize, size);
        }
    }

    void storeDesignerSize(Dimension size) {
        if (this.topDesignComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)this.topDesignComponent).setDesignerSizeImpl(size);
        } else if (this.topDesignComponent == this.formModel.getTopRADComponent()) {
            this.topDesignComponent.setAuxValue(PROP_DESIGNER_SIZE, size);
        }
    }

    private void setupDesignerSize() {
        RADVisualFormContainer formCont;
        if (this.formModel == null) {
            return;
        }
        Dimension size = null;
        RADVisualFormContainer rADVisualFormContainer = formCont = this.topDesignComponent instanceof RADVisualFormContainer ? (RADVisualFormContainer)this.topDesignComponent : null;
        if (formCont == null || formCont.hasExplicitSize() || !RADVisualContainer.isFreeDesignContainer(this.topDesignComponent)) {
            if (formCont != null) {
                size = formCont.getDesignerSize();
            }
            if (size == null) {
                size = (Dimension)this.topDesignComponent.getAuxValue(PROP_DESIGNER_SIZE);
            }
            if (size != null) {
                this.designerSizeExplictlySet = true;
            }
            if (!(size != null || this.formModel.isFreeDesignDefaultLayout() && this.topDesignComponent != this.formModel.getTopRADComponent())) {
                size = new Dimension(400, 300);
            }
        }
        Dimension setSize = this.componentLayer.setDesignerSize(size);
        this.storeDesignerSize(setSize);
    }

    private void checkDesignerSize() {
        if (!(!this.formModel.isFreeDesignDefaultLayout() && !RADVisualContainer.isFreeDesignContainer(this.topDesignComponent) || !(this.topDesignComponent instanceof RADVisualComponent) || this.topDesignComponent instanceof RADVisualFormContainer && ((RADVisualFormContainer)this.topDesignComponent).hasExplicitSize())) {
            Component topComp = this.getTopDesignComponentView();
            Component topCont = null;
            if (this.topDesignComponent instanceof RADVisualContainer) {
                topCont = ((RADVisualContainer)this.topDesignComponent).getContainerDelegate(topComp);
            }
            if (topCont == null) {
                topCont = topComp;
            }
            if (FormDesigner.shouldAdjustDesignerSize(topCont)) {
                int wDiff = topComp.getWidth() - topCont.getWidth();
                int hDiff = topComp.getHeight() - topCont.getHeight();
                Dimension designerSize = new Dimension(this.getDesignerSize());
                designerSize.width -= wDiff;
                designerSize.height -= hDiff;
                boolean corrected = false;
                if (this.layoutDesigner != null && this.layoutDesigner.isPreferredSizeChanged() && FormDesigner.shouldHonorDesignerPrefSize(topCont)) {
                    Dimension prefSize = topCont.getPreferredSize();
                    if (designerSize.width != prefSize.width) {
                        designerSize.width = prefSize.width;
                        corrected = true;
                    }
                    if (designerSize.height != prefSize.height) {
                        designerSize.height = prefSize.height;
                        corrected = true;
                    }
                } else {
                    Dimension minSize = topCont.getMinimumSize();
                    if (designerSize.width < minSize.width) {
                        designerSize.width = minSize.width;
                        corrected = true;
                    }
                    if (designerSize.height < minSize.height) {
                        designerSize.height = minSize.height;
                        corrected = true;
                    }
                }
                if (corrected) {
                    if (FormDesigner.shouldHonorDesignerMinSize(topCont, this.designerSizeExplictlySet)) {
                        designerSize.width += wDiff;
                        designerSize.height += hDiff;
                        if (this.formModel.isCompoundEditInProgress()) {
                            FormModelEvent ev = new FormModelEvent(this.formModel, 11);
                            ev.setComponentAndContainer(this.topDesignComponent, null);
                            ev.setProperty(PROP_DESIGNER_SIZE, this.getDesignerSize(), designerSize);
                            this.formModel.addUndoableEdit(ev.getUndoableEdit());
                        }
                        this.componentLayer.setDesignerSize(designerSize);
                        this.storeDesignerSize(designerSize);
                    }
                } else {
                    this.designerSizeExplictlySet = false;
                }
            }
        }
    }

    private static boolean shouldAdjustDesignerSize(Component topComp) {
        LayoutManager lm;
        return !(topComp instanceof Container) || (lm = ((Container)topComp).getLayout()) != null && !(lm instanceof AbsoluteLayout);
    }

    private static boolean shouldHonorDesignerPrefSize(Component topComp) {
        return !(topComp instanceof Container) || !(((Container)topComp).getLayout() instanceof FlowLayout);
    }

    private static boolean shouldHonorDesignerMinSize(Component topComp, boolean sizeSetExplicitly) {
        return !sizeSetExplicitly || !(topComp instanceof Container) || !(((Container)topComp).getLayout() instanceof FlowLayout);
    }

    public List<RADComponent> getSelectedComponents() {
        return this.selectedComponents;
    }

    List<RADVisualComponent> getSelectedLayoutComponents() {
        return this.selectedLayoutComponents;
    }

    boolean isComponentSelected(RADComponent metacomp) {
        return this.selectedComponents.contains(metacomp);
    }

    public void setSelectedComponent(RADComponent metacomp) {
        if (this.selectedComponents.size() == 1 && this.selectedComponents.contains(metacomp)) {
            return;
        }
        this.clearSelectionImpl();
        this.addComponentToSelectionImpl(metacomp);
        this.repaintSelection();
        this.syncNodesFromComponents();
    }

    public void setSelectedComponents(RADComponent[] metacomps) {
        this.clearSelectionImpl();
        for (int i = 0; i < metacomps.length; ++i) {
            this.addComponentToSelectionImpl(metacomps[i]);
        }
        this.repaintSelection();
        this.syncNodesFromComponents();
    }

    public void addComponentToSelection(RADComponent metacomp) {
        this.addComponentToSelectionImpl(metacomp);
        this.repaintSelection();
        this.syncNodesFromComponents();
    }

    void addComponentsToSelection(RADComponent[] metacomps) {
        for (int i = 0; i < metacomps.length; ++i) {
            this.addComponentToSelectionImpl(metacomps[i]);
        }
        this.repaintSelection();
        this.syncNodesFromComponents();
    }

    public void removeComponentFromSelection(RADComponent metacomp) {
        this.removeComponentFromSelectionImpl(metacomp);
        this.repaintSelection();
        this.syncNodesFromComponents();
    }

    public void clearSelection() {
        this.clearSelectionImpl();
        this.repaintSelection();
        this.syncNodesFromComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncNodesFromComponents() {
        if (this.synchronizingSelection) {
            return;
        }
        ArrayList<RADComponentNode> nodes = new ArrayList<RADComponentNode>(this.selectedComponents.size());
        for (RADComponent c : this.selectedComponents) {
            if (c.getNodeReference() == null) continue;
            nodes.add(c.getNodeReference());
        }
        try {
            this.synchronizingSelection = true;
            this.setSelectedNodes(nodes.toArray(new Node[0]));
        }
        finally {
            this.synchronizingSelection = false;
        }
    }

    void addComponentToSelectionImpl(RADComponent metacomp) {
        if (metacomp != null) {
            this.selectedComponents.add(metacomp);
            RADVisualComponent layoutComponent = this.componentToLayoutComponent(metacomp);
            if (layoutComponent != null) {
                this.selectedLayoutComponents.add(layoutComponent);
                this.ensureComponentIsShown((RADVisualComponent)metacomp);
                this.selectionChanged();
            }
        }
    }

    void removeComponentFromSelectionImpl(RADComponent metacomp) {
        this.selectedComponents.remove(metacomp);
        RADVisualComponent layoutComponent = this.componentToLayoutComponent(metacomp);
        if (layoutComponent != null) {
            this.selectedLayoutComponents.remove(layoutComponent);
        }
        this.selectionChanged();
    }

    void clearSelectionImpl() {
        this.selectedComponents.clear();
        this.selectedLayoutComponents.clear();
        this.selectionChanged();
    }

    ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Node[] getSelectedNodes() {
        return this.explorerManager.getSelectedNodes();
    }

    void setSelectedNodes(Node ... nodes) {
        try {
            this.explorerManager.setSelectedNodes(nodes);
        }
        catch (PropertyVetoException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncComponentsFromNodes() {
        if (this.synchronizingSelection) {
            return;
        }
        Node[] nodes = this.getSelectedNodes();
        ArrayList<RADComponent> components = new ArrayList<RADComponent>(nodes.length);
        for (Node n : nodes) {
            Node node;
            FormCookie formCookie = (FormCookie)n.getCookie(FormCookie.class);
            if (formCookie == null || !((node = formCookie.getOriginalNode()) instanceof RADComponentNode)) continue;
            components.add(((RADComponentNode)node).getRADComponent());
        }
        try {
            this.synchronizingSelection = true;
            this.setSelectedComponents(components.toArray(new RADComponent[0]));
        }
        finally {
            this.synchronizingSelection = false;
        }
    }

    private void selectionChanged() {
        if (this.formModel == null) {
            return;
        }
        this.updateLayoutDesigner();
        this.updateResizabilityActions();
        this.updateAssistantContext();
    }

    private void repaintSelection() {
        if (this.handleLayer != null) {
            this.handleLayer.repaint();
        }
    }

    private void updateLayoutDesigner() {
        boolean enabled;
        if (this.layoutDesigner != null) {
            Collection<String> selectedIds = this.selectedLayoutComponentIds();
            enabled = this.layoutDesigner.canAlign(selectedIds);
            selectedIds = this.getSelectedComponentsForLayoutDesigner(selectedIds);
            this.layoutDesigner.setSelectedComponents(selectedIds.toArray(new String[0]));
        } else {
            enabled = false;
        }
        for (Action action : this.getDesignerActions(true)) {
            action.setEnabled(enabled);
        }
    }

    private Collection<String> getSelectedComponentsForLayoutDesigner(Collection<String> selectedIds) {
        for (RADComponent rADComponent : this.getSelectedLayoutComponents()) {
            RADVisualComponent subcomp = FormDesigner.substituteWithSubComponent((RADVisualComponent)rADComponent);
            if (subcomp == rADComponent || !(subcomp instanceof RADVisualContainer) || ((RADVisualContainer)subcomp).getLayoutSupport() != null) continue;
            selectedIds.add(subcomp.getId());
        }
        return selectedIds;
    }

    public void updateResizabilityActions() {
        Collection<String> componentIds = this.componentIds();
        Action[] actions = this.getResizabilityActions();
        RADVisualComponent top = this.getTopDesignComponent();
        if (top == null || componentIds.contains(top.getId())) {
            for (Action a : actions) {
                a.setEnabled(false);
            }
            return;
        }
        LayoutModel layoutModel = this.getFormModel().getLayoutModel();
        LayoutDesigner layoutDesigner = this.getLayoutDesigner();
        Iterator<String> iter = componentIds.iterator();
        boolean[] resizable = new boolean[2];
        boolean[] nonResizable = new boolean[2];
        while (iter.hasNext()) {
            String id = iter.next();
            LayoutComponent comp = layoutModel.getLayoutComponent(id);
            for (int i = 0; i < 2; ++i) {
                if (layoutDesigner.isComponentResizing(comp, i == 0 ? 0 : 1)) {
                    resizable[i] = true;
                    continue;
                }
                nonResizable[i] = true;
            }
        }
        for (int i = 0; i < 2; ++i) {
            boolean match = resizable[i];
            boolean miss = nonResizable[i];
            actions[i].putValue("SwingSelectedKey", !miss && match);
            actions[i].setEnabled(match || miss);
        }
    }

    private void updateAssistantContext() {
        String context = null;
        String additionalCtx = null;
        List<RADComponent> selComps = this.getSelectedComponents();
        int selCount = selComps.size();
        if (selCount > 0) {
            RADComponent metacomp = selComps.get(0);
            if (this.layoutDesigner != null && this.layoutDesigner.isUnplacedComponent(metacomp.getId())) {
                if (selCount > 1) {
                    ArrayList<String> ids = new ArrayList<String>(selCount);
                    for (RADComponent c : selComps) {
                        ids.add(c.getId());
                    }
                    if (this.layoutDesigner.getDraggableComponents(ids).size() == selCount) {
                        context = "unplacedComponents1";
                        additionalCtx = "unplacedComponents2";
                    }
                } else {
                    context = "unplacedComponent1";
                    additionalCtx = "unplacedComponent2";
                }
            }
            if (selCount == 1 && context == null) {
                Object bean = metacomp.getBeanInstance();
                if (bean instanceof JTabbedPane) {
                    JTabbedPane pane = (JTabbedPane)bean;
                    int count = pane.getTabCount();
                    switch (count) {
                        case 0: {
                            context = "tabbedPaneEmpty";
                            break;
                        }
                        case 1: {
                            context = "tabbedPaneOne";
                            break;
                        }
                        default: {
                            context = "tabbedPane";
                            break;
                        }
                    }
                } else if (bean instanceof JRadioButton) {
                    Node.Property property = metacomp.getPropertyByName("buttonGroup");
                    try {
                        if (property != null && property.getValue() == null) {
                            context = "buttonGroup";
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
                    }
                } else if (bean instanceof JPanel && this.getTopDesignComponent() != metacomp && Math.random() < 0.2) {
                    context = "designThisContainer";
                } else if (bean instanceof JComboBox && Math.random() < 0.4) {
                    context = "comboBoxModel";
                } else if (bean instanceof JList && Math.random() < 0.4) {
                    context = "listModel";
                } else if (bean instanceof JTable && Math.random() < 0.4) {
                    context = "tableModel";
                } else if (bean instanceof JScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)bean;
                    if (scrollPane.getViewport() != null && scrollPane.getViewport().getView() == null) {
                        context = "scrollPaneEmpty";
                    } else if (Math.random() < 0.5) {
                        context = "scrollPane";
                    }
                }
            }
        }
        if (context == null) {
            context = "select";
        }
        FormEditor.getAssistantModel(this.formModel).setContext(context, additionalCtx);
    }

    RADVisualComponent componentToLayoutComponent(RADComponent metacomp) {
        RADVisualComponent visualComp;
        if (metacomp instanceof RADVisualComponent && !(visualComp = (RADVisualComponent)metacomp).isMenuComponent()) {
            RADVisualComponent subst = this.substituteWithContainer(visualComp);
            if (subst != null) {
                return subst;
            }
            return this.isInDesigner(visualComp) ? visualComp : null;
        }
        return null;
    }

    RADVisualComponent substituteWithContainer(RADVisualComponent metacomp) {
        RADVisualContainer metacont;
        if (metacomp != null && FormDesigner.isTransparentContainer(metacont = metacomp.getParentContainer()) && metacont.getParentContainer() != null && this.isInDesigner(metacont)) {
            return metacont;
        }
        return metacomp;
    }

    static RADVisualComponent substituteWithSubComponent(RADVisualComponent metacont) {
        if (FormDesigner.isTransparentContainer(metacont)) {
            return ((RADVisualContainer)metacont).getSubComponents()[0];
        }
        return metacont;
    }

    static boolean isTransparentContainer(RADVisualComponent metacont) {
        return metacont instanceof RADVisualContainer && metacont.getBeanClass().isAssignableFrom(JScrollPane.class) && ((RADVisualContainer)metacont).hasVisualSubComponents();
    }

    RADComponent getNextVisualComponent(boolean forward) {
        RADComponent currentComp = null;
        int n = this.selectedComponents.size();
        if (n > 0) {
            if (n > 1) {
                return null;
            }
            RADComponent sel = this.selectedComponents.get(0);
            if (sel instanceof RADVisualComponent) {
                currentComp = sel;
            } else {
                return null;
            }
        }
        return this.getNextVisualComponent(currentComp, forward);
    }

    RADComponent getNextVisualComponent(RADComponent comp, boolean forward) {
        RADComponent[] subComps;
        if (comp == null) {
            return this.topDesignComponent;
        }
        if (this.getComponent(comp) == null) {
            return null;
        }
        if (forward) {
            RADComponent[] subComps2 = this.getVisualSubComponents(comp);
            if (subComps2.length > 0) {
                return subComps2[0];
            }
            if (comp == this.topDesignComponent) {
                return this.topDesignComponent;
            }
            RADVisualContainer cont = (RADVisualContainer)comp.getParentComponent();
            if (cont == null) {
                return null;
            }
            int i = cont.getIndexOf(comp);
            while (i >= 0) {
                subComps2 = cont.getSubComponents();
                if (i + 1 < subComps2.length) {
                    return subComps2[i + 1];
                }
                if (cont == this.topDesignComponent) break;
                comp = cont;
                if ((cont = (RADVisualContainer)comp.getParentComponent()) == null) {
                    return null;
                }
                i = cont.getIndexOf(comp);
            }
            return this.topDesignComponent;
        }
        if (comp != this.topDesignComponent) {
            RADVisualContainer cont = (RADVisualContainer)comp.getParentComponent();
            if (cont == null) {
                return null;
            }
            int i = cont.getIndexOf(comp);
            if (i >= 0) {
                if (i == 0) {
                    return cont;
                }
                subComps = cont.getSubComponents();
                comp = subComps[i - 1];
            } else {
                comp = this.topDesignComponent;
            }
        }
        while ((subComps = this.getVisualSubComponents(comp)).length > 0) {
            comp = subComps[subComps.length - 1];
        }
        return comp;
    }

    private RADComponent[] getVisualSubComponents(RADComponent metacomp) {
        return metacomp instanceof RADVisualContainer ? ((RADVisualContainer)metacomp).getSubComponents() : new RADComponent[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void align(boolean closed, int dimension, int alignment) {
        Action action = null;
        for (Action candidate : this.getDesignerActions(true)) {
            AlignAction alignCandidate;
            if (!(candidate instanceof AlignAction) || (alignCandidate = (AlignAction)candidate).getAlignment() != alignment || alignCandidate.getDimension() != dimension) continue;
            action = alignCandidate;
            break;
        }
        if (action == null || !action.isEnabled()) {
            return;
        }
        Collection<String> selectedIds = this.selectedLayoutComponentIds();
        RADComponent parent = this.commonParent(selectedIds);
        LayoutModel layoutModel = this.formModel.getLayoutModel();
        Object layoutUndoMark = layoutModel.getChangeMark();
        UndoableEdit ue = layoutModel.getUndoableEdit();
        boolean autoUndo = true;
        try {
            this.getLayoutDesigner().align(selectedIds, closed, dimension, alignment);
            autoUndo = false;
        }
        finally {
            this.formModel.fireContainerLayoutChanged((RADVisualContainer)parent, null, null, null);
            if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                this.formModel.addUndoableEdit(ue);
            }
            if (autoUndo) {
                this.formModel.forceUndoOfCompoundEdit();
            }
        }
    }

    public Collection<Action> getDesignerActions(boolean forToolbar) {
        if (this.designerActions == null) {
            this.designerActions = new LinkedList<Action>();
            this.designerActions.add(new AlignAction(0, 0, true));
            this.designerActions.add(new AlignAction(0, 1, true));
            this.designerActions.add(new AlignAction(0, 2, true));
            this.designerActions.add(new AlignAction(1, 0, true));
            this.designerActions.add(new AlignAction(1, 1, true));
            this.designerActions.add(new AlignAction(1, 2, true));
            this.designerActions.add(new AlignAction(0, 0, false));
            this.designerActions.add(new AlignAction(0, 1, false));
            this.designerActions.add(new AlignAction(1, 0, false));
            this.designerActions.add(new AlignAction(1, 1, false));
        }
        return forToolbar ? this.designerActions.subList(0, 6) : this.designerActions;
    }

    public Action[] getResizabilityActions() {
        if (this.resizabilityActions == null) {
            this.resizabilityActions = new Action[]{new ResizabilityAction(0), new ResizabilityAction(1)};
        }
        return this.resizabilityActions;
    }

    Collection<String> selectedLayoutComponentIds() {
        Iterator<RADVisualComponent> metacomps = this.getSelectedLayoutComponents().iterator();
        LinkedList<String> selectedIds = new LinkedList<String>();
        while (metacomps.hasNext()) {
            RADComponent metacomp = metacomps.next();
            selectedIds.add(metacomp.getId());
        }
        return selectedIds;
    }

    private RADComponent commonParent(Collection compIds) {
        RADComponent parent = null;
        Iterator iter = compIds.iterator();
        FormModel formModel = this.getFormModel();
        while (iter.hasNext()) {
            String compId = (String)iter.next();
            RADComponent metacomp = formModel.getMetaComponent(compId);
            RADComponent metacont = metacomp.getParentComponent();
            if (parent == null) {
                parent = metacont;
            }
            if (metacont != null && parent == metacont) continue;
            return null;
        }
        return parent;
    }

    void updateVisualSettings() {
        this.componentLayer.updateVisualSettings();
        if (this.nonVisualTray != null) {
            this.nonVisualTray.updateVisualSettings();
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private void ensureComponentIsShown(RADVisualComponent metacomp) {
        Component comp = (Component)this.getComponent(metacomp);
        if (comp == null) {
            return;
        }
        if (comp.isShowing() || !this.isInDesigner(metacomp) || metacomp == this.topDesignComponent) {
            return;
        }
        Component topComp = this.getTopDesignComponentView();
        if (topComp == null || !topComp.isShowing()) {
            return;
        }
        RADVisualComponent child = metacomp;
        for (RADVisualContainer metacont = metacomp.getParentContainer(); metacont != null; metacont = metacont.getParentContainer()) {
            Container cont = (Container)this.getComponent(metacont);
            LayoutSupportManager laysup = metacont.getLayoutSupport();
            if (laysup != null) {
                Container contDelegate = metacont.getContainerDelegate(cont);
                laysup.selectComponent(child.getComponentIndex());
                laysup.arrangeContainer(cont, contDelegate);
            }
            if (metacont == this.topDesignComponent || cont.isShowing()) break;
            child = metacont;
        }
    }

    private void connectBean(RADComponent metacomp, boolean showDialog) {
        if (this.connectionSource == null) {
            this.connectionSource = metacomp;
            FormEditor.getAssistantModel(this.formModel).setContext("connectTarget");
            this.handleLayer.repaint();
        } else {
            if (metacomp == this.connectionSource) {
                if (this.connectionTarget != null) {
                    this.resetConnection();
                    this.toggleSelectionMode();
                }
                return;
            }
            this.connectionTarget = metacomp;
            this.handleLayer.repaint();
            if (showDialog) {
                if (this.connectionTarget != null) {
                    FormEditor.getAssistantModel(this.formModel).setContext("connectWizard");
                    this.createConnection(this.connectionSource, this.connectionTarget);
                }
                this.toggleSelectionMode();
            }
        }
    }

    public RADComponent getConnectionSource() {
        return this.connectionSource;
    }

    public RADComponent getConnectionTarget() {
        return this.connectionTarget;
    }

    public void resetConnection() {
        if (this.connectionSource != null || this.connectionTarget != null) {
            this.connectionSource = null;
            this.connectionTarget = null;
            this.handleLayer.repaint();
        }
    }

    private void createConnection(RADComponent source, RADComponent target) {
        ConnectionWizard cw = new ConnectionWizard(this.formModel, source, target);
        if (cw.show()) {
            final Event event = cw.getSelectedEvent();
            final String eventName = cw.getEventName();
            String bodyText = cw.getGeneratedCode();
            this.formModel.getFormEvents().attachEvent(event, eventName, bodyText);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormDesigner.this.formModel.getFormEvents().attachEvent(event, eventName, null);
                }
            });
        }
    }

    public void startInPlaceEditing(RADComponent metacomp) {
        if (this.formModel.isReadOnly()) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            return;
        }
        if (!this.isEditableInPlace(metacomp)) {
            return;
        }
        Component comp = (Component)this.getComponent(metacomp);
        if (comp == null) {
            this.notifyCannotEditInPlace();
            return;
        }
        FormProperty property = null;
        if (JTabbedPane.class.isAssignableFrom(metacomp.getBeanClass())) {
            JTabbedPane tabbedPane = (JTabbedPane)comp;
            int index = tabbedPane.getSelectedIndex();
            RADVisualContainer metacont = (RADVisualContainer)metacomp;
            RADVisualComponent tabComp = metacont.getSubComponent(index);
            Node.Property[] props = tabComp.getConstraintsProperties();
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].getName().equals("TabConstraints.tabTitle")) continue;
                if (props[i] instanceof FormProperty) {
                    property = (FormProperty)props[i];
                    continue;
                }
                return;
            }
            if (property == null) {
                return;
            }
        } else {
            property = metacomp.getBeanProperty("text");
            if (property == null) {
                return;
            }
        }
        String editText = null;
        try {
            Object text = property.getRealValue();
            if (!(text instanceof String)) {
                text = "";
            }
            editText = (String)text;
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            return;
        }
        this.editedProperty = property;
        this.getInPlaceEditLayer();
        try {
            this.textEditLayer.setEditedComponent(comp, editText);
        }
        catch (IllegalArgumentException ex) {
            this.notifyCannotEditInPlace();
            return;
        }
        this.textEditLayer.setVisible(true);
        this.handleLayer.setVisible(false);
        this.textEditLayer.requestFocus();
    }

    private InPlaceEditLayer.FinishListener getFinnishListener() {
        if (this.finnishListener == null) {
            this.finnishListener = new InPlaceEditLayer.FinishListener(){

                @Override
                public void editingFinished(boolean textChanged) {
                    FormDesigner.this.finishInPlaceEditing(FormDesigner.this.textEditLayer.isTextChanged());
                }
            };
        }
        return this.finnishListener;
    }

    private void finishInPlaceEditing(boolean applyChanges) {
        if (applyChanges) {
            try {
                Object value = this.editedProperty.getValue();
                if (value instanceof String) {
                    this.editedProperty.setValue(this.textEditLayer.getEditedText());
                } else {
                    PropertyEditor prEd = this.editedProperty.findDefaultEditor();
                    this.editedProperty.setValue(new FormProperty.ValueWithEditor(this.textEditLayer.getEditedText(), prEd));
                }
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
        if (this.handleLayer != null) {
            this.textEditLayer.setVisible(false);
            this.handleLayer.setVisible(true);
            this.handleLayer.requestFocus();
        }
        this.editedProperty = null;
    }

    public boolean isEditableInPlace(RADComponent metacomp) {
        if (metacomp == null) {
            return false;
        }
        Object comp = this.getComponent(metacomp);
        if (!(comp instanceof Component)) {
            return false;
        }
        for (RADComponent parent = metacomp.getParentComponent(); parent != null; parent = parent.getParentComponent()) {
            if (JComponent.class.isAssignableFrom(parent.getBeanClass()) || RootPaneContainer.class.isAssignableFrom(parent.getBeanClass())) continue;
            return false;
        }
        Class<? extends Object> beanClass = metacomp.getBeanClass();
        if (!InPlaceEditLayer.supportsEditingFor(beanClass, false)) {
            return false;
        }
        if (JTabbedPane.class.isAssignableFrom(beanClass)) {
            RADVisualContainer metacont;
            if (metacomp instanceof RADVisualContainer && (metacont = (RADVisualContainer)metacomp).getLayoutSupport() != null && metacont.getLayoutSupport().isDedicated()) {
                int tabCount = ((JTabbedPane)comp).getTabCount();
                return tabCount > 0 && tabCount == metacont.getSubComponents().length;
            }
            return false;
        }
        return true;
    }

    private void notifyCannotEditInPlace() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_ComponentNotShown"), 2));
    }

    public void openMenu(RADComponent metacomp) {
        MenuEditLayer menuEditLayer = this.getMenuEditLayer();
        Component comp = (Component)this.getComponent(metacomp);
        menuEditLayer.setVisible(true);
        menuEditLayer.openAndShowMenu(metacomp, comp);
    }

    public static void setSelectedDesigner(FormDesigner designer, boolean select) {
        if (select) {
            selectedDesigner = designer;
            FormEditor formEditor = designer.getFormEditor();
            formEditor.setFormDesigner(designer);
            ComponentInspector.getInstance().setFormDesigner(designer);
            PaletteUtils.setContext(formEditor.getFormDataObject().getPrimaryFile());
            if (designer.layoutDesigner != null) {
                designer.layoutDesigner.setActive(true);
            }
        } else if (selectedDesigner == designer) {
            selectedDesigner = null;
            ComponentInspector.getInstance().setFormDesigner(null);
            PaletteUtils.setContext(null);
        }
        FormDesigner.updateTestAction();
    }

    public static FormDesigner getSelectedDesigner() {
        return selectedDesigner;
    }

    public JComponent getDesignCanvas() {
        return this.canvasRoot;
    }

    public void componentActivated() {
        if (!this.active) {
            this.active = true;
            FormDesigner.setSelectedDesigner(this, true);
            ComponentInspector.getInstance().attachActions();
            this.getToolBar().putClientProperty("isActive", Boolean.TRUE);
        }
        if (!(this.formModel == null || this.textEditLayer != null && this.textEditLayer.isVisible())) {
            this.handleLayer.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.active = false;
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            this.textEditLayer.finishEditing(false);
        }
        this.resetConnection();
        this.getToolBar().putClientProperty("isActive", Boolean.FALSE);
    }

    public void requestActive() {
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.canvasRoot);
        if (tc != null) {
            tc.requestActive();
        }
    }

    public void componentShowing() {
        if (this.formEditor.isFormLoaded()) {
            this.initialize();
        }
    }

    public void componentHidden() {
        this.active = false;
        ComponentInspector.getInstance().detachActions();
        if (this.getDesignerMode() == 1 && this.formModel != null) {
            this.clearSelection();
        }
    }

    public void loadingComplete() {
        this.initialize();
        RADComponent topMetacomp = this.formModel.getTopRADComponent();
        if (topMetacomp != null) {
            this.setSelectedComponent(topMetacomp);
        } else {
            this.setSelectedNodes(new Node[]{this.formEditor.getFormRootNode()});
        }
        if (this.active) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FormDesigner.this.active && FormDesigner.this.handleLayer != null) {
                        FormDesigner.this.handleLayer.requestFocus();
                    }
                }
            });
        }
    }

    public InPlaceEditLayer getInPlaceEditLayer() {
        if (this.textEditLayer == null) {
            this.textEditLayer = new InPlaceEditLayer();
            this.textEditLayer.setVisible(false);
            this.textEditLayer.addFinishListener(this.getFinnishListener());
            this.layeredPane.add((Component)this.textEditLayer, (Object)2001);
        }
        return this.textEditLayer;
    }

    MenuEditLayer getMenuEditLayer() {
        if (this.menuEditLayer == null) {
            this.menuEditLayer = new MenuEditLayer(this);
            this.menuEditLayer.setVisible(false);
            this.layeredPane.add((Component)this.menuEditLayer, (Object)2000);
        }
        return this.menuEditLayer;
    }

    private static List<String> collectRootLayoutSubComponents(RADVisualContainer metacont, List<String> list) {
        for (RADVisualComponent sub : metacont.getSubComponents()) {
            if (!(sub instanceof RADVisualContainer)) continue;
            RADVisualContainer subcont = (RADVisualContainer)sub;
            if (subcont.getLayoutSupport() == null) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(subcont.getId());
                continue;
            }
            list = FormDesigner.collectRootLayoutSubComponents(subcont, list);
        }
        return list;
    }

    private Collection<String> componentIds() {
        LinkedList<String> componentIds = new LinkedList<String>();
        List<RADVisualComponent> selectedComps = this.getSelectedLayoutComponents();
        LayoutModel layoutModel = this.getFormModel().getLayoutModel();
        for (RADVisualComponent visualComp : selectedComps) {
            if (visualComp.getParentContainer() == null || visualComp.getParentLayoutSupport() != null || layoutModel.getLayoutComponent(visualComp.getId()) == null) continue;
            componentIds.add(visualComp.getId());
        }
        return componentIds;
    }

    private class NodeSelectionListener
    implements PropertyChangeListener {
        private NodeSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                FormDesigner.this.syncComponentsFromNodes();
                Node[] selectedNodes = FormDesigner.this.getSelectedNodes();
                FormDesigner.this.switchNodeInLookup(selectedNodes.length == 0 && FormDesigner.this.formEditor.getFormDataObject().isValid());
                FormDesigner.this.firePropertyChange("selectedNodes", evt.getOldValue(), evt.getNewValue());
                if (FormDesigner.this.getDesignerMode() == 1 && selectedNodes.length > 0) {
                    RADComponentCookie cookie = (RADComponentCookie)selectedNodes[0].getCookie(RADComponentCookie.class);
                    if (cookie != null && cookie.getRADComponent() == FormDesigner.this.getConnectionSource() && selectedNodes.length > 1) {
                        cookie = (RADComponentCookie)selectedNodes[selectedNodes.length - 1].getCookie(RADComponentCookie.class);
                    }
                    if (cookie != null) {
                        FormDesigner.this.connectBean(cookie.getRADComponent(), true);
                    }
                }
            }
        }
    }

    private class FormListener
    implements FormModelListener,
    Runnable {
        private FormModelEvent[] events;

        private FormListener() {
        }

        @Override
        public void formChanged(final FormModelEvent[] events) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormListener.this.processEvents(events);
                    }
                });
            } else {
                this.processEvents(events);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvents(FormModelEvent[] events) {
            boolean lafBlock;
            if (events == null) {
                lafBlock = true;
            } else {
                lafBlock = false;
                boolean modifying = false;
                for (int i = 0; i < events.length; ++i) {
                    FormModelEvent ev = events[i];
                    if (ev.isModifying()) {
                        modifying = true;
                    }
                    if (ev.getChangeType() != 7 && ev.getChangeType() != 10 && ev.getChangeType() != 16) continue;
                    lafBlock = true;
                    break;
                }
                if (!modifying) {
                    return;
                }
                assert (EventQueue.isDispatchThread());
            }
            this.events = events;
            if (lafBlock) {
                Locale defaultLocale = FormDesigner.switchToDesignLocale(FormDesigner.this.getFormModel());
                try {
                    FormLAF.executeWithLookAndFeel(FormDesigner.this.formModel, this);
                }
                finally {
                    if (defaultLocale != null) {
                        Locale.setDefault(defaultLocale);
                    }
                }
            } else {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.events == null) {
                Component originalVisualComp = FormDesigner.this.getTopDesignComponentView();
                final Dimension originalSize = originalVisualComp instanceof Component ? originalVisualComp.getSize() : null;
                FormDesigner.this.replicator.setTopMetaComponent(FormDesigner.this.topDesignComponent);
                Component formClone = (Component)FormDesigner.this.replicator.createClone();
                if (formClone != null) {
                    formClone.setVisible(true);
                    FormDesigner.this.componentLayer.setTopDesignComponent(formClone);
                    if (originalSize != null) {
                        FormDesigner.this.componentLayer.setDesignerSize(originalSize);
                        FormDesigner.this.checkDesignerSize();
                    } else {
                        FormDesigner.this.setupDesignerSize();
                    }
                    if (FormDesigner.this.getLayoutDesigner() != null) {
                        FormDesigner.this.getLayoutDesigner().externalSizeChangeHappened();
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (originalSize == null) {
                                FormDesigner.this.setupDesignerSize();
                            }
                            FormDesigner.this.updateComponentLayer(false);
                        }
                    });
                }
                return;
            }
            FormModelEvent[] events = this.sortEvents(this.events);
            this.events = null;
            int prevType = 0;
            ComponentContainer prevContainer = null;
            boolean updateDone = false;
            boolean updateLayoutDesignerSelection = false;
            boolean structureChanged = false;
            for (int i = 0; i < events.length; ++i) {
                FormModelEvent ev = events[i];
                int type = ev.getChangeType();
                ComponentContainer metacont = ev.getContainer();
                if (type == 4 || type == 5 || type == 6) {
                    RADVisualContainer visualMetaCont = (RADVisualContainer)metacont;
                    if (prevType != 4 && prevType != 5 && prevType != 6 || prevContainer != metacont) {
                        FormDesigner.this.replicator.updateContainerLayout(visualMetaCont);
                        updateDone = true;
                    }
                    if (type == 4 && visualMetaCont.getLayoutSupport() == null && FormDesigner.this.getSelectedComponents().contains(visualMetaCont)) {
                        updateLayoutDesignerSelection = true;
                    }
                    structureChanged = true;
                } else if (type == 7) {
                    if ((metacont instanceof RADVisualContainer || metacont instanceof RADMenuComponent) && (prevType != 7 || prevContainer != metacont)) {
                        FormDesigner.this.replicator.updateAddedComponents(metacont);
                        updateDone = true;
                    }
                } else if (type == 8) {
                    RADComponent removed = ev.getComponent();
                    if (removed instanceof RADVisualComponent && (removed == FormDesigner.this.topDesignComponent || removed.isParentComponent(FormDesigner.this.topDesignComponent))) {
                        FormDesigner.this.resetTopDesignComponent(false);
                        FormDesigner.this.updateWholeDesigner();
                        return;
                    }
                    FormDesigner.this.replicator.removeComponent(ev.getComponent(), ev.getContainer());
                    updateDone = true;
                    structureChanged = true;
                } else if (type == 9) {
                    if (prevType != 9 || prevContainer != metacont) {
                        FormDesigner.this.replicator.reorderComponents(metacont);
                        updateDone = true;
                    }
                } else if (type == 10) {
                    RADProperty eventProperty = ev.getComponentProperty();
                    RADComponent eventComponent = ev.getComponent();
                    if (eventProperty != null) {
                        FormDesigner.this.replicator.updateComponentProperty(eventProperty);
                        this.updateConnectedProperties(eventProperty, eventComponent);
                        if (FormDesigner.this.layoutDesigner != null && FormDesigner.this.formModel.isCompoundEditInProgress()) {
                            FormDesigner.this.layoutDesigner.componentDefaultSizeChanged(eventComponent.getId());
                        }
                    }
                    updateDone = true;
                } else if (type == 16) {
                    if (ev.getSubPropertyName() == null) {
                        FormDesigner.this.replicator.updateBinding(ev.getNewBinding());
                    }
                    updateDone = true;
                } else if (type == 11 && FormDesigner.PROP_DESIGNER_SIZE.equals(ev.getPropertyName())) {
                    Dimension size = (Dimension)ev.getNewPropertyValue();
                    if (size == null) {
                        size = (Dimension)FormDesigner.this.topDesignComponent.getAuxValue(FormDesigner.PROP_DESIGNER_SIZE);
                    }
                    FormDesigner.this.componentLayer.setDesignerSize(size);
                    FormDesigner.this.designerSizeExplictlySet = true;
                    updateDone = true;
                }
                prevType = type;
                prevContainer = metacont;
            }
            if (updateDone) {
                FormDesigner.this.checkDesignerSize();
                LayoutDesigner layoutDesigner = FormDesigner.this.getLayoutDesigner();
                if (layoutDesigner != null && FormDesigner.this.formModel.isCompoundEditInProgress()) {
                    FormDesigner.this.getLayoutDesigner().externalSizeChangeHappened();
                }
                FormDesigner.this.updateComponentLayer(true);
                if (updateLayoutDesignerSelection) {
                    FormDesigner.this.updateLayoutDesigner();
                }
                if (structureChanged) {
                    if (FormDesigner.this.getDesignerMode() != 0) {
                        FormDesigner.this.toggleSelectionMode();
                    } else {
                        FormDesigner.this.handleLayer.endDragging(null);
                    }
                }
            }
        }

        private FormModelEvent[] sortEvents(FormModelEvent[] events) {
            LinkedList<FormModelEvent> l = new LinkedList<FormModelEvent>();
            for (FormModelEvent event : events) {
                l.add(event);
                if (!(event.getContainer() instanceof RADVisualContainer)) continue;
                int i = 0;
                for (int n = l.size() - 1; n > 0; --n) {
                    FormModelEvent e = (FormModelEvent)l.get(i);
                    if (e.getContainer() instanceof RADVisualContainer && this.eventsOrder(e, event) == 0) {
                        l.remove(e);
                        l.add(e);
                        continue;
                    }
                    ++i;
                }
            }
            return l.toArray(new FormModelEvent[0]);
        }

        private int eventsOrder(FormModelEvent e1, FormModelEvent e2) {
            RADVisualContainer cont1 = (RADVisualContainer)e1.getContainer();
            RADVisualContainer cont2 = (RADVisualContainer)e2.getContainer();
            if (e2.getChangeType() == 5 && (cont2 == cont1 || cont2.isParentComponent(cont1))) {
                return 1;
            }
            if (e1.getChangeType() == 5 && (cont1 == cont2 || cont1.isParentComponent(cont2))) {
                return 0;
            }
            return -1;
        }

        private void updateConnectedProperties(RADProperty eventProperty, RADComponent eventComponent) {
            for (RADComponent component : FormDesigner.this.formModel.getAllComponents()) {
                RADProperty[] properties = component.getKnownBeanProperties();
                for (int i = 0; i < properties.length; ++i) {
                    try {
                        RADConnectionPropertyEditor.RADConnectionDesignValue propertyValue;
                        Object value;
                        if (!properties[i].isChanged() || !((value = properties[i].getValue()) instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) || (propertyValue = (RADConnectionPropertyEditor.RADConnectionDesignValue)value).getRADComponent() == null || propertyValue.getProperty() == null || !eventComponent.getName().equals(propertyValue.getRADComponent().getName()) || !eventProperty.getName().equals(propertyValue.getProperty().getName())) continue;
                        FormDesigner.this.replicator.updateComponentProperty(properties[i]);
                        continue;
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        }
    }

    private class LayoutMapper
    implements VisualMapper {
        private LayoutMapper() {
        }

        @Override
        public Rectangle getComponentBounds(String componentId) {
            Component visual = this.getVisualComponent(componentId, true, false);
            if (visual == null) {
                return null;
            }
            Rectangle rect = FormDesigner.this.componentBoundsToTop(visual);
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compBounds.put(\"" + componentId + "\", new Rectangle(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "));");
            }
            return rect;
        }

        @Override
        public Rectangle getContainerInterior(String componentId) {
            Component visual = this.getVisualComponent(componentId, true, false);
            if (visual == null) {
                return null;
            }
            RADVisualContainer metacont = (RADVisualContainer)this.getMetaComponent(componentId);
            Container cont = metacont.getContainerDelegate(visual);
            Rectangle rect = FormDesigner.this.componentBoundsToTop(cont);
            Dimension dim = cont.getMinimumSize();
            if (dim.width > rect.width) {
                rect.width = dim.width;
            }
            if (dim.height > rect.height) {
                rect.height = dim.height;
            }
            Insets insets = cont.getInsets();
            rect.x += insets.left;
            rect.y += insets.top;
            rect.width -= insets.left + insets.right;
            rect.height -= insets.top + insets.bottom;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  contInterior.put(\"" + componentId + "\", new Rectangle(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "));");
            }
            return rect;
        }

        @Override
        public Dimension getComponentMinimumSize(String componentId) {
            Component visual = this.getVisualComponent(componentId, false, false);
            Dimension dim = null;
            if (visual != null) {
                dim = visual.getMinimumSize();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compMinSize.put(\"" + componentId + "\", new Dimension(" + dim.width + ", " + dim.height + "));");
            }
            return dim;
        }

        @Override
        public Dimension getComponentPreferredSize(String componentId) {
            Component visual = this.getVisualComponent(componentId, false, false);
            Dimension dim = null;
            if (visual != null) {
                dim = visual.getPreferredSize();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compPrefSize.put(\"" + componentId + "\", new Dimension(" + dim.width + ", " + dim.height + "));");
            }
            return dim;
        }

        @Override
        public boolean hasExplicitPreferredSize(String componentId) {
            JComponent visual = (JComponent)this.getVisualComponent(componentId, false, true);
            boolean hasExplPrefSize = false;
            if (visual != null) {
                hasExplPrefSize = visual.isPreferredSizeSet();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  hasExplicitPrefSize.put(\"" + componentId + "\", new Boolean(" + hasExplPrefSize + "));");
            }
            return hasExplPrefSize;
        }

        @Override
        public int getBaselinePosition(String componentId, int width, int height) {
            Insets insets;
            int baseLinePos = -1;
            JComponent comp = (JComponent)this.getVisualComponent(componentId, true, true);
            if (comp != null && (comp instanceof JScrollPane || comp.getClass().equals(JPanel.class) || comp instanceof JTabbedPane || comp instanceof AbstractButton && ((AbstractButton)comp).getVerticalTextPosition() != 0 || comp instanceof JLabel && ((JLabel)comp).getVerticalTextPosition() != 0)) {
                baseLinePos = 0;
            }
            if (baseLinePos == -1 && comp != null && height >= 0 && ((insets = comp.getInsets()) == null || height - insets.top - insets.bottom >= 0)) {
                if (width < 0) {
                    width = 0;
                }
                try {
                    baseLinePos = comp.getBaseline(width, height);
                }
                catch (Exception ex) {
                    Logger.getLogger(FormDesigner.class.getName()).log(Level.INFO, null, ex);
                }
            }
            if (baseLinePos == -1) {
                baseLinePos = 0;
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                String id = componentId + "-" + width + "-" + height;
                FormDesigner.this.getLayoutDesigner().testCode.add("  baselinePosition.put(\"" + id + "\", new Integer(" + baseLinePos + "));");
            }
            return baseLinePos;
        }

        @Override
        public int getPreferredPadding(String comp1Id, String comp2Id, int dimension, int comp2Alignment, LayoutConstants.PaddingType paddingType) {
            int prefPadding;
            String id = null;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                id = comp1Id + "-" + comp2Id + "-" + dimension + "-" + comp2Alignment + "-" + (paddingType != null ? paddingType.ordinal() : 0);
            }
            JComponent comp1 = (JComponent)this.getVisualComponent(comp1Id, false, true);
            JComponent comp2 = (JComponent)this.getVisualComponent(comp2Id, false, true);
            if (comp1 == null || comp2 == null) {
                if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                    FormDesigner.this.getLayoutDesigner().testCode.add("  prefPadding.put(\"" + id + "\", new Integer(10)); // comp1Id-comp2Id-dimension-comp2Alignment-paddingType");
                }
                return 10;
            }
            assert (dimension == 0 || dimension == 1);
            assert (comp2Alignment == 0 || comp2Alignment == 1);
            LayoutStyle.ComponentPlacement type = paddingType == LayoutConstants.PaddingType.INDENT ? LayoutStyle.ComponentPlacement.INDENT : (paddingType == LayoutConstants.PaddingType.RELATED ? LayoutStyle.ComponentPlacement.RELATED : LayoutStyle.ComponentPlacement.UNRELATED);
            int position = 0;
            position = dimension == 0 ? (paddingType == LayoutConstants.PaddingType.INDENT ? (comp2Alignment == 0 ? 7 : 3) : (comp2Alignment == 0 ? 3 : 7)) : (comp2Alignment == 0 ? 5 : 1);
            int n = prefPadding = paddingType != LayoutConstants.PaddingType.SEPARATE ? FormLAF.getDesignerLayoutStyle().getPreferredGap(comp1, comp2, type, position, null) : 18;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  prefPadding.put(\"" + id + "\", new Integer(" + prefPadding + ")); // comp1Id-comp2Id-dimension-comp2Alignment-paddingType");
            }
            return prefPadding;
        }

        @Override
        public int getPreferredPaddingInParent(String parentId, String compId, int dimension, int compAlignment) {
            String id = null;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                id = parentId + "-" + compId + "-" + dimension + "-" + compAlignment;
            }
            JComponent comp = null;
            Container parent = (Container)this.getVisualComponent(parentId, true, false);
            if (parent != null) {
                RADVisualContainer metacont = (RADVisualContainer)this.getMetaComponent(parentId);
                parent = metacont.getContainerDelegate(parent);
                comp = (JComponent)this.getVisualComponent(compId, false, true);
            }
            if (comp == null) {
                if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                    FormDesigner.this.getLayoutDesigner().testCode.add("  prefPaddingInParent.put(\"" + id + "\", new Integer(10)); // parentId-compId-dimension-compAlignment");
                }
                return 10;
            }
            assert (dimension == 0 || dimension == 1);
            assert (compAlignment == 0 || compAlignment == 1);
            int alignment = dimension == 0 ? (compAlignment == 0 ? 7 : 3) : 5;
            int prefPadding = FormLAF.getDesignerLayoutStyle().getContainerGap(comp, alignment, parent);
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  prefPaddingInParent.put(\"" + id + "\", new Integer(" + prefPadding + ")); // parentId-compId-dimension-compAlignment");
            }
            return prefPadding;
        }

        @Override
        public boolean[] getComponentResizability(String compId, boolean[] resizability) {
            resizability[1] = true;
            resizability[0] = true;
            return resizability;
        }

        @Override
        public void rebuildLayout(String contId) {
            RADVisualContainer metacont = (RADVisualContainer)this.getMetaComponent(contId);
            FormDesigner.this.replicator.updateContainerLayout(metacont);
            FormDesigner.this.replicator.getLayoutBuilder(contId).doLayout();
            if (FormDesigner.this.formModel.isCompoundEditInProgress()) {
                FormModelEvent ev = new FormModelEvent(FormDesigner.this.formModel, 5);
                ev.setComponentAndContainer(metacont, metacont);
                FormDesigner.this.formModel.addUndoableEdit(ev.getUndoableEdit());
            }
        }

        @Override
        public void setComponentVisibility(String componentId, boolean visible) {
            Object comp = FormDesigner.this.getComponent(componentId);
            if (comp instanceof Component) {
                Component component = (Component)comp;
                Rectangle bounds = null;
                Rectangle visibleBounds = null;
                if (!visible) {
                    bounds = component.getBounds();
                    visibleBounds = FormUtils.getVisibleRect(component);
                }
                component.setVisible(visible);
                RADComponent metacomp = this.getMetaComponent(componentId);
                FormDesigner.this.handleLayer.updateHiddentComponent(metacomp, bounds, visibleBounds);
            }
        }

        @Override
        public void repaintDesigner(String forComponentId) {
            RADComponent metacomp;
            RADComponent rADComponent = metacomp = FormDesigner.this.formModel != null ? FormDesigner.this.formModel.getMetaComponent(forComponentId) : null;
            if (metacomp instanceof RADVisualComponent && FormDesigner.this.isInDesigner((RADVisualComponent)metacomp)) {
                FormDesigner.this.getHandleLayer().repaint();
            }
        }

        @Override
        public Shape getComponentVisibilityClip(String componentId) {
            Component component = this.getVisualComponent(componentId, true, false);
            if (component == null) {
                return null;
            }
            int x1 = 0;
            int x2 = component.getWidth();
            int y1 = 0;
            int y2 = component.getHeight();
            int cutX1 = 0;
            int cutX2 = 0;
            int cutY1 = 0;
            int cutY2 = 0;
            Component top = FormDesigner.this.getTopDesignComponentView();
            if (component != top) {
                Component comp = component;
                Container parent = comp.getParent();
                while (comp != top) {
                    int outY2;
                    int outX2;
                    if (parent == null) {
                        return null;
                    }
                    if ((x1 += comp.getX()) < cutX1) {
                        cutX1 = x1;
                    }
                    if ((outX2 = (x2 += comp.getX()) - parent.getWidth()) > cutX2) {
                        cutX2 = outX2;
                    }
                    if ((y1 += comp.getY()) < cutY1) {
                        cutY1 = y1;
                    }
                    if ((outY2 = (y2 += comp.getY()) - parent.getHeight()) > cutY2) {
                        cutY2 = outY2;
                    }
                    comp = parent;
                    parent = comp.getParent();
                }
            }
            Rectangle bounds = new Rectangle(x1 - cutX1, y1 - cutY1, x2 - cutX2 - x1 + cutX1, y2 - cutY2 - y1 + cutY1);
            if (bounds.width < 0) {
                bounds.width = 0;
            }
            if (bounds.height < 0) {
                bounds.height = 0;
            }
            return bounds;
        }

        @Override
        public String[] getIndirectSubComponents(String compId) {
            List l;
            RADComponent metacomp = FormDesigner.this.formModel.getMetaComponent(compId);
            if (metacomp instanceof RADVisualContainer && (l = FormDesigner.collectRootLayoutSubComponents((RADVisualContainer)metacomp, null)) != null) {
                return l.toArray(new String[0]);
            }
            return null;
        }

        private RADComponent getMetaComponent(String compId) {
            RADVisualComponent precreated;
            RADComponent metacomp = FormDesigner.this.formModel.getMetaComponent(compId);
            if (metacomp == null && (precreated = FormDesigner.this.formModel.getComponentCreator().getPrecreatedMetaComponent()) != null && precreated.getId().equals(compId)) {
                metacomp = precreated;
            }
            return metacomp;
        }

        private Component getVisualComponent(String compId, boolean needVisible, boolean needJComponent) {
            Object comp = FormDesigner.this.getComponent(compId);
            if (comp == null) {
                RADComponent metacomp;
                RADVisualComponent precreated = FormDesigner.this.formModel.getComponentCreator().getPrecreatedMetaComponent();
                if (precreated != null && precreated.getId().equals(compId)) {
                    comp = precreated.getBeanInstance();
                }
                if (comp == null && !needVisible && (metacomp = this.getMetaComponent(compId)) != null) {
                    comp = metacomp.getBeanInstance();
                }
            }
            Class type = needJComponent ? JComponent.class : Component.class;
            return comp != null && type.isAssignableFrom(comp.getClass()) ? (Component)comp : null;
        }
    }

    private static class FormProxyLookup
    extends ProxyLookup {
        FormProxyLookup() {
        }

        Lookup[] getSubLookups() {
            return this.getLookups();
        }

        void setSubLookups(Lookup[] lookups) {
            this.setLookups(lookups);
        }
    }

    private class AlignAction
    extends AbstractAction {
        private static final String ICON_BASE = "org/netbeans/modules/form/resources/align_";
        private int dimension;
        private int alignment;
        private boolean closed;

        AlignAction(int dimension, int alignment, boolean closed) {
            boolean leading;
            this.dimension = dimension;
            this.alignment = alignment;
            this.closed = closed;
            boolean horizontal = dimension == 0;
            boolean bl = leading = alignment == 0;
            String code = alignment == 2 ? (horizontal ? "ch" : "cv") : (horizontal ? (leading ? "l" : "r") : (leading ? "u" : "d"));
            String iconResource = ICON_BASE + code + ".png";
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)iconResource, (boolean)true));
            this.putValue("ShortDescription", FormUtils.getBundleString("CTL_AlignAction_" + code));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormDesigner.this.align(this.closed, this.dimension, this.alignment);
        }

        public int getDimension() {
            return this.dimension;
        }

        public int getAlignment() {
            return this.alignment;
        }
    }

    private class ResizabilityAction
    extends AbstractAction {
        private static final String ICON_BASE = "org/netbeans/modules/form/resources/resize_";
        private int dimension;

        ResizabilityAction(int dimension) {
            this.dimension = dimension;
            String code = dimension == 0 ? "h" : "v";
            String iconResource = ICON_BASE + code + ".png";
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)iconResource, (boolean)false));
            this.putValue("ShortDescription", FormUtils.getBundleString("CTL_ResizeButton_" + code));
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            FormModel formModel = FormDesigner.this.getFormModel();
            LayoutModel layoutModel = formModel.getLayoutModel();
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            LayoutDesigner layoutDesigner = FormDesigner.this.getLayoutDesigner();
            Collection componentIds = FormDesigner.this.componentIds();
            HashSet<RADVisualContainer> containers = new HashSet<RADVisualContainer>();
            try {
                for (String compId : componentIds) {
                    LayoutComponent layoutComp = layoutModel.getLayoutComponent(compId);
                    boolean resizing = Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
                    if (layoutDesigner.isComponentResizing(layoutComp, this.dimension) == resizing) continue;
                    layoutDesigner.setComponentResizing(layoutComp, this.dimension, resizing);
                    RADVisualComponent comp = (RADVisualComponent)formModel.getMetaComponent(compId);
                    containers.add(comp.getParentContainer());
                }
                autoUndo = false;
            }
            finally {
                Iterator iter = containers.iterator();
                while (iter.hasNext()) {
                    formModel.fireContainerLayoutChanged((RADVisualContainer)iter.next(), null, null, null);
                }
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    formModel.addUndoableEdit(ue);
                }
                if (autoUndo) {
                    formModel.forceUndoOfCompoundEdit();
                }
            }
        }
    }
}

