/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.persistence.api.PersistenceEnvironment;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.util.CustomClassLoader;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;

public class PersistenceEnvironmentImpl
implements PersistenceEnvironment {
    private Project project;
    private WeakReference<CustomClassLoader> loaderRef;

    public PersistenceEnvironmentImpl(Project project) {
        this.project = project;
    }

    public ClassLoader getProjectClassLoader(URL[] classpaths) {
        Object[] oldUrls;
        CustomClassLoader cL;
        CustomClassLoader customClassLoader = new CustomClassLoader(classpaths, this.getClass().getClassLoader());
        if (this.loaderRef != null && (cL = (CustomClassLoader)this.loaderRef.get()) != null && Arrays.equals(oldUrls = cL.getURLs(), classpaths = customClassLoader.getURLs())) {
            return cL;
        }
        this.loaderRef = new WeakReference<CustomClassLoader>(customClassLoader);
        return customClassLoader;
    }

    public List<URL> getProjectClassPath(FileObject projectFile) {
        ArrayList<URL> projectClassPathEntries = new ArrayList<URL>();
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sgs.length < 1) {
            return projectClassPathEntries;
        }
        FileObject sourceRoot = sgs[0].getRootFolder();
        ClassPathProvider cpProv = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        ClassPath cp = cpProv.findClassPath(sourceRoot, "classpath/execute");
        if (cp == null) {
            cp = cpProv.findClassPath(sourceRoot, "classpath/compile");
        }
        for (ClassPath.Entry cpEntry : cp.entries()) {
            if (!cpEntry.isValid()) continue;
            projectClassPathEntries.add(cpEntry.getURL());
        }
        return projectClassPathEntries;
    }

    public List<URL> getProjectClassPath() {
        ArrayList<URL> projectClassPathEntries = new ArrayList<URL>();
        for (SourceGroup sourceGroup : PersistenceEnvironmentImpl.getSourceGroups(this.project)) {
            if (sourceGroup == null) continue;
            ClassPath cp = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
            for (ClassPath.Entry cpEntry : cp.entries()) {
                projectClassPathEntries.add(cpEntry.getURL());
            }
        }
        return projectClassPathEntries;
    }

    public Project getProject() {
        return this.project;
    }

    public FileObject getLocation() {
        return PersistenceLocation.getLocation((Project)this.project);
    }

    private static SourceGroup[] getSourceGroups(Project project) {
        Sources projectSources = ProjectUtils.getSources((Project)project);
        SourceGroup[] resources = projectSources.getSourceGroups("resources");
        if (resources.length > 0) {
            return resources;
        }
        SourceGroup resourcesSourceGroup = SourceGroupModifier.createSourceGroup((Project)project, (String)"resources", (String)"main");
        if (resourcesSourceGroup != null) {
            return new SourceGroup[]{resourcesSourceGroup};
        }
        return projectSources.getSourceGroups("java");
    }
}

