/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.editor.base.semantic.UnusedDetector;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;

public class Unused {
    private static final boolean DETECT_UNUSED_PACKAGE_PRIVATE_DEFAULT = true;
    public static final String DETECT_UNUSED_PACKAGE_PRIVATE = "detect.unused.package.private";

    public static List<ErrorDescription> unused(HintContext ctx) {
        List unused = UnusedDetector.findUnused((CompilationInfo)ctx.getInfo(), () -> ctx.isCanceled());
        if (unused.isEmpty()) {
            return null;
        }
        boolean detectUnusedPackagePrivate = Unused.getTaskCachedBoolean(ctx, DETECT_UNUSED_PACKAGE_PRIVATE, true);
        for (UnusedDetector.UnusedDescription ud : unused) {
            if (ctx.isCanceled()) break;
            if (ud.unusedElementPath.getLeaf() != ctx.getPath().getLeaf() || !detectUnusedPackagePrivate && ud.packagePrivate) continue;
            ErrorDescription err = Unused.convertUnused(ctx, ud);
            if (err == null) break;
            return List.of(err);
        }
        return null;
    }

    private static boolean getTaskCachedBoolean(HintContext ctx, String key, boolean defaultVal) {
        Object cached = ctx.getInfo().getCachedValue((Object)key);
        if (cached instanceof Boolean) {
            Boolean val = (Boolean)cached;
            return val;
        }
        boolean fromPrefs = ctx.getPreferences().getBoolean(key, defaultVal);
        ctx.getInfo().putCachedValue((Object)key, (Object)fromPrefs, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        return fromPrefs;
    }

    private static ErrorDescription convertUnused(HintContext ctx, UnusedDetector.UnusedDescription ud) {
        String message;
        String name = ud.unusedElement.getSimpleName().toString();
        Fix fix = null;
        switch (ud.reason) {
            case NOT_WRITTEN_READ: {
                message = Bundle.ERR_NeitherReadOrWritten(name);
                fix = JavaFixUtilities.removeFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveUsedElement(name), (TreePath)ud.unusedElementPath);
                break;
            }
            case NOT_WRITTEN: {
                message = Bundle.ERR_NotWritten(name);
                break;
            }
            case NOT_READ: {
                message = Bundle.ERR_NotRead(name);
                if (ud.unusedElementPath.getParentPath().getLeaf().getKind() == Tree.Kind.BINDING_PATTERN) break;
                fix = JavaFixUtilities.safelyRemoveFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveUsedElement(name), (TreePath)ud.unusedElementPath);
                break;
            }
            case NOT_USED: {
                if (ud.unusedElement.getKind() == ElementKind.CONSTRUCTOR) {
                    message = Bundle.ERR_NotUsedConstructor();
                    fix = JavaFixUtilities.removeFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveUsedConstructor(), (TreePath)ud.unusedElementPath);
                    break;
                }
                message = Bundle.ERR_NotUsed(name);
                fix = JavaFixUtilities.removeFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveUsedElement(name), (TreePath)ud.unusedElementPath);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown unused type: " + ud.reason);
            }
        }
        return fix != null ? ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ud.unusedElementPath, (String)message, (Fix[])new Fix[]{fix}) : ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ud.unusedElementPath, (String)message, (Fix[])new Fix[0]);
    }
}

