/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.project;

import java.awt.Image;
import org.netbeans.modules.cordova.project.Bundle;
import org.netbeans.modules.cordova.project.CordovaBrowser;
import org.netbeans.modules.cordova.project.CordovaURLMapper;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperImplementation;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperProvider;
import org.netbeans.modules.web.browser.spi.EnhancedBrowserFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public abstract class CordovaBrowserFactory
implements EnhancedBrowserFactory,
HtmlBrowser.Factory,
BrowserURLMapperProvider {
    private CordovaURLMapper mapper;

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        return new CordovaBrowser();
    }

    public BrowserFamilyId getBrowserFamilyId() {
        return BrowserFamilyId.PHONEGAP;
    }

    public BrowserURLMapperImplementation getBrowserURLMapper() {
        if (this.mapper == null) {
            this.mapper = new CordovaURLMapper();
        }
        return this.mapper;
    }

    public BrowserURLMapperImplementation.BrowserURLMapper getMapper() {
        return ((CordovaURLMapper)this.getBrowserURLMapper()).getBrowserURLMapper();
    }

    public static class AndroidEmulator
    extends CordovaBrowserFactory {
        public Image getIconImage(boolean small) {
            return ImageUtilities.loadImage((String)("org/netbeans/modules/cordova/resources/androidemulator" + (small ? "16.png" : ".png")), (boolean)false);
        }

        public String getDisplayName() {
            return Bundle.LBL_CordovaAndroidEmulator();
        }

        public String getId() {
            return "android";
        }

        public boolean hasNetBeansIntegration() {
            return false;
        }

        public boolean canCreateHtmlBrowserImpl() {
            return true;
        }

        public static class AndroidDevice
        extends CordovaBrowserFactory {
            public Image getIconImage(boolean small) {
                return ImageUtilities.loadImage((String)("org/netbeans/modules/cordova/resources/androiddevice" + (small ? "16.png" : ".png")), (boolean)false);
            }

            public String getDisplayName() {
                return Bundle.LBL_CordovaAndroidDevice();
            }

            public String getId() {
                return "android_1";
            }

            public boolean hasNetBeansIntegration() {
                return false;
            }

            public boolean canCreateHtmlBrowserImpl() {
                return true;
            }
        }
    }

    public static class IOSSimulator
    extends CordovaBrowserFactory {
        public Image getIconImage(boolean small) {
            return ImageUtilities.loadImage((String)("org/netbeans/modules/cordova/resources/iossimulator" + (small ? "16.png" : ".png")), (boolean)false);
        }

        public String getDisplayName() {
            return Bundle.LBL_CordovaIOSSimulator();
        }

        public String getId() {
            return "ios";
        }

        public boolean hasNetBeansIntegration() {
            return true;
        }

        public boolean canCreateHtmlBrowserImpl() {
            return Utilities.isMac();
        }
    }

    public static class IOSDevice
    extends CordovaBrowserFactory {
        public Image getIconImage(boolean small) {
            return ImageUtilities.loadImage((String)("org/netbeans/modules/cordova/resources/iosdevice" + (small ? "16.png" : ".png")), (boolean)false);
        }

        public String getDisplayName() {
            return Bundle.LBL_CordovaIOSDevice();
        }

        public String getId() {
            return "ios_1";
        }

        public boolean hasNetBeansIntegration() {
            return true;
        }

        public boolean canCreateHtmlBrowserImpl() {
            return Utilities.isMac();
        }
    }
}

